/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.misc;

import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;

public class Util {
    public static final String SEPARATOR = ".";
    public static final String TAB = "\t";
    public static final int NULL_INTEGER = -1;

    public static double millisecondToBeatLength(double d, double d2) {
        double d3 = Util.bpmToBeatTime(d2);
        return Util.castDouble(1.0 / (d3 / d));
    }

    public static void main(String[] stringArray) {
        int n = 50;
        int n2 = 120;
        System.out.println(n + " ms means " + Util.millisecondToBeatLength(n, n2) + " in BPM " + n2 + SEPARATOR);
    }

    public static String combineFilePath(File file, String string) {
        return file + "/" + string;
    }

    public static double beatTimeToBPM(double d) {
        return Util.castDouble(1000.0 / d * 60.0);
    }

    public static double bpmToBeatTime(double d) {
        return Util.castDouble(1000.0 / (d / 60.0));
    }

    public static double castDouble(double d) {
        int n = (int)(d * 1000.0 + 0.5);
        return (double)n / 1000.0;
    }

    public static ImageIcon createImageIcon(String string) {
        URL uRL = Util.class.getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    public static void err(String string) {
        System.err.println(string);
    }

    public static void errorAndExit(String string) {
        Util.err(string);
        System.exit(1);
    }

    public static String getNoteName(int n) {
        String string = "";
        if (n == 0) {
            return "Rest";
        }
        int n2 = n % 12;
        int n3 = n / 12 - 1;
        switch (n2) {
            case 0: {
                string = "C";
                break;
            }
            case 1: {
                string = "C#";
                break;
            }
            case 2: {
                string = "D";
                break;
            }
            case 3: {
                string = "D#";
                break;
            }
            case 4: {
                string = "E";
                break;
            }
            case 5: {
                string = "F";
                break;
            }
            case 6: {
                string = "F#";
                break;
            }
            case 7: {
                string = "G";
                break;
            }
            case 8: {
                string = "G#";
                break;
            }
            case 9: {
                string = "A";
                break;
            }
            case 10: {
                string = "A#";
                break;
            }
            case 11: {
                string = "B";
            }
        }
        return string + n3;
    }

    public static String getExtension(File file) {
        String string = null;
        string = Util.getExtension(file.getName());
        return string;
    }

    public static String getExtension(String string) {
        String string2 = null;
        int n = string.lastIndexOf(SEPARATOR);
        if (n > 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1).toLowerCase();
        }
        return string2;
    }

    public static String getNameExceptExtension(String string) {
        return string.replace(SEPARATOR + Util.getExtension(string), "");
    }

    public static boolean isSmallerThan(double d, double d2) {
        return d * d > d2 * d2;
    }

    public static String setExtension(String string, String string2) {
        return string + SEPARATOR + string2;
    }

    public static final String fifthsToString(int n) {
        switch (n) {
            case 0: {
                return "C";
            }
            case 1: {
                return "G";
            }
            case 2: {
                return "D";
            }
            case 3: {
                return "A";
            }
            case 4: {
                return "E";
            }
            case 5: {
                return "B";
            }
            case 6: {
                return "F#";
            }
            case 7: {
                return "C#";
            }
            case 8: {
                return "G#";
            }
            case 9: {
                return "D#";
            }
            case 10: {
                return "A#";
            }
            case 11: {
                return "E#";
            }
            case -1: {
                return "F";
            }
            case -2: {
                return "Bb";
            }
            case -3: {
                return "Eb";
            }
            case -4: {
                return "Ab";
            }
            case -5: {
                return "Db";
            }
            case -6: {
                return "Gb";
            }
            case -7: {
                return "Cb";
            }
            case -8: {
                return "Fb";
            }
            case -9: {
                return "Bbb";
            }
            case -10: {
                return "Ebb";
            }
            case -11: {
                return "Abb";
            }
        }
        throw new NumberFormatException();
    }

    public static int getNoteNumber(String string) {
        int n = 0;
        if (string.length() == 0 || string.equalsIgnoreCase("rest")) {
            return 0;
        }
        int n2 = Util.getNoteScale(string.charAt(0));
        if (string.length() >= 3) {
            switch (string.charAt(1)) {
                case 'S': {
                    n = 2;
                    break;
                }
                case '#': {
                    n = 1;
                    break;
                }
                case 'b': {
                    n = -1;
                    break;
                }
                case 'B': {
                    n = -2;
                }
            }
        }
        String string2 = string.substring(string.length() - 1);
        return (Integer.parseInt(string2) + 1) * 12 + (n2 + n);
    }

    public static int getNoteScale(char c) {
        int n = 0;
        switch (c) {
            case 'C': {
                n = 0;
                break;
            }
            case 'D': {
                n = 2;
                break;
            }
            case 'E': {
                n = 4;
                break;
            }
            case 'F': {
                n = 5;
                break;
            }
            case 'G': {
                n = 7;
                break;
            }
            case 'A': {
                n = 9;
                break;
            }
            case 'B': {
                n = 11;
            }
        }
        return n;
    }
}

