/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.filewrappers;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jp.crestmuse.cmx.amusaj.filewrappers.Base64;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.NodeInterface;
import org.w3c.dom.Node;

public abstract class ByteArrayNodeInterface
extends NodeInterface {
    private int bytesize = this.getAttributeInt("bytesize");
    private ByteBuffer buff = ByteBuffer.wrap(Base64.decode(this.getText()));
    private static final Base64 base64 = new Base64();

    protected ByteArrayNodeInterface(Node node) {
        super(node);
    }

    protected final int lengthInByte() {
        return this.bytesize;
    }

    protected final int lengthInShort() {
        return this.bytesize / 2;
    }

    protected final int lengthInInt() {
        return this.bytesize / 4;
    }

    protected byte[] getByteArray() {
        byte[] byArray = new byte[this.lengthInByte()];
        this.buff.get(byArray);
        return byArray;
    }

    protected short[] getUnsignedByteArray() {
        short[] sArray = new short[this.lengthInByte()];
        for (int i = 0; i < sArray.length; ++i) {
            byte by = this.buff.get();
            sArray[i] = by < 0 ? (short)(by + 128) : (short)by;
        }
        return sArray;
    }

    protected short[] getShortArray() {
        short[] sArray = new short[this.lengthInShort()];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = this.buff.getShort();
        }
        return sArray;
    }

    protected int[] getUnsignedShortArray() {
        int[] nArray = new int[this.lengthInShort()];
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.buff.getShort();
            nArray[i] = n < 0 ? n + 32768 : n;
        }
        return nArray;
    }

    protected int[] getIntArray() {
        int[] nArray = new int[this.lengthInInt()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.buff.getInt();
        }
        return nArray;
    }

    protected void setByteOrder(ByteOrder byteOrder) {
        this.buff.order(byteOrder);
    }

    public static void addByteArrayToWrapper(byte[] byArray, String string, CMXFileWrapper cMXFileWrapper) {
        String string2 = Base64.encode(byArray);
        cMXFileWrapper.addChild(string);
        cMXFileWrapper.setAttribute("bytesize", byArray.length);
        cMXFileWrapper.addText(string2);
    }
}

