/* ------------------------------------------------------------------------- */
/*
 *  range.h
 *
 *  Copyright (c) 2004 - 2009, clown. All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    - Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    - Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *    - No names of its contributors may be used to endorse or promote
 *      products derived from this software without specific prior written
 *      permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 *  Distributed under the Boost Software License, Version 1.0. (See
 *  accompanying file LICENSE_1_0.txt or copy at
 *  http://www.boost.org/LICENSE_1_0.txt)
 *
 *  Last-modified: Sat 12 Dec 2009 07:28:00 JST
 */
/* ------------------------------------------------------------------------- */
#ifndef CLX_RANGE_H
#define CLX_RANGE_H

namespace clx {
	/* --------------------------------------------------------------------- */
	//  range_value
	/* --------------------------------------------------------------------- */
	template <class Container>
	struct range_value {
		typedef typename Container::value_type type;
	};
	
	/* --------------------------------------------------------------------- */
	//  range_value
	/* --------------------------------------------------------------------- */
	template <class Container>
	struct range_value<const Container> {
		typedef typename Container::value_type type;
	};
	
	/* --------------------------------------------------------------------- */
	//  range_value
	/* --------------------------------------------------------------------- */
	template <class T, std::size_t N>
	struct range_value<T[N]> {
		typedef T type;
	};
	
	/* --------------------------------------------------------------------- */
	//  range_value
	/* --------------------------------------------------------------------- */
	template <class T, std::size_t N>
	struct range_value<const T[N]> {
		typedef T type;
	};
	
	/* --------------------------------------------------------------------- */
	//  range_iterator
	/* --------------------------------------------------------------------- */
	template <class Container>
	struct range_iterator {
		typedef typename Container::iterator type;
	};
	
	/* --------------------------------------------------------------------- */
	//  range_iterator
	/* --------------------------------------------------------------------- */
	template <class Container>
	struct range_iterator<const Container> {
		typedef typename Container::const_iterator type;
	};
	
	/* --------------------------------------------------------------------- */
	//  range_iterator
	/* --------------------------------------------------------------------- */
	template <class T, std::size_t N>
	struct range_iterator<T[N]> {
		typedef T* type;
	};
	
	/* --------------------------------------------------------------------- */
	//  range_iterator
	/* --------------------------------------------------------------------- */
	template <class T, std::size_t N>
	struct range_iterator<const T[N]> {
		typedef const T* type;
	};
	
	/* --------------------------------------------------------------------- */
	//  range_reverse_iterator
	/* --------------------------------------------------------------------- */
	template <class Container>
	struct range_reverse_iterator {
		typedef typename Container::reverse_iterator type;
	};
	
	/* --------------------------------------------------------------------- */
	//  range_reverse_iterator
	/* --------------------------------------------------------------------- */
	template <class Container>
	struct range_reverse_iterator<const Container> {
		typedef typename Container::const_reverse_iterator type;
	};
	
	/* --------------------------------------------------------------------- */
	//  range_reverse_iterator
	/* --------------------------------------------------------------------- */
	template <class T, std::size_t N>
	struct range_reverse_iterator<T[N]> {
		typedef T* type;
	};
	
	/* --------------------------------------------------------------------- */
	//  range_reverse_iterator
	/* --------------------------------------------------------------------- */
	template <class T, std::size_t N>
	struct range_reverse_iterator<const T[N]> {
		typedef const T* type;
	};
	
	/* --------------------------------------------------------------------- */
	//  begin
	/* --------------------------------------------------------------------- */
	template <class Container>
	typename range_iterator<Container>::type begin(Container& c) {
		return c.begin();
	}
	
	/* --------------------------------------------------------------------- */
	//  begin
	/* --------------------------------------------------------------------- */
	template <class T, std::size_t N>
	typename range_iterator<T[N]>::type begin(T (&ar)[N]) {
		return ar;
	}
	
	/* --------------------------------------------------------------------- */
	//  end
	/* --------------------------------------------------------------------- */
	template <class Container>
	typename range_iterator<Container>::type end(Container& c) {
		return c.end();
	}
	
	/* --------------------------------------------------------------------- */
	//  end
	/* --------------------------------------------------------------------- */
	template <class T, std::size_t N>
	typename range_iterator<T[N]>::type end(T (&ar)[N]) {
		return ar + N;
	}
} // namespace clx

#endif // CLX_RANGE_H
