/* ------------------------------------------------------------------------- */
/*
 *  example_bitmask.cpp
 *
 *  Copyright (c) 2004 - 2009, clown. All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    - Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    - Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *    - No names of its contributors may be used to endorse or promote
 *      products derived from this software without specific prior written
 *      permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  Last-modified: Tue 16 Jun 2009 18:13:00 JST
 */
/* ------------------------------------------------------------------------- */
#include <iostream>
#include <iomanip>
#include "clx/utility.h"

int main(int argc, char* argv[]) {
	std::cout << std::hex << std::showbase;
	
	std::cout << "2 bit mask:" << std::endl;
	std::cout << clx::bitmask<2>::upper << std::endl;
	std::cout << clx::bitmask<2>::lower << std::endl;
	std::cout << std::endl;
	std::cout << "10 bit mask:" << std::endl;
	std::cout << clx::bitmask<10>::upper << std::endl;
	std::cout << clx::bitmask<10>::lower << std::endl;
	std::cout << std::endl;
	std::cout << "15 bit mask:" << std::endl;
	std::cout << clx::bitmask<15>::upper << std::endl;
	std::cout << clx::bitmask<15>::lower << std::endl;
	std::cout << std::endl;
	std::cout << "16 bit mask:" << std::endl;
	std::cout << clx::bitmask<16>::upper << std::endl;
	std::cout << clx::bitmask<16>::lower << std::endl;
	std::cout << std::endl;
	std::cout << "31 bit mask:" << std::endl;
	std::cout << clx::bitmask<31>::upper << std::endl;
	std::cout << clx::bitmask<31>::lower << std::endl;
	
	return 0;
}
