/* ------------------------------------------------------------------------- */
/*
 *  zfilter.h
 *
 *  Copyright (c) 2004 - 2008, clown. All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    - Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    - Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *    - No names of its contributors may be used to endorse or promote
 *      products derived from this software without specific prior written
 *      permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  Copyright (C) 1995-2005 Jean-loup Gailly and Mark Adler.
 *
 *  The source code is derived from zlib.
 *  (See the following URL: http://zlib.net/zlib_license.html)
 *
 *  Last-modified: Mon 09 Feb 2009 21:18:00 JST
 */
/* ------------------------------------------------------------------------- */
#ifndef CLX_ZFILTER_H
#define CLX_ZFILTER_H

#include <istream>
#include <ostream>
#include <string>
#include "zbuf.h"

namespace clx {
	/* --------------------------------------------------------------------- */
	//  basic_izfilter
	/* --------------------------------------------------------------------- */
	template <
		class CharT = char,
		class Traits = std::char_traits<CharT>
	>
	class basic_izfilter : public std::basic_istream<CharT, Traits> {
	public:
		typedef std::basic_istream<CharT, Traits> stream_type;
		typedef basic_zdecompressbuf<CharT, Traits> zbuf_type;
		typedef typename zbuf_type::size_type size_type;
		
		basic_izfilter(stream_type& in, size_type n = 4096) :
			stream_type(0), zbuf_(in, n) {
			this->rdbuf(&zbuf_);
		}
		
		virtual ~basic_izfilter() throw() { this->rdbuf(0); }
		
	private:
		zbuf_type zbuf_;
	};
	
	/* --------------------------------------------------------------------- */
	//  basic_ozfilter
	/* --------------------------------------------------------------------- */
	template <
		int CompressRate,
		class CharT = char,
		class Traits = std::char_traits<CharT>
	>
	class basic_ozfilter : public std::basic_ostream<CharT, Traits> {
	public:
		typedef std::basic_ostream<CharT, Traits> stream_type;
		typedef basic_zcompressbuf<CompressRate, CharT, Traits> zbuf_type;
		typedef typename zbuf_type::size_type size_type;
		
		basic_ozfilter(stream_type& out, size_type n = 4096) :
			stream_type(0), zbuf_(out, n) {
			this->rdbuf(&zbuf_);
		}
		
		virtual ~basic_ozfilter() throw() {
			this->finish();
			this->rdbuf(0);
		}
		
		void finish() { zbuf_.finish(); }
		
	private:
		zbuf_type zbuf_;
	};
	
	typedef basic_izfilter<char> izfilter;
	typedef basic_ozfilter<Z_DEFAULT_COMPRESSION, char> ozfilter;
}

#endif // CLX_ZFILTER_H
