/* ------------------------------------------------------------------------- */
/*
 *  example_constrained_value.cpp
 *
 *  Copyright (c) 2004 - 2008, clown. All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    - Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    - Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *    - No names of its contributors may be used to endorse or promote
 *      products derived from this software without specific prior written
 *      permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  Last-modified: Mon 07 Jul 2008 10:56:00 JST
 */
/* ------------------------------------------------------------------------- */
#include <iostream>
#include "clx/constrained_value.h"

int main(int argc, char* argv[])
{
	clx::constrained_value<clx::ranged_integer<0, 100> > x;
	clx::constrained_value<clx::ranged_integer<0, 100> > y;
	clx::constrained_value<clx::ranged_integer<0, 50> > z;
	
	try {
		std::cout << "1st example." << std::endl;
		x = 32;
		std::cout << "x = " << x << std::endl;
		y = 8;
		std::cout << "y = " << y << std::endl;
		y += x + 51 - (2 * 4);
		std::cout << "y = " << y << std::endl;
	}
	catch (std::range_error& e) {
		std::cerr << "exception: " << e.what() << std::endl;
	}
	
	std::cout << std::endl;
	
	try {
		std::cout << "2nd example." << std::endl;
		x = 32;
		std::cout << "x = " << x << std::endl;
		z = 8;
		std::cout << "z = " << z << std::endl;
		z += z.value() + 51 - (2 * 4);
		std::cout << "z = " << z << std::endl;
	}
	catch (std::range_error& e) {
		std::cerr << "exception: " << e.what() << std::endl;
	}
	
	return 0;
}
