#!/bin/sh

# $Id$

# グローバル変数
ProjectDir=`dirname $0`
if [ "${ProjectDir}" = '.' ]; then
	ProjectDir=`pwd`
elif [ "${ProjectDir}" = '..' ]; then
	ProjectDir=`pwd`
	ProjectDir=`dirname "${ProjectDir}"`
fi
ProjectName=`basename "${ProjectDir}"`
DiskImageImageDir="${ProjectDir}/DiskImage"
Version=`sed '1,/<key>CFBundleShortVersionString<\/key>/d' "${DiskImageImageDir}/${ProjectName}.pkg/Contents/Info.plist" | head -1 | sed 's/.*<string>\(.*\)<\/string>.*/\1/'`

# ディスクイメージ作成
rm -f "${ProjectDir}/${ProjectName}-${Version}.dmg"
hdiutil create -srcfolder "${DiskImageImageDir}" -fs HFS+ -volname "${ProjectName}-${Version}" "${ProjectDir}/${ProjectName}-${Version}.dmg"
