/*
    ChibiOS - Copyright (C) 2015 RedoX https://github.com/RedoXyde

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
*/

#ifndef _BOARD_H_
#define _BOARD_H_

/*
 * Setup for the PJRC Teensy 4.1 board.
 */

/*
 * Board identifier.
 */
#define BOARD_PJRC_TEENSY_4_1
#define BOARD_NAME                  "PJRC Teensy 4.1"

// TODO: correct clock values

/* External 16 MHz crystal */
#define KINETIS_XTAL_FREQUENCY      16000000UL 

/* Use internal capacitors for the crystal */
#define KINETIS_BOARD_OSCILLATOR_SETTING OSC0_CR_SC8P_SET(1) | OSC0_CR_SC2P_SET(1) | OSC0_CR_ERCLKEN_SET(1)

/*
 * MCU type
 */
#define MIMXRT1062

/*
 * IO pins assignments.
 *
 * These come from (with light string replacement from CORE_ to TEENSY_ for
 * consistency with the Teensy 3.6 port):
 * https://github.com/PaulStoffregen/cores/blob/master/teensy4/core_pins.h
 *
 */

// We expose teensy pin numbers
#define TEENSY_PIN0 0
#define TEENSY_PIN1 1
#define TEENSY_PIN2 2
#define TEENSY_PIN3 3
#define TEENSY_PIN4 4
#define TEENSY_PIN5 5
#define TEENSY_PIN6 6
#define TEENSY_PIN7 7
#define TEENSY_PIN8 8
#define TEENSY_PIN9 9
#define TEENSY_PIN10 10
#define TEENSY_PIN11 11
#define TEENSY_PIN12 12
#define TEENSY_PIN13 13
#define TEENSY_PIN14 14
#define TEENSY_PIN15 15
#define TEENSY_PIN16 16
#define TEENSY_PIN17 17
#define TEENSY_PIN18 18
#define TEENSY_PIN19 19
#define TEENSY_PIN20 20
#define TEENSY_PIN21 21
#define TEENSY_PIN22 22
#define TEENSY_PIN23 23
#define TEENSY_PIN24 24
#define TEENSY_PIN25 25
#define TEENSY_PIN26 26
#define TEENSY_PIN27 27
#define TEENSY_PIN28 28
#define TEENSY_PIN29 29
#define TEENSY_PIN30 30
#define TEENSY_PIN31 31
#define TEENSY_PIN32 32
#define TEENSY_PIN33 33
#define TEENSY_PIN34 34
#define TEENSY_PIN35 35
#define TEENSY_PIN36 36
#define TEENSY_PIN37 37
#define TEENSY_PIN38 38
#define TEENSY_PIN39 39
#define TEENSY_PIN40 40
#define TEENSY_PIN41 41
#define TEENSY_PIN42 42
#define TEENSY_PIN43 43
#define TEENSY_PIN44 44
#define TEENSY_PIN45 45
#define TEENSY_PIN46 46
#define TEENSY_PIN47 47
#define TEENSY_PIN48 48
#define TEENSY_PIN49 49
#define TEENSY_PIN50 50
#define TEENSY_PIN51 51
#define TEENSY_PIN52 52
#define TEENSY_PIN53 53
#define TEENSY_PIN54 54

#define TEENSY_PIN0_BIT           3
#define TEENSY_PIN1_BIT           2
#define TEENSY_PIN2_BIT           4
#define TEENSY_PIN3_BIT           5
#define TEENSY_PIN4_BIT           6
#define TEENSY_PIN5_BIT           8
#define TEENSY_PIN6_BIT           10
#define TEENSY_PIN7_BIT           17
#define TEENSY_PIN8_BIT           16
#define TEENSY_PIN9_BIT           11
#define TEENSY_PIN10_BIT          0
#define TEENSY_PIN11_BIT          2
#define TEENSY_PIN12_BIT          1
#define TEENSY_PIN13_BIT          3
#define TEENSY_PIN14_BIT          18
#define TEENSY_PIN15_BIT          19
#define TEENSY_PIN16_BIT          23
#define TEENSY_PIN17_BIT          22
#define TEENSY_PIN18_BIT          17
#define TEENSY_PIN19_BIT          16
#define TEENSY_PIN20_BIT          26
#define TEENSY_PIN21_BIT          27
#define TEENSY_PIN22_BIT          24
#define TEENSY_PIN23_BIT          25
#define TEENSY_PIN24_BIT          12
#define TEENSY_PIN25_BIT          13
#define TEENSY_PIN26_BIT          30
#define TEENSY_PIN27_BIT          31
#define TEENSY_PIN28_BIT          18
#define TEENSY_PIN29_BIT          31
#define TEENSY_PIN30_BIT          23
#define TEENSY_PIN31_BIT          22
#define TEENSY_PIN32_BIT          12
#define TEENSY_PIN33_BIT          7
#define TEENSY_PIN34_BIT          29
#define TEENSY_PIN35_BIT          28
#define TEENSY_PIN36_BIT          18
#define TEENSY_PIN37_BIT          19
#define TEENSY_PIN38_BIT          28
#define TEENSY_PIN39_BIT          29
#define TEENSY_PIN40_BIT          20
#define TEENSY_PIN41_BIT          21
#define TEENSY_PIN42_BIT          15
#define TEENSY_PIN43_BIT          14
#define TEENSY_PIN44_BIT          13
#define TEENSY_PIN45_BIT          12
#define TEENSY_PIN46_BIT          17
#define TEENSY_PIN47_BIT          16
#define TEENSY_PIN48_BIT          24
#define TEENSY_PIN49_BIT          27
#define TEENSY_PIN50_BIT          28
#define TEENSY_PIN51_BIT          22
#define TEENSY_PIN52_BIT          26
#define TEENSY_PIN53_BIT          25
#define TEENSY_PIN54_BIT          29

#define TEENSY_PIN0_IOPORT        GPIO6
#define TEENSY_PIN1_IOPORT        GPIO6
#define TEENSY_PIN2_IOPORT        GPIO9
#define TEENSY_PIN3_IOPORT        GPIO9
#define TEENSY_PIN4_IOPORT        GPIO9
#define TEENSY_PIN5_IOPORT        GPIO9
#define TEENSY_PIN6_IOPORT        GPIO7
#define TEENSY_PIN7_IOPORT        GPIO7
#define TEENSY_PIN8_IOPORT        GPIO7
#define TEENSY_PIN9_IOPORT        GPIO7
#define TEENSY_PIN10_IOPORT       GPIO7
#define TEENSY_PIN11_IOPORT       GPIO7
#define TEENSY_PIN12_IOPORT       GPIO7
#define TEENSY_PIN13_IOPORT       GPIO7
#define TEENSY_PIN14_IOPORT       GPIO6
#define TEENSY_PIN15_IOPORT       GPIO6
#define TEENSY_PIN16_IOPORT       GPIO6
#define TEENSY_PIN17_IOPORT       GPIO6
#define TEENSY_PIN18_IOPORT       GPIO6
#define TEENSY_PIN19_IOPORT       GPIO6
#define TEENSY_PIN20_IOPORT       GPIO6
#define TEENSY_PIN21_IOPORT       GPIO6
#define TEENSY_PIN22_IOPORT       GPIO6
#define TEENSY_PIN23_IOPORT       GPIO6
#define TEENSY_PIN24_IOPORT       GPIO6
#define TEENSY_PIN25_IOPORT       GPIO6
#define TEENSY_PIN26_IOPORT       GPIO6
#define TEENSY_PIN27_IOPORT       GPIO6
#define TEENSY_PIN28_IOPORT       GPIO8
#define TEENSY_PIN29_IOPORT       GPIO9
#define TEENSY_PIN30_IOPORT       GPIO8
#define TEENSY_PIN31_IOPORT       GPIO8
#define TEENSY_PIN32_IOPORT       GPIO7
#define TEENSY_PIN33_IOPORT       GPIO9
#define TEENSY_PIN34_IOPORT       GPIO7
#define TEENSY_PIN35_IOPORT       GPIO7
#define TEENSY_PIN36_IOPORT       GPIO7
#define TEENSY_PIN37_IOPORT       GPIO7
#define TEENSY_PIN38_IOPORT       GPIO6
#define TEENSY_PIN39_IOPORT       GPIO6
#define TEENSY_PIN40_IOPORT       GPIO6
#define TEENSY_PIN41_IOPORT       GPIO6
#define TEENSY_PIN42_IOPORT       GPIO8
#define TEENSY_PIN43_IOPORT       GPIO8
#define TEENSY_PIN44_IOPORT       GPIO8
#define TEENSY_PIN45_IOPORT       GPIO8
#define TEENSY_PIN46_IOPORT       GPIO8
#define TEENSY_PIN47_IOPORT       GPIO8
#define TEENSY_PIN48_IOPORT       GPIO9
#define TEENSY_PIN49_IOPORT       GPIO9
#define TEENSY_PIN50_IOPORT       GPIO9
#define TEENSY_PIN51_IOPORT       GPIO9
#define TEENSY_PIN52_IOPORT       GPIO9
#define TEENSY_PIN53_IOPORT       GPIO9
#define TEENSY_PIN54_IOPORT       GPIO9

// mux config registers control which peripheral uses the pin
#define TEENSY_PIN0_MUX        kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B0_03
#define TEENSY_PIN1_MUX        kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B0_02
#define TEENSY_PIN2_MUX        kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_04
#define TEENSY_PIN3_MUX        kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_05
#define TEENSY_PIN4_MUX        kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_06
#define TEENSY_PIN5_MUX        kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_08
#define TEENSY_PIN6_MUX        kIOMUXC_SW_MUX_CTL_PAD_GPIO_B0_10
#define TEENSY_PIN7_MUX        kIOMUXC_SW_MUX_CTL_PAD_GPIO_B1_01
#define TEENSY_PIN8_MUX        kIOMUXC_SW_MUX_CTL_PAD_GPIO_B1_00
#define TEENSY_PIN9_MUX        kIOMUXC_SW_MUX_CTL_PAD_GPIO_B0_11
#define TEENSY_PIN10_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_B0_00
#define TEENSY_PIN11_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_B0_02
#define TEENSY_PIN12_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_B0_01
#define TEENSY_PIN13_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_B0_03
#define TEENSY_PIN14_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_02
#define TEENSY_PIN15_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_03
#define TEENSY_PIN16_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_07
#define TEENSY_PIN17_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_06
#define TEENSY_PIN18_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_01
#define TEENSY_PIN19_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_00
#define TEENSY_PIN20_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_10
#define TEENSY_PIN21_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_11
#define TEENSY_PIN22_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_08
#define TEENSY_PIN23_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_09
#define TEENSY_PIN24_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B0_12
#define TEENSY_PIN25_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B0_13
#define TEENSY_PIN26_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_14
#define TEENSY_PIN27_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_15
#define TEENSY_PIN28_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_32
#define TEENSY_PIN29_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_31
#define TEENSY_PIN30_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_37
#define TEENSY_PIN31_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_36
#define TEENSY_PIN32_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_B0_12
#define TEENSY_PIN33_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_07
#define TEENSY_PIN34_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_B1_13
#define TEENSY_PIN35_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_B1_12
#define TEENSY_PIN36_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_B1_02
#define TEENSY_PIN37_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_B1_03
#define TEENSY_PIN38_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_12
#define TEENSY_PIN39_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_13
#define TEENSY_PIN40_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_04
#define TEENSY_PIN41_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_05
#define TEENSY_PIN42_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_03
#define TEENSY_PIN43_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_02
#define TEENSY_PIN44_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_01
#define TEENSY_PIN45_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_00
#define TEENSY_PIN46_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_05
#define TEENSY_PIN47_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_04
#define TEENSY_PIN48_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_24
#define TEENSY_PIN49_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_27
#define TEENSY_PIN50_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_28
#define TEENSY_PIN51_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_22
#define TEENSY_PIN52_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_26
#define TEENSY_PIN53_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_25
#define TEENSY_PIN54_MUX       kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_29

// pad config registers control pullup/pulldown/keeper, drive strength, etc
#define TEENSY_PIN0_PAD     kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B0_03
#define TEENSY_PIN1_PAD     kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B0_02
#define TEENSY_PIN2_PAD     kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_04
#define TEENSY_PIN3_PAD     kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_05
#define TEENSY_PIN4_PAD     kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_06
#define TEENSY_PIN5_PAD     kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_08
#define TEENSY_PIN6_PAD     kIOMUXC_SW_PAD_CTL_PAD_GPIO_B0_10
#define TEENSY_PIN7_PAD     kIOMUXC_SW_PAD_CTL_PAD_GPIO_B1_01
#define TEENSY_PIN8_PAD     kIOMUXC_SW_PAD_CTL_PAD_GPIO_B1_00
#define TEENSY_PIN9_PAD     kIOMUXC_SW_PAD_CTL_PAD_GPIO_B0_11
#define TEENSY_PIN10_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_B0_00
#define TEENSY_PIN11_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_B0_02
#define TEENSY_PIN12_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_B0_01
#define TEENSY_PIN13_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_B0_03
#define TEENSY_PIN14_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_02
#define TEENSY_PIN15_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_03
#define TEENSY_PIN16_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_07
#define TEENSY_PIN17_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_06
#define TEENSY_PIN18_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_01
#define TEENSY_PIN19_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_00
#define TEENSY_PIN20_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_10
#define TEENSY_PIN21_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_11
#define TEENSY_PIN22_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_08
#define TEENSY_PIN23_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_09
#define TEENSY_PIN24_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B0_12
#define TEENSY_PIN25_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B0_13
#define TEENSY_PIN26_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_14
#define TEENSY_PIN27_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_15
#define TEENSY_PIN28_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_32
#define TEENSY_PIN29_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_31
#define TEENSY_PIN30_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_37
#define TEENSY_PIN31_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_36
#define TEENSY_PIN32_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_B0_12
#define TEENSY_PIN33_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_07
#define TEENSY_PIN34_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_B1_13
#define TEENSY_PIN35_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_B1_12
#define TEENSY_PIN36_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_B1_02
#define TEENSY_PIN37_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_B1_03
#define TEENSY_PIN38_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_12
#define TEENSY_PIN39_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_13
#define TEENSY_PIN40_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_04
#define TEENSY_PIN41_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_05
#define TEENSY_PIN42_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B0_03
#define TEENSY_PIN43_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B0_02
#define TEENSY_PIN44_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B0_01
#define TEENSY_PIN45_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B0_00
#define TEENSY_PIN46_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B0_05
#define TEENSY_PIN47_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B0_04
#define TEENSY_PIN48_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_24
#define TEENSY_PIN49_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_27
#define TEENSY_PIN50_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_28
#define TEENSY_PIN51_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_22
#define TEENSY_PIN52_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_26
#define TEENSY_PIN53_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_25
#define TEENSY_PIN54_PAD    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_29

#define LINE_PIN0           PAL_LINE(TEENSY_PIN0_IOPORT, TEENSY_PIN0)
#define LINE_PIN1           PAL_LINE(TEENSY_PIN1_IOPORT, TEENSY_PIN1)
#define LINE_PIN2           PAL_LINE(TEENSY_PIN2_IOPORT, TEENSY_PIN2)
#define LINE_PIN3           PAL_LINE(TEENSY_PIN3_IOPORT, TEENSY_PIN3)
#define LINE_PIN4           PAL_LINE(TEENSY_PIN4_IOPORT, TEENSY_PIN4)
#define LINE_PIN5           PAL_LINE(TEENSY_PIN5_IOPORT, TEENSY_PIN5)
#define LINE_PIN6           PAL_LINE(TEENSY_PIN6_IOPORT, TEENSY_PIN6)
#define LINE_PIN7           PAL_LINE(TEENSY_PIN7_IOPORT, TEENSY_PIN7)
#define LINE_PIN8           PAL_LINE(TEENSY_PIN8_IOPORT, TEENSY_PIN8)
#define LINE_PIN9           PAL_LINE(TEENSY_PIN9_IOPORT, TEENSY_PIN9)
#define LINE_PIN10          PAL_LINE(TEENSY_PIN10_IOPORT, TEENSY_PIN10)
#define LINE_PIN11          PAL_LINE(TEENSY_PIN11_IOPORT, TEENSY_PIN11)
#define LINE_PIN12          PAL_LINE(TEENSY_PIN12_IOPORT, TEENSY_PIN12)
#define LINE_PIN13          PAL_LINE(TEENSY_PIN13_IOPORT, TEENSY_PIN13)
#define LINE_PIN14          PAL_LINE(TEENSY_PIN14_IOPORT, TEENSY_PIN14)
#define LINE_PIN15          PAL_LINE(TEENSY_PIN15_IOPORT, TEENSY_PIN15)
#define LINE_PIN16          PAL_LINE(TEENSY_PIN16_IOPORT, TEENSY_PIN16)
#define LINE_PIN17          PAL_LINE(TEENSY_PIN17_IOPORT, TEENSY_PIN17)
#define LINE_PIN18          PAL_LINE(TEENSY_PIN18_IOPORT, TEENSY_PIN18)
#define LINE_PIN19          PAL_LINE(TEENSY_PIN19_IOPORT, TEENSY_PIN19)
#define LINE_PIN20          PAL_LINE(TEENSY_PIN20_IOPORT, TEENSY_PIN20)
#define LINE_PIN21          PAL_LINE(TEENSY_PIN21_IOPORT, TEENSY_PIN21)
#define LINE_PIN22          PAL_LINE(TEENSY_PIN22_IOPORT, TEENSY_PIN22)
#define LINE_PIN23          PAL_LINE(TEENSY_PIN23_IOPORT, TEENSY_PIN23)
#define LINE_PIN24          PAL_LINE(TEENSY_PIN24_IOPORT, TEENSY_PIN24)
#define LINE_PIN25          PAL_LINE(TEENSY_PIN25_IOPORT, TEENSY_PIN25)
#define LINE_PIN25          PAL_LINE(TEENSY_PIN25_IOPORT, TEENSY_PIN25)
#define LINE_PIN26          PAL_LINE(TEENSY_PIN26_IOPORT, TEENSY_PIN26)
#define LINE_PIN27          PAL_LINE(TEENSY_PIN27_IOPORT, TEENSY_PIN27)
#define LINE_PIN28          PAL_LINE(TEENSY_PIN28_IOPORT, TEENSY_PIN28)
#define LINE_PIN29          PAL_LINE(TEENSY_PIN29_IOPORT, TEENSY_PIN29)
#define LINE_PIN30          PAL_LINE(TEENSY_PIN30_IOPORT, TEENSY_PIN30)
#define LINE_PIN31          PAL_LINE(TEENSY_PIN31_IOPORT, TEENSY_PIN31)
#define LINE_PIN32          PAL_LINE(TEENSY_PIN32_IOPORT, TEENSY_PIN32)
#define LINE_PIN33          PAL_LINE(TEENSY_PIN33_IOPORT, TEENSY_PIN33)
#define LINE_PIN34          PAL_LINE(TEENSY_PIN34_IOPORT, TEENSY_PIN34)
#define LINE_PIN35          PAL_LINE(TEENSY_PIN35_IOPORT, TEENSY_PIN35)
#define LINE_PIN36          PAL_LINE(TEENSY_PIN36_IOPORT, TEENSY_PIN36)
#define LINE_PIN37          PAL_LINE(TEENSY_PIN37_IOPORT, TEENSY_PIN37)
#define LINE_PIN38          PAL_LINE(TEENSY_PIN38_IOPORT, TEENSY_PIN38)
#define LINE_PIN39          PAL_LINE(TEENSY_PIN39_IOPORT, TEENSY_PIN39)
#define LINE_PIN40          PAL_LINE(TEENSY_PIN40_IOPORT, TEENSY_PIN40)
#define LINE_PIN41          PAL_LINE(TEENSY_PIN41_IOPORT, TEENSY_PIN41)
#define LINE_PIN42          PAL_LINE(TEENSY_PIN42_IOPORT, TEENSY_PIN42)
#define LINE_PIN43          PAL_LINE(TEENSY_PIN43_IOPORT, TEENSY_PIN43)
#define LINE_PIN44          PAL_LINE(TEENSY_PIN44_IOPORT, TEENSY_PIN44)
#define LINE_PIN45          PAL_LINE(TEENSY_PIN45_IOPORT, TEENSY_PIN45)
#define LINE_PIN46          PAL_LINE(TEENSY_PIN46_IOPORT, TEENSY_PIN46)
#define LINE_PIN47          PAL_LINE(TEENSY_PIN47_IOPORT, TEENSY_PIN47)
#define LINE_PIN48          PAL_LINE(TEENSY_PIN48_IOPORT, TEENSY_PIN48)
#define LINE_PIN49          PAL_LINE(TEENSY_PIN49_IOPORT, TEENSY_PIN49)
#define LINE_PIN50          PAL_LINE(TEENSY_PIN50_IOPORT, TEENSY_PIN50)
#define LINE_PIN51          PAL_LINE(TEENSY_PIN51_IOPORT, TEENSY_PIN50)
#define LINE_PIN52          PAL_LINE(TEENSY_PIN52_IOPORT, TEENSY_PIN52)
#define LINE_PIN53          PAL_LINE(TEENSY_PIN53_IOPORT, TEENSY_PIN53)
#define LINE_PIN54          PAL_LINE(TEENSY_PIN54_IOPORT, TEENSY_PIN54)

#define LINE_LED            LINE_PIN13

#if !defined(_FROM_ASM_)
#ifdef __cplusplus
extern "C" {
#endif
  void boardInit(void);
#ifdef __cplusplus
}
#endif
#endif /* _FROM_ASM_ */

#endif /* _BOARD_H_ */
