/*
    Copyright (C) 2014..2017 Marco Veeneman

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
*/

#include "hal.h"

/**
 * @brief   PAL setup.
 * @details Digital I/O ports static configuration as defined in @p board.h.
 *          This variable is used by the HAL when initializing the PAL driver.
 */
#if HAL_USE_PAL || defined(__DOXYGEN__)
const PALConfig pal_default_config =
{
  {VAL_GPIOA_DATA, VAL_GPIOA_DIR, VAL_GPIOA_AFSEL, VAL_GPIOA_DR2R, 
   VAL_GPIOA_DR4R, VAL_GPIOA_DR8R, VAL_GPIOA_ODR, VAL_GPIOA_PUR, 
   VAL_GPIOA_PDR, VAL_GPIOA_SLR, VAL_GPIOA_DEN, VAL_GPIOA_AMSEL, 
   VAL_GPIOA_PCTL},
  {VAL_GPIOB_DATA, VAL_GPIOB_DIR, VAL_GPIOB_AFSEL, VAL_GPIOB_DR2R, 
   VAL_GPIOB_DR4R, VAL_GPIOB_DR8R, VAL_GPIOB_ODR, VAL_GPIOB_PUR, 
   VAL_GPIOB_PDR, VAL_GPIOB_SLR, VAL_GPIOB_DEN, VAL_GPIOB_AMSEL, 
   VAL_GPIOB_PCTL},
  {VAL_GPIOC_DATA, VAL_GPIOC_DIR, VAL_GPIOC_AFSEL, VAL_GPIOC_DR2R, 
   VAL_GPIOC_DR4R, VAL_GPIOC_DR8R, VAL_GPIOC_ODR, VAL_GPIOC_PUR, 
   VAL_GPIOC_PDR, VAL_GPIOC_SLR, VAL_GPIOC_DEN, VAL_GPIOC_AMSEL, 
   VAL_GPIOC_PCTL},
  {VAL_GPIOD_DATA, VAL_GPIOD_DIR, VAL_GPIOD_AFSEL, VAL_GPIOD_DR2R, 
   VAL_GPIOD_DR4R, VAL_GPIOD_DR8R, VAL_GPIOD_ODR, VAL_GPIOD_PUR, 
   VAL_GPIOD_PDR, VAL_GPIOD_SLR, VAL_GPIOD_DEN, VAL_GPIOD_AMSEL, 
   VAL_GPIOD_PCTL},
  {VAL_GPIOE_DATA, VAL_GPIOE_DIR, VAL_GPIOE_AFSEL, VAL_GPIOE_DR2R, 
   VAL_GPIOE_DR4R, VAL_GPIOE_DR8R, VAL_GPIOE_ODR, VAL_GPIOE_PUR, 
   VAL_GPIOE_PDR, VAL_GPIOE_SLR, VAL_GPIOE_DEN, VAL_GPIOE_AMSEL, 
   VAL_GPIOE_PCTL},
  {VAL_GPIOF_DATA, VAL_GPIOF_DIR, VAL_GPIOF_AFSEL, VAL_GPIOF_DR2R, 
   VAL_GPIOF_DR4R, VAL_GPIOF_DR8R, VAL_GPIOF_ODR, VAL_GPIOF_PUR, 
   VAL_GPIOF_PDR, VAL_GPIOF_SLR, VAL_GPIOF_DEN, VAL_GPIOF_AMSEL, 
   VAL_GPIOF_PCTL},
  {VAL_GPIOG_DATA, VAL_GPIOG_DIR, VAL_GPIOG_AFSEL, VAL_GPIOG_DR2R,
   VAL_GPIOG_DR4R, VAL_GPIOG_DR8R, VAL_GPIOG_ODR, VAL_GPIOG_PUR,
   VAL_GPIOG_PDR, VAL_GPIOG_SLR, VAL_GPIOG_DEN, VAL_GPIOG_AMSEL,
   VAL_GPIOG_PCTL},
  {VAL_GPIOH_DATA, VAL_GPIOH_DIR, VAL_GPIOH_AFSEL, VAL_GPIOH_DR2R,
   VAL_GPIOH_DR4R, VAL_GPIOH_DR8R, VAL_GPIOH_ODR, VAL_GPIOH_PUR,
   VAL_GPIOH_PDR, VAL_GPIOH_SLR, VAL_GPIOH_DEN, VAL_GPIOH_AMSEL,
   VAL_GPIOH_PCTL},
  {VAL_GPIOJ_DATA, VAL_GPIOJ_DIR, VAL_GPIOJ_AFSEL, VAL_GPIOJ_DR2R,
   VAL_GPIOJ_DR4R, VAL_GPIOJ_DR8R, VAL_GPIOJ_ODR, VAL_GPIOJ_PUR,
   VAL_GPIOJ_PDR, VAL_GPIOJ_SLR, VAL_GPIOJ_DEN, VAL_GPIOJ_AMSEL,
   VAL_GPIOJ_PCTL},
  {VAL_GPIOK_DATA, VAL_GPIOK_DIR, VAL_GPIOK_AFSEL, VAL_GPIOK_DR2R,
   VAL_GPIOK_DR4R, VAL_GPIOK_DR8R, VAL_GPIOK_ODR, VAL_GPIOK_PUR,
   VAL_GPIOK_PDR, VAL_GPIOK_SLR, VAL_GPIOK_DEN, VAL_GPIOK_AMSEL,
   VAL_GPIOK_PCTL},
  {VAL_GPIOL_DATA, VAL_GPIOL_DIR, VAL_GPIOL_AFSEL, VAL_GPIOL_DR2R,
   VAL_GPIOL_DR4R, VAL_GPIOL_DR8R, VAL_GPIOL_ODR, VAL_GPIOL_PUR,
   VAL_GPIOL_PDR, VAL_GPIOL_SLR, VAL_GPIOL_DEN, VAL_GPIOL_AMSEL,
   VAL_GPIOL_PCTL},
  {VAL_GPIOM_DATA, VAL_GPIOM_DIR, VAL_GPIOM_AFSEL, VAL_GPIOM_DR2R,
   VAL_GPIOM_DR4R, VAL_GPIOM_DR8R, VAL_GPIOM_ODR, VAL_GPIOM_PUR,
   VAL_GPIOM_PDR, VAL_GPIOM_SLR, VAL_GPIOM_DEN, VAL_GPIOM_AMSEL,
   VAL_GPIOM_PCTL},
  {VAL_GPION_DATA, VAL_GPION_DIR, VAL_GPION_AFSEL, VAL_GPION_DR2R,
   VAL_GPION_DR4R, VAL_GPION_DR8R, VAL_GPION_ODR, VAL_GPION_PUR,
   VAL_GPION_PDR, VAL_GPION_SLR, VAL_GPION_DEN, VAL_GPION_AMSEL,
   VAL_GPION_PCTL},
  {VAL_GPIOP_DATA, VAL_GPIOP_DIR, VAL_GPIOP_AFSEL, VAL_GPIOP_DR2R,
   VAL_GPIOP_DR4R, VAL_GPIOP_DR8R, VAL_GPIOP_ODR, VAL_GPIOP_PUR,
   VAL_GPIOP_PDR, VAL_GPIOP_SLR, VAL_GPIOP_DEN, VAL_GPIOP_AMSEL,
   VAL_GPIOP_PCTL},
  {VAL_GPIOQ_DATA, VAL_GPIOQ_DIR, VAL_GPIOQ_AFSEL, VAL_GPIOQ_DR2R,
   VAL_GPIOQ_DR4R, VAL_GPIOQ_DR8R, VAL_GPIOQ_ODR, VAL_GPIOQ_PUR,
   VAL_GPIOQ_PDR, VAL_GPIOQ_SLR, VAL_GPIOQ_DEN, VAL_GPIOQ_AMSEL,
   VAL_GPIOQ_PCTL}
};
#endif

/**
 * @brief   Early initialization code.
 * @details This initialization is performed just after reset before BSS and
 *          DATA segments initialization.
 */
void __early_init(void) {
  tiva_clock_init();
}

/**
 * @brief   Late initialization code.
 * @note    This initialization is performed after BSS and DATA segments 
 *          initialization and before invoking the main() function.
 */
void boardInit(void) {
}
