<?php
/**
* イベントのコンテキストを保持するクラス
*
* PHP version 5
*
* @package    core
* @author     CharcoalPHP Development Team
* @copyright  2008 - 2013 CharcoalPHP Development Team
*/

class Charcoal_EventContext extends Charcoal_CharcoalObject implements Charcoal_IEventContext
{
	private $procedure;
	private $request;
	private $event;
	private $sequence;
	private $response;

	/*
	 *	コンストラクタ
	 */
	public function __construct()
	{
	}

	/**
	 *	Get current procedure object
     *
     * @return Charcoal_IProcedure
	 */
	public function getProcedure()
	{
		return $this->procedure;
	}

	/**
	 *	Set current procedure object
	 *
	 * @param Charcoal_IProcedure $procedure   Procedure object to set
	 */
	public function setProcedure( Charcoal_IProcedure $procedure )
	{
		$this->procedure = $procedure;
	}

	/**
	 *	Get current request object
	 *
	 *	@return Charcoal_IRequest
	 */
	public function getRequest()
	{
		return $this->request;
	}

	/**
	 *	Set current request object
	 *
	 * @param Charcoal_IRequest $request   Request object to set
	 */
	public function setRequest( Charcoal_IRequest $request )
	{
		$this->request = $request;
	}

	/**
	 *	Get current event object
	 *
	 *	@return Charcoal_IEvent
	 */
	public function getEvent()
	{
		return $this->event;
	}

	/**
	 *	Set current event object
	 *
	 * @param Charcoal_IEvent $event   Event object to set
	 */
	public function setEvent( Charcoal_IEvent $event )
	{
		$this->event = $event;
	}

	/**
	 *	Get current sequence object
	 *
	 *	@return Charcoal_IEvent
     *
     * @return Charcoal_ISequence
	 */
	public function getSequence()
	{
		return $this->sequence;
	}

	/**
	 *	Set current event object
	 *
	 * @param Charcoal_ISequence $sequence   Ssequence object to set
	 */
	public function setSequence( Charcoal_ISequence $sequence )
	{
		$this->sequence = $sequence;
	}

	/**
	 *	Get current response object
     *
     * @return Charcoal_Response
	 */
	public function getResponse()
	{
		return $this->response;
	}

	/**
	 *	Set current response object
	 *
	 * @param Charcoal_IResponse $response   Response object to set
	 */
	public function setResponse( Charcoal_IResponse $response )
	{
		$this->response = $response;
	}
}

return __FILE__;
