<?php
/**
* DIコンポーネントやコンテナから参照可能なリソースの場所を管理するクラス
*
* PHP version 5
*
* @package    core
* @author     CharcoalPHP Development Team
* @copyright  2008 - 2013 CharcoalPHP Development Team
*/

class Charcoal_ResourceLocator
{
	/*
	 * フレームワーク以下のリソースのパスを取得
	 */
	public static function getFrameworkPath( Charcoal_String $folder = NULL, Charcoal_String $filename = NULL )
	{
		if ( !$folder ){
			return CHARCOAL_HOME;
		}

		$path = CHARCOAL_HOME . '/' . $folder->getValue();

		if ( $filename ){
			$path .= '/' . $filename->getValue();
		}

		return $path;
	}

	/*
	 * プロジェクト以下のリソースのパスを取得
	 */
	public static function getProjectPath( Charcoal_String $folder = NULL, Charcoal_String $filename = NULL )
	{
		if ( !$folder ){
			return CHARCOAL_WEBAPP_DIR . '/' . CHARCOAL_PROJECT;
		}

		$path = CHARCOAL_WEBAPP_DIR . '/' . CHARCOAL_PROJECT . '/' . $folder->getValue();

		if ( $filename ){
			$path .= '/' . $filename->getValue();
		}

		return $path;
	}

	/*
	 * アプリケーション以下のリソースのパスを取得
	 */
	public static function getApplicationPath( Charcoal_String $folder = NULL, Charcoal_String $filename = NULL )
	{
		if ( !$folder ){
			return CHARCOAL_WEBAPP_DIR . '/' . CHARCOAL_PROJECT . '/apps/' . CHARCOAL_APPLICATION;
		}

		$path = CHARCOAL_WEBAPP_DIR . '/' . CHARCOAL_PROJECT . '/apps/' . CHARCOAL_APPLICATION . '/' . $folder->getValue();

		if ( $filename ){
			$path .= '/' . $filename->getValue();
		}

		return $path;
	}

	/*
	 * CHARCOAL_BASE_DIR以下のリソースのパスを取得
	 */
	public static function getBasePath( Charcoal_String $folder = NULL, Charcoal_String $filename = NULL )
	{
		if ( !$folder ){
			return CHARCOAL_BASE_DIR;
		}

		$path = CHARCOAL_BASE_DIR . '/' . $folder->getValue();

		if ( $filename ){
			$path .= '/' . $filename->getValue();
		}

		return $path;
	}

	/*
	 * フレームワークリソースのパスをFileインスタンスとして取得
	 */
	public static function getFrameworkFile( Charcoal_String $folder = NULL, Charcoal_String $filename = NULL )
	{
		return new Charcoal_File( s(self::getFrameworkPath($folder,$filename)) );
	}

	/*
	 * プロジェクトリソースのパスをFileインスタンスとして取得
	 */
	public static function getProjectFile( Charcoal_String $folder = NULL, Charcoal_String $filename = NULL )
	{
		return new Charcoal_File( s(self::getProjectPath($folder,$filename)) );
	}

	/*
	 * web_app以下のリソースのパスをFileインスタンスとして取得
	 */
	public static function getApplicationFile( Charcoal_String $folder = NULL, Charcoal_String $filename = NULL )
	{
		return new Charcoal_File( s(self::getApplicationPath($folder,$filename)) );
	}


}
return __FILE__;
