<?php
/**
* 日付値クラス
*
* PHP version 5
*
* @package    base
* @author     CharcoalPHP Development Team
* @copyright  2008 - 2013 CharcoalPHP Development Team
*/

class Charcoal_Date extends Charcoal_Object
{
	private $_year;
	private $_month;
	private $_day;

	/*
	 *	コンストラクタ
	 */
	public function __construct( Charcoal_Integer $year, Charcoal_Integer $month, Charcoal_Integer $day )
	{
		parent::__construct();

		$this->_year   = ui($year);
		$this->_month  = ui($month);
		$this->_day    = ui($day);
	}

	/*
	 *	文字列から生成
	 */
	public static function parse( Charcoal_String $date_string )
	{
		$date_string = us($date_string);

		$timestamp = strtotime( $date_string );

		if ( $timestamp === FALSE || $timestamp === -1 ){
			_throw ( new Charcoal_DateFormatException( $date_string ) );
		}

		return self::fromTimestamp( i($timestamp) );
	}

	/*
	 *	UNIXタイムスタンプから生成
	 */
	public static function fromTimestamp( Charcoal_Integer $timestamp )
	{
		$timestamp = ui($timestamp);

		$y = i(date( 'Y', $timestamp ));
		$m = i(date( 'n', $timestamp ));
		$d = i(date( 'j', $timestamp ));

		return new Charcoal_Date( $y, $m, $d );
	}

	/*
	 *	年を取得
	 */
	public function getYear()
	{
		return $this->_year;
	}

	/*
	 *	月を取得
	 */
	public function getMonth()
	{
		return $this->_month;
	}

	/*
	 *	日を取得
	 */
	public function getDay()
	{
		return $this->_day;
	}

	/*
	 *	書式化
	 */
	public function format( Charcoal_String $format_pattern )
	{
		$format_pattern = $format_pattern->getValue();

		$date = Charcoal_System::makeTime( $this->_year, $this->_month, $this->_day );

		return date( $format_pattern, $date );
	}

	/*
	 *  String expression of this object
	 *
	 * @return string
	 */
	public function toString()
	{
		return $this->_year . '/' . $this->_month . '/' . $this->_day;
	}
}
return __FILE__;
