<?php
/**
*  ե졼Υᥤ󥯥饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class Framework
{
	/*
	 *	ե졼μ¹ԡʼΡ
	 */
	private static function _run()
	{
		//=======================================
		// ॾ
		//
		$default_tz = Profile::getString( 'DEFAULT_TIMEZONE' );
		date_default_timezone_set( $default_tz );
//			ini_set( 'date.timezone', CHARCOAL_TIMEZONE );

		//=======================================
		// 饤֥λ
		//

		if ( Profile::getBoolean('USE_EXTLIB') ){
			$path = ConfigUtil::processMacro( Profile::getString( 'EXTLIB_DIR' ) );
			add_include_path( $path );
		}


		//=======================================
		// ν
		//

		// 
		Logger::init();

		if ( Logger::isEnabled() ){

			// ץեꤵƤ
			$logger_names = Profile::getArray( 'LOG_LOGGERS' );

			// Ͽ
			foreach( $logger_names as $key ){
				$logger = Factory::createLogger( $key );
				Logger::append( $key, $logger );
			}

			// ưå
			log_info( 'system,config', '===========================================================', __FILE__, __LINE__ );
			log_info( 'system,config', ' CHARCOAL framework version 1.0 (c)sazysoft,stk2k          ', __FILE__, __LINE__ );
			log_info( 'system,config', '===========================================================', __FILE__, __LINE__ );

			log_info( 'system', 'charcoalե졼򳫻Ϥޤ', __FILE__, __LINE__ );

			$profile_name = Profile::getProfileName();
			$profile_config_file = Profile::getConfigFile();
			
			log_info( 'system', "ץե̾=[$profile_name]" , __FILE__, __LINE__ );
			log_info( 'system', "ץեե=[$profile_config_file]" , __FILE__, __LINE__ );
		}

		//=======================================
		// 饹Ͽ
		//
		$class_loaders = Profile::getArray('CLASS_LOADERS');
		if ( $class_loaders && is_array($class_loaders) ) {
			foreach( $class_loaders as $loader_name ) 	{
				$loader = Factory::createClassLoader( $loader_name );
				ClassLoader::addClassLoader( $loader );
			}
		}

		//=======================================
		// åϥɥκ
		//

		if ( Profile::getBoolean('USE_SESSION') ) {
			log_info( 'system', 'åϥɥκ򳫻Ϥޤ', __FILE__, __LINE__ );

			// åϥɥ̾μ
			$session_handler_name = Profile::getString( 'SESSION_HANDLER_NAME' );

			// åϥɥκ
			$session_handler = Factory::createSessionHandler( $session_handler_name );

			log_info( 'system', 'åϥɥκλޤ', __FILE__, __LINE__ );
		}

		//=======================================
		// Requestѥ᡼μ
		//

		log_info( 'system', 'Requestѥ᡼βϤ򳫻Ϥޤ', __FILE__, __LINE__ );

		// Request֥Ȥ
		$request = Factory::createRequest( s( CHARCOAL_RUNMODE ) );

		$proc_key = $request->get( PROC_KEYWORD );

		log_info( 'system', "ץ㥭[$proc_key]Ǥ", __FILE__, __LINE__ );

		//=======================================
		// URLޥåԥ󥰡HTTPΤߡ
		//

		if ( CHARCOAL_RUNMODE === 'http'  && Profile::getBoolean('USE_URL_MAPPING') ) {
			log_info( 'system', 'URLޥåԥ󥰤򳫻Ϥޤ', __FILE__, __LINE__ );

			// URLޥåѡ̾
			$url_mapper_name = Profile::getString('URL_MAPPER' );

			// URLޥåѡ
			$url_mapper = Factory::createURLMapper( $url_mapper_name );

			// ޥåԥ󥰼¹
			$url_mapper->mapURL( $request );

			$proc_key = $request->get( PROC_KEYWORD );

			log_info( 'system', "ץ㥭[$proc_key]Ǥ", __FILE__, __LINE__ );
		}

		//=======================================
		// ProcedureKey̤ξ
		//

		// ץե뤫
		if ( !$proc_key ){
			$proc_key = Profile::getString('DEFAULT_PROCKEY');
			if ( !$proc_key || $proc_key->isEmpty() ){
				log_error( 'system', 'ץե˥ǥեȥץ㥭[DEFAULT_PROCKEY]Ƥޤ', __FILE__, __LINE__ );
				throw new HttpException('500');
			}
		}

		//=======================================
		// Procedureκ
		//

		// ץ
		list( $procedure, $proc_name ) = Factory::createProcedure( $proc_key );

		//=======================================
		// ƥʤκȵư
		//

		// DIƥʤ
		DIContainer::createContainer( $procedure );

		//=======================================
		// Responseκ
		//

		// Request֥Ȥ
		$response = new Response();

		//=======================================
		// ProcedureContextκ
		//

		if ( Profile::getBoolean('USE_SESSION') ){
			// å
			$session = new Session();

			// ProcedureContext֥Ȥ
			$context = new ProcedureContext( $proc_name, $procedure, $session );

			// åγ
			$session->start();
			$session->restore();
		}
		else{
			// ProcedureContext֥Ȥ
			$context = new ProcedureContext( $proc_name, $procedure );
		}

		//=======================================
		// Procedureμ¹
		//

		log_info( 'system', "ץ[$proc_name]¹Ԥޤ", __FILE__, __LINE__ );

		// ץμ¹
		$procedure->execute( $request, $context, $response );

		log_info( 'system', "ץ[$proc_name]¹Ԥޤ", __FILE__, __LINE__ );

		//=======================================
		// λ
		//

		// å¸
		if ( Profile::getBoolean('USE_SESSION') ) {
			$session->save();
			$session->close();
		}

		//=======================================
		// ƥʤ˴
		//

		DIContainer::destroy();

		// λå
		log_info( 'system', 'charcoalե졼λޤ', __FILE__, __LINE__ );

		// Υåȥ
		Logger::terminate();
	}

	/**
	 *	ե졼ư
	 */
	public static function run()
	{
		try{
			self::_run();
		}
		catch ( HttpException $e )
		{
			// ơ
			$status = $e->getStatusCode();

			// 桼error_docs򸡺
			$html_file = ResourceLocator::getWebAppPath( 'error_docs' , "$status.html" );

			if ( !is_file($html_file) ){
				// ʤХǥեȤerror_docs򸡺
				$html_file = ResourceLocator::getSystemPath( 'error_docs' , "$status.html" );
			}

			if ( is_file($html_file) ){
				// ɤ߹ߤɽ
				readfile( $html_file );
				print "<br>";
			}
			else{
				// Errorɥȥե뤬ʤ
				log_warning( 'system,error', "顼ɥ($html_file)¸ߤޤ", __FILE__, __LINE__ );
			}

			// إå
			$header_msg_array = array(
					'401' => 'Unauthorized',
					'403' => 'Forbidden',
					'404' => 'Not Found',
					'500' => 'Internal Server Error',
				);
			$header_msg = $header_msg_array[$status];
			$message = "HTTP/1.0 $status $header_msg";
			header( $message );

			// 顼
			log_error( 'system,error', $message, __FILE__, __LINE__ );
		}
		catch ( CharcoalException $e )
		{
			include( 'debug/exception_list.php' );
		}
		catch( Exception $e )
		{
			ExceptionStack::dump();
		}
	}
}

return __FILE__;