/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.speckle.jdbc.internal;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.protos.speckle.Client;
import com.google.protos.speckle.sql.Sql;
import com.google.storage.speckle.jdbc.internal.SpeckleClient;
import com.google.storage.speckle.jdbc.internal.SpeckleRpcOptions;
import com.google.storage.speckle.jdbc.internal.SpeckleUrl;
import com.google.storage.speckle.jdbc.internal.TypedValue;
import com.google.storage.speckle.jdbc.internal.Util;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSpeckleClient
implements SpeckleClient {
    private final String instance;

    protected AbstractSpeckleClient(String instance) {
        if (instance == null || instance.isEmpty()) {
            throw new IllegalArgumentException("invalid instance: (" + instance + ").");
        }
        this.instance = Util.makeSafe(instance);
    }

    public String getInstance() {
        return this.instance;
    }

    protected Sql.ExecRequest createExecRequest(SpeckleRpcOptions options, ByteString connectionId, String sql, List<TypedValue> bindParameters) throws SQLException {
        Sql.ExecRequest.Builder request = Sql.ExecRequest.newBuilder().setInstance(this.getInstance()).setConnectionId(connectionId).setStatement(sql);
        Client.ExecOptions.Builder optionsBuilder = Client.ExecOptions.newBuilder();
        if (options.getIncludeExportedKeys()) {
            optionsBuilder.setIncludeGeneratedKeys(true);
        }
        if (options.getGeneratedColumnIndices() != null) {
            for (int index : options.getGeneratedColumnIndices()) {
                optionsBuilder.addGeneratedColumnIndices(index);
            }
        }
        if (options.getGeneratedColumnNames() != null) {
            optionsBuilder.addAllGeneratedColumnNames(Arrays.asList(options.getGeneratedColumnNames()));
        }
        if (options.getFetchSize() != 0) {
            optionsBuilder.setFetchSize(options.getFetchSize());
        }
        optionsBuilder.setType(Client.ResultSetType.valueOf(options.getResultSetType()));
        optionsBuilder.setConcurrency(Client.ResultSetConcurrency.valueOf(options.getResultSetConcurrency()));
        optionsBuilder.setHoldability(Client.ResultSetHoldability.valueOf(options.getResultSetHoldability()));
        request.setOptions(optionsBuilder.build());
        for (Client.BindVariableProto.Builder b : this.bindParameterBuildersFor(bindParameters)) {
            request.addBindVariable(b);
        }
        return request.build();
    }

    protected Sql.ExecRequest createExecNextRequest(SpeckleRpcOptions options, ByteString connectionId, long statementId) {
        Sql.ExecRequest.Builder request = Sql.ExecRequest.newBuilder().setInstance(this.getInstance()).setConnectionId(connectionId).setStatementId(statementId);
        return request.build();
    }

    protected Sql.ExecOpRequest createExecOpRequest(ByteString connectionId, Client.OpProto op) {
        Sql.ExecOpRequest.Builder request = Sql.ExecOpRequest.newBuilder().setInstance(this.getInstance()).setConnectionId(connectionId).setOp(op);
        return request.build();
    }

    protected Sql.OpenConnectionRequest createConnectRequest(SpeckleUrl url) {
        Sql.OpenConnectionRequest.Builder request = Sql.OpenConnectionRequest.newBuilder();
        for (Map.Entry<String, String> e : url.getProperties().entrySet()) {
            request.addProperty(Client.Property.newBuilder().setKey(e.getKey()).setValue(e.getValue()));
        }
        request.setInstance(this.getInstance());
        return request.build();
    }

    protected Sql.CloseConnectionRequest createReleaseRequest(ByteString connectionId) {
        return Sql.CloseConnectionRequest.newBuilder().setInstance(this.getInstance()).setConnectionId(connectionId).build();
    }

    protected Sql.MetadataRequest createMetadataRequest(ByteString connectionId, Client.MetadataType metadataType, List<TypedValue> bindParameters) throws SQLException {
        Sql.MetadataRequest.Builder request = Sql.MetadataRequest.newBuilder().setInstance(this.getInstance()).setConnectionId(connectionId).setMetadata(metadataType);
        for (Client.BindVariableProto.Builder b : this.bindParameterBuildersFor(bindParameters)) {
            request.addBindVariable(b);
        }
        return request.build();
    }

    private List<Client.BindVariableProto.Builder> bindParameterBuildersFor(List<TypedValue> bindParameters) throws SQLException {
        ArrayList<Client.BindVariableProto.Builder> builders = Util.newArrayListWithCapacity(bindParameters.size());
        if (!bindParameters.isEmpty()) {
            int position = 1;
            for (TypedValue p : bindParameters) {
                Client.BindVariableProto.Builder bind = Client.BindVariableProto.newBuilder();
                bind.setPosition(position++);
                bind.setType(p.getDataType().getCode());
                if (!p.isNull()) {
                    bind.setValue(p.getValueAsByteString());
                }
                builders.add(bind);
            }
        }
        return builders;
    }
}

