/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.speckle.jdbc;

import com.google.protos.speckle.Client;
import com.google.protos.speckle.sql.Sql;
import com.google.storage.speckle.jdbc.SpeckleResultSet;
import com.google.storage.speckle.jdbc.SpeckleStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class SpeckleStreamingResultSet
extends SpeckleResultSet {
    boolean moreRows;

    public SpeckleStreamingResultSet(SpeckleStatement stmt, Client.ResultProto result, SQLWarning warnings, String catalog, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(stmt, result.getRows().getTuplesList(), result.getRows().getColumnsList(), warnings, catalog, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.moreRows = result.hasMoreRows();
    }

    public boolean next() throws SQLException {
        boolean next = super.next();
        if (!next && this.moreRows) {
            Sql.ExecResponse response = this.getStatement().executeNext();
            if (!response.hasResult()) {
                this.moreRows = false;
                return false;
            }
            Client.ResultProto result = response.getResult();
            this.moreRows = result.getMoreRows();
            return this.setData(result.getRows().getTuplesList());
        }
        return next;
    }
}

