/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.speckle.jdbc;

import com.google.protos.speckle.sql.Sql;
import com.google.storage.speckle.jdbc.SpeckleConnection;
import com.google.storage.speckle.jdbc.SpeckleParameterMetadata;
import com.google.storage.speckle.jdbc.SpeckleResultSet;
import com.google.storage.speckle.jdbc.SpeckleStatement;
import com.google.storage.speckle.jdbc.internal.ClientSideBlob;
import com.google.storage.speckle.jdbc.internal.ClientSideClob;
import com.google.storage.speckle.jdbc.internal.Exceptions;
import com.google.storage.speckle.jdbc.internal.JdbcType;
import com.google.storage.speckle.jdbc.internal.SpeckleRpcOptions;
import com.google.storage.speckle.jdbc.internal.SpeckleUrl;
import com.google.storage.speckle.jdbc.internal.TypedValue;
import com.google.storage.speckle.jdbc.internal.Util;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpecklePreparedStatement
extends SpeckleStatement
implements PreparedStatement {
    private static final int DEFAULT_COPY_BLOCK_SIZE = 4096;
    private static final int DEFAULT_BLOB_LENGTH = 4096;
    private final String sql;
    private Map<Integer, TypedValue> bindParametersMap = Util.newTreeMap();

    SpecklePreparedStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, SpeckleConnection conn, SpeckleUrl url) {
        super(resultSetType, resultSetConcurrency, resultSetHoldability, conn, url);
        this.sql = sql;
    }

    @Override
    public void addBatch() throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.throwIfNotOpen();
        this.bindParametersMap.clear();
    }

    @Override
    public boolean execute() throws SQLException {
        this.throwIfNotOpen();
        return this.executeImpl(this.sql);
    }

    @Override
    public SpeckleResultSet executeQuery() throws SQLException {
        this.throwIfNotOpen();
        return this.executeQuery(this.sql);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.throwIfNotOpen();
        return this.executeUpdate(this.sql);
    }

    @Override
    protected Sql.ExecResponse executeSqlImpl(SpeckleRpcOptions options, String sql) throws SQLException {
        this.throwIfNotOpen();
        if (this.bindParametersMap.isEmpty()) {
            return this.getConnection().executeSql(options, sql);
        }
        Set<Integer> keys = this.bindParametersMap.keySet();
        ArrayList<TypedValue> bindParameters = Util.newArrayListWithCapacity(keys.size());
        int current = 1;
        for (Integer key : keys) {
            bindParameters.add(this.bindParametersMap.get(key));
            if (key == current++) continue;
            throw new SQLException("Bind parameter #" + key + " out of order");
        }
        return this.getConnection().executeSql(options, sql, bindParameters);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.throwIfNotOpen();
        return null;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.throwIfNotOpen();
        return new SpeckleParameterMetadata(this.bindParametersMap);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.throwIfNotOpen();
        this.bindParametersMap.put(parameterIndex, TypedValue.of(x, JdbcType.JDBC_TYPE_DECIMAL));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.throwIfNotOpen();
        this.bindParametersMap.put(parameterIndex, TypedValue.of(x, JdbcType.JDBC_TYPE_BLOB));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setBlob(parameterIndex, inputStream, 4096L);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.throwIfNotOpen();
        ClientSideBlob blob = new ClientSideBlob(SpecklePreparedStatement.toByteArray(inputStream, (int)length));
        this.bindParametersMap.put(parameterIndex, TypedValue.of(blob, JdbcType.JDBC_TYPE_BLOB));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean b) throws SQLException {
        this.throwIfNotOpen();
        this.bindParametersMap.put(parameterIndex, TypedValue.of(b, JdbcType.JDBC_TYPE_BOOLEAN));
    }

    @Override
    public void setByte(int parameterIndex, byte b) throws SQLException {
        this.throwIfNotOpen();
        this.bindParametersMap.put(parameterIndex, TypedValue.of(b, JdbcType.JDBC_TYPE_TINYINT));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.throwIfNotOpen();
        this.bindParametersMap.put(parameterIndex, TypedValue.of(x, JdbcType.JDBC_TYPE_VARBINARY));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.throwIfNotOpen();
        this.bindParametersMap.put(parameterIndex, TypedValue.of(x, JdbcType.JDBC_TYPE_CLOB));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.throwIfNotOpen();
        this.setClob(parameterIndex, reader, 4096L);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.throwIfNotOpen();
        ClientSideClob clob = new ClientSideClob(SpecklePreparedStatement.toCharArray(reader, (int)length));
        this.bindParametersMap.put(parameterIndex, TypedValue.of(clob, JdbcType.JDBC_TYPE_CLOB));
    }

    @Override
    public void setDate(int parameterIndex, Date d) throws SQLException {
        this.throwIfNotOpen();
        this.bindParametersMap.put(parameterIndex, TypedValue.of(d, JdbcType.JDBC_TYPE_DATE));
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setDouble(int parameterIndex, double d) throws SQLException {
        this.throwIfNotOpen();
        this.bindParametersMap.put(parameterIndex, TypedValue.of(d, JdbcType.JDBC_TYPE_DOUBLE));
    }

    @Override
    public void setFloat(int parameterIndex, float f) throws SQLException {
        this.throwIfNotOpen();
        this.bindParametersMap.put(parameterIndex, TypedValue.of(Float.valueOf(f), JdbcType.JDBC_TYPE_FLOAT));
    }

    @Override
    public void setInt(int parameterIndex, int i) throws SQLException {
        this.throwIfNotOpen();
        this.bindParametersMap.put(parameterIndex, TypedValue.of(i, JdbcType.JDBC_TYPE_INTEGER));
    }

    @Override
    public void setLong(int parameterIndex, long l) throws SQLException {
        this.throwIfNotOpen();
        this.bindParametersMap.put(parameterIndex, TypedValue.of(l, JdbcType.JDBC_TYPE_BIGINT));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.throwIfNotOpen();
        this.setNull(parameterIndex, sqlType, null);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.throwIfNotOpen();
        this.bindParametersMap.put(parameterIndex, TypedValue.nullValue(JdbcType.fromCode(sqlType)));
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.throwIfNotOpen();
        Class<?> clazz = x.getClass();
        if (clazz.isPrimitive()) {
            System.err.println(clazz.getCanonicalName());
        }
        if (clazz == String.class) {
            this.setString(parameterIndex, (String)x);
        } else if (clazz == Boolean.class) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (clazz == Byte.class) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (clazz == Short.class) {
            this.setShort(parameterIndex, (Short)x);
        } else if (clazz == Integer.class) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (clazz == Long.class) {
            this.setLong(parameterIndex, (Long)x);
        } else if (clazz == Float.class) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (clazz == Double.class) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (clazz == byte[].class) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Array) {
            this.setArray(parameterIndex, (Array)x);
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
        } else if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
        } else {
            if (x instanceof Struct) {
                throw Exceptions.newNotYetImplementedException();
            }
            if (x instanceof Ref) {
                this.setRef(parameterIndex, (Ref)x);
            } else if (x instanceof URL) {
                this.setURL(parameterIndex, (URL)x);
            } else if (x instanceof RowId) {
                this.setRowId(parameterIndex, (RowId)x);
            } else if (x instanceof RowId) {
                this.setRowId(parameterIndex, (RowId)x);
            } else if (x instanceof SQLXML) {
                this.setSQLXML(parameterIndex, (SQLXML)x);
            } else {
                throw Exceptions.newInvalidParameterException("setObject", x.getClass());
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.throwIfNotOpen();
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.throwIfNotOpen();
        switch (JdbcType.fromCode(targetSqlType)) {
            case JDBC_TYPE_ARRAY: {
                this.throwIfNotOfClass(x, "setObject", Array.class);
                this.setArray(parameterIndex, (Array)x);
                break;
            }
            case JDBC_TYPE_BIGINT: {
                this.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setLong(parameterIndex, this.boolAsNumber((Boolean)x).longValue());
                    break;
                }
                if (x instanceof Number) {
                    this.setLong(parameterIndex, ((Number)x).longValue());
                    break;
                }
                this.setLong(parameterIndex, Long.valueOf((String)x));
                break;
            }
            case JDBC_TYPE_BINARY: 
            case JDBC_TYPE_LONGVARBINARY: 
            case JDBC_TYPE_VARBINARY: {
                this.throwIfNotOfClass(x, "setObject", String.class, byte[].class);
                Class<?> clazz = x.getClass();
                if (clazz == byte[].class) {
                    this.setBytes(parameterIndex, (byte[])x);
                    break;
                }
                this.setString(parameterIndex, (String)x);
                break;
            }
            case JDBC_TYPE_BIT: {
                this.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                this.setInt(parameterIndex, this.toBoolean(x) ? 1 : 0);
                break;
            }
            case JDBC_TYPE_BLOB: {
                this.throwIfNotOfClass(x, "setObject", Blob.class);
                this.setBlob(parameterIndex, (Blob)x);
                break;
            }
            case JDBC_TYPE_BOOLEAN: {
                this.throwIfNotOfClass(x, "setObject", Boolean.class);
                this.setBoolean(parameterIndex, this.toBoolean(x));
                break;
            }
            case JDBC_TYPE_CHAR: 
            case JDBC_TYPE_LONGVARCHAR: 
            case JDBC_TYPE_VARCHAR: {
                this.throwIfNotOfClass(x, "setObject", String.class, Number.class, Boolean.class, Date.class, Time.class, Timestamp.class);
                if (x instanceof Boolean) {
                    this.setString(parameterIndex, (Boolean)x != false ? "1" : "0");
                } else if (x instanceof BigDecimal) {
                    this.setString(parameterIndex, ((BigDecimal)x).toPlainString());
                }
                this.setString(parameterIndex, String.valueOf(x));
                break;
            }
            case JDBC_TYPE_CLOB: {
                this.throwIfNotOfClass(x, "setObject", Clob.class);
                this.setClob(parameterIndex, (Clob)x);
                break;
            }
            case JDBC_TYPE_DATALINK: {
                this.throwIfNotOfClass(x, "setObject", URL.class);
                this.setURL(parameterIndex, (URL)x);
                break;
            }
            case JDBC_TYPE_DATE: {
                this.throwIfNotOfClass(x, "setObject", Date.class, String.class, Timestamp.class);
                if (x instanceof Date) {
                    this.setDate(parameterIndex, (Date)x);
                } else if (x instanceof Timestamp) {
                    this.setTimestamp(parameterIndex, (Timestamp)x);
                }
                this.setString(parameterIndex, (String)x);
                break;
            }
            case JDBC_TYPE_DECIMAL: 
            case JDBC_TYPE_NUMERIC: {
                this.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setBigDecimal(parameterIndex, (Boolean)x != false ? BigDecimal.ONE : BigDecimal.ZERO);
                    break;
                }
                if (x instanceof Number) {
                    this.setBigDecimal(parameterIndex, this.toBigDecimal((Number)x).setScale(scaleOrLength));
                    break;
                }
                this.setBigDecimal(parameterIndex, new BigDecimal((String)x).setScale(scaleOrLength));
                break;
            }
            case JDBC_TYPE_DOUBLE: {
                this.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setDouble(parameterIndex, this.boolAsNumber((Boolean)x).doubleValue());
                    break;
                }
                if (x instanceof Number) {
                    this.setDouble(parameterIndex, ((Number)x).doubleValue());
                    break;
                }
                this.setDouble(parameterIndex, Double.valueOf((String)x));
                break;
            }
            case JDBC_TYPE_FLOAT: {
                this.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setFloat(parameterIndex, this.boolAsNumber((Boolean)x).floatValue());
                    break;
                }
                if (x instanceof Number) {
                    this.setFloat(parameterIndex, ((Number)x).floatValue());
                    break;
                }
                this.setFloat(parameterIndex, Float.valueOf((String)x).floatValue());
                break;
            }
            case JDBC_TYPE_INTEGER: {
                this.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setInt(parameterIndex, this.boolAsNumber((Boolean)x).intValue());
                    break;
                }
                if (x instanceof Number) {
                    this.setInt(parameterIndex, ((Number)x).intValue());
                    break;
                }
                this.setInt(parameterIndex, Integer.valueOf((String)x));
                break;
            }
            case JDBC_TYPE_REAL: {
                this.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setFloat(parameterIndex, this.boolAsNumber((Boolean)x).floatValue());
                    break;
                }
                if (x instanceof Number) {
                    this.setFloat(parameterIndex, ((Number)x).floatValue());
                    break;
                }
                this.setFloat(parameterIndex, Float.valueOf((String)x).floatValue());
                break;
            }
            case JDBC_TYPE_REF: {
                this.throwIfNotOfClass(x, "setObject", Ref.class);
                this.setRef(parameterIndex, (Ref)x);
                break;
            }
            case JDBC_TYPE_ROWID: {
                this.throwIfNotOfClass(x, "setObject", RowId.class);
                this.setRowId(parameterIndex, (RowId)x);
                break;
            }
            case JDBC_TYPE_SMALLINT: {
                this.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setShort(parameterIndex, this.boolAsNumber((Boolean)x).shortValue());
                    break;
                }
                if (x instanceof Number) {
                    this.setShort(parameterIndex, ((Number)x).shortValue());
                    break;
                }
                this.setShort(parameterIndex, Short.valueOf((String)x));
                break;
            }
            case JDBC_TYPE_TINYINT: {
                this.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setByte(parameterIndex, this.boolAsNumber((Boolean)x).byteValue());
                    break;
                }
                if (x instanceof Number) {
                    this.setByte(parameterIndex, ((Number)x).byteValue());
                    break;
                }
                this.setByte(parameterIndex, Byte.valueOf((String)x));
                break;
            }
            case JDBC_TYPE_SQLXML: {
                this.throwIfNotOfClass(x, "setObject", SQLXML.class);
                this.setSQLXML(parameterIndex, (SQLXML)x);
                break;
            }
            case JDBC_TYPE_TIME: {
                this.throwIfNotOfClass(x, "setObject", Time.class, String.class, Timestamp.class);
                if (x instanceof Time) {
                    this.setTime(parameterIndex, (Time)x);
                } else if (x instanceof Timestamp) {
                    this.setTime(parameterIndex, new Time(((Timestamp)x).getTime()));
                }
                this.setString(parameterIndex, (String)x);
                break;
            }
            case JDBC_TYPE_TIMESTAMP: {
                this.throwIfNotOfClass(x, "setObject", Date.class, String.class, Timestamp.class);
                if (x instanceof Date) {
                    this.setDate(parameterIndex, (Date)x);
                } else if (x instanceof Timestamp) {
                    this.setTimestamp(parameterIndex, (Timestamp)x);
                }
                this.setString(parameterIndex, (String)x);
                break;
            }
            case JDBC_TYPE_JAVA_OBJECT: 
            case JDBC_TYPE_NVARCHAR: 
            case JDBC_TYPE_LONGNVARCHAR: 
            case JDBC_TYPE_NCHAR: 
            case JDBC_TYPE_NCLOB: 
            case JDBC_TYPE_STRUCT: {
                throw Exceptions.newNotYetImplementedException();
            }
            case JDBC_TYPE_DISTINCT: 
            case JDBC_TYPE_NULL: 
            case JDBC_TYPE_OTHER: {
                throw Exceptions.newNotYetImplementedException();
            }
            default: {
                throw Exceptions.newInvalidParameterException("targetSqlType", targetSqlType);
            }
        }
    }

    private BigDecimal toBigDecimal(Number x) {
        if (x instanceof BigDecimal) {
            return (BigDecimal)x;
        }
        if (x instanceof BigInteger) {
            return new BigDecimal((BigInteger)x);
        }
        if (x instanceof Byte) {
            return BigDecimal.valueOf(x.longValue());
        }
        if (x instanceof Double) {
            return BigDecimal.valueOf(x.doubleValue());
        }
        if (x instanceof Float) {
            return BigDecimal.valueOf(x.floatValue());
        }
        if (x instanceof Integer) {
            return BigDecimal.valueOf(x.longValue());
        }
        if (x instanceof Long) {
            return BigDecimal.valueOf(x.longValue());
        }
        if (x instanceof Short) {
            return BigDecimal.valueOf(x.longValue());
        }
        return BigDecimal.valueOf(x.doubleValue());
    }

    private void throwIfNotOfClass(Object x, String methodName, Class<?> ... classes) throws SQLException {
        boolean ok = false;
        Class<?> xclass = x.getClass();
        for (Class<?> clazz : classes) {
            if (!xclass.isAssignableFrom(clazz)) continue;
            ok = true;
            break;
        }
        if (!ok) {
            throw Exceptions.newInvalidParameterException(methodName, xclass);
        }
    }

    private Number boolAsNumber(Boolean b) {
        return b != false ? 1 : 0;
    }

    private boolean toBoolean(Object x) {
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        if (x instanceof Number) {
            Number n = (Number)x;
            return n.byteValue() != 0;
        }
        String s = String.valueOf(x);
        if (s.length() == 1) {
            return s.charAt(0) != '0';
        }
        return Boolean.valueOf(s);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setShort(int parameterIndex, short s) throws SQLException {
        this.throwIfNotOpen();
        this.bindParametersMap.put(parameterIndex, TypedValue.of(s, JdbcType.JDBC_TYPE_SMALLINT));
    }

    @Override
    public void setString(int parameterIndex, String s) throws SQLException {
        this.throwIfNotOpen();
        this.bindParametersMap.put(parameterIndex, TypedValue.of(s, JdbcType.JDBC_TYPE_VARCHAR));
    }

    @Override
    public void setTime(int parameterIndex, Time t) throws SQLException {
        this.throwIfNotOpen();
        this.bindParametersMap.put(parameterIndex, TypedValue.of(t.toString(), JdbcType.JDBC_TYPE_TIME));
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp t) throws SQLException {
        this.throwIfNotOpen();
        this.bindParametersMap.put(parameterIndex, TypedValue.of(t.toString(), JdbcType.JDBC_TYPE_TIMESTAMP));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.throwIfNotOpen();
        if (cal == null) {
            this.setTimestamp(parameterIndex, x);
        } else {
            cal.setTime(x);
            String dateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US).format(cal.getTime());
            this.bindParametersMap.put(parameterIndex, TypedValue.of(dateString, JdbcType.JDBC_TYPE_TIMESTAMP));
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    Map<Integer, TypedValue> getBindParametersMap() {
        return this.bindParametersMap;
    }

    private static byte[] toByteArray(InputStream in, int size) throws SQLException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            SpecklePreparedStatement.copy(in, out);
        }
        catch (IOException e) {
            throw Exceptions.newSqlException("Error reading InputStream", e);
        }
        return out.toByteArray();
    }

    private static void copy(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[4096];
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
        }
    }

    private static char[] toCharArray(Reader r, int size) throws SQLException {
        CharArrayWriter out = new CharArrayWriter(size);
        try {
            SpecklePreparedStatement.copy(r, out);
        }
        catch (IOException e) {
            throw Exceptions.newSqlException("Error reading InputStream", e);
        }
        return out.toCharArray();
    }

    private static void copy(Reader from, Writer to) throws IOException {
        int r;
        char[] buf = new char[4096];
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
        }
    }
}

