/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.bridge;

import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.RpcCallback;
import com.google.appengine.repackaged.com.google.protobuf.Service;
import com.google.appengine.repackaged.com.google.protobuf.bridge.AbstractStubbyService;
import com.google.appengine.repackaged.com.google.protobuf.bridge.DowngradedMessage;
import com.google.appengine.repackaged.com.google.protobuf.bridge.StubbyRpcController;
import com.google.net.rpc.RPC;
import com.google.net.rpc.impl.ApplicationHandler;

public class StubbyService
extends AbstractStubbyService {
    private final Service service;

    public StubbyService(Service service) {
        this(service, service.getDescriptorForType().getName(), ExtensionRegistry.getEmptyRegistry());
    }

    public StubbyService(Service service, String serviceName) {
        this(service, serviceName, ExtensionRegistry.getEmptyRegistry());
    }

    public StubbyService(Service service, ExtensionRegistry registry) {
        this(service, service.getDescriptorForType().getName(), registry);
    }

    public StubbyService(Service service, String serviceName, ExtensionRegistry registry) {
        super(serviceName, registry);
        this.service = service;
    }

    Descriptors.ServiceDescriptor getDescriptorForType() {
        return this.service.getDescriptorForType();
    }

    Message getRequestPrototype(Descriptors.MethodDescriptor method) {
        return this.service.getRequestPrototype(method);
    }

    Message getResponsePrototype(Descriptors.MethodDescriptor method) {
        return this.service.getResponsePrototype(method);
    }

    ApplicationHandler newApplicationHandler(Descriptors.MethodDescriptor methodDescriptor, ExtensionRegistry extensionRegistry) {
        return new StubbyApplicationHandler(methodDescriptor, this.service, extensionRegistry);
    }

    static final class StubbyApplicationHandler
    extends AbstractStubbyService.AbstractStubbyApplicationHandler {
        private final Descriptors.MethodDescriptor methodDescriptor;
        private final Service service;

        StubbyApplicationHandler(Descriptors.MethodDescriptor methodDescriptor, Service service, ExtensionRegistry registry) {
            super(registry);
            this.methodDescriptor = methodDescriptor;
            this.service = service;
        }

        void internalHandleRequest(final RPC rpc, StubbyRpcController controller) {
            DowngradedMessage query = (DowngradedMessage)rpc.internalRequest();
            final DowngradedMessage response = (DowngradedMessage)rpc.internalResponse();
            RpcCallback<Message> callback = new RpcCallback<Message>(){

                @Override
                public void run(Message result) {
                    if (result == null) {
                        result = StubbyApplicationHandler.this.service.getResponsePrototype(StubbyApplicationHandler.this.methodDescriptor);
                    }
                    response.setProto2Message(result);
                    rpc.internalCallback().rpcFinished();
                }
            };
            this.service.callMethod(this.methodDescriptor, controller, query.getProto2Message(), callback);
        }

        String getStreamType() {
            return this.methodDescriptor.getOptions().getStreamType();
        }
    }
}

