/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.taskqueue;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.taskqueue.InternalFailureException;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueApiHelper;
import com.google.appengine.api.taskqueue.QueueConstants;
import com.google.appengine.api.taskqueue.RetryOptions;
import com.google.appengine.api.taskqueue.TaskHandle;
import com.google.appengine.api.taskqueue.TaskOptions;
import com.google.appengine.api.taskqueue.TaskQueuePb;
import com.google.appengine.api.taskqueue.Transaction;
import com.google.appengine.api.taskqueue.UnsupportedTranslationException;
import com.google.apphosting.api.ApiProxy;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueueImpl
implements Queue {
    private final String queueName;
    private final DatastoreService datastoreService = DatastoreServiceFactory.getDatastoreService();
    final QueueApiHelper apiHelper;
    static final String DEFAULT_NAMESPACE_HEADER = "X-AppEngine-Default-Namespace";
    static final String CURRENT_NAMESPACE_HEADER = "X-AppEngine-Current-Namespace";
    static final String CURRENT_NAMESPACE_KEY = NamespaceManager.class.getName() + ".currentNamespace";
    static final String APPS_NAMESPACE_KEY = NamespaceManager.class.getName() + ".appsNamespace";

    QueueImpl(String queueName, QueueApiHelper apiHelper) {
        if (queueName == null || queueName.length() == 0 || !QueueConstants.QUEUE_NAME_PATTERN.matcher(queueName).matches()) {
            throw new IllegalArgumentException("Queue name does not match expression " + QueueConstants.QUEUE_NAME_REGEX + "; found '" + queueName + "'");
        }
        this.apiHelper = apiHelper;
        this.queueName = queueName;
    }

    @Override
    public TaskHandle add() {
        return this.add(this.getDatastoreService().getCurrentTransaction(null), TaskOptions.Builder.withDefaults());
    }

    private URI parsePartialUrl(String urlString) {
        URI uri;
        if (urlString == null) {
            throw new IllegalArgumentException("url must not be null");
        }
        if (urlString.length() > QueueConstants.maxUrlLength()) {
            throw new IllegalArgumentException("url is longer than " + Integer.valueOf(QueueConstants.maxUrlLength()).toString() + ".");
        }
        try {
            uri = new URI(urlString);
        }
        catch (URISyntaxException exception) {
            throw new IllegalArgumentException("URL syntax error", exception);
        }
        this.uriCheckNull(uri.getScheme(), "scheme");
        this.uriCheckNull(uri.getRawAuthority(), "authority");
        this.uriCheckNull(uri.getRawFragment(), "fragment");
        String path = uri.getPath();
        if (path == null || path.length() == 0 || path.charAt(0) != '/') {
            if (path == null) {
                path = "(null)";
            } else if (path.length() == 0) {
                path = "<empty string>";
            }
            throw new IllegalArgumentException("url must contain a path starting with '/' part - contains :" + path);
        }
        return uri;
    }

    private void uriCheckNull(String value, String valueName) {
        if (value != null) {
            throw new IllegalArgumentException("url must not contain a '" + valueName + "' part - contains :" + value);
        }
    }

    private void fillAddRequest(com.google.appengine.api.datastore.Transaction txn, TaskOptions taskOptions, TaskQueuePb.TaskQueueAddRequest addRequest) {
        String url;
        String taskName = taskOptions.getTaskName();
        boolean useUrlEncodedContentType = false;
        if (taskName != null && !taskName.equals("") && txn != null) {
            throw new IllegalArgumentException("transactional tasks cannot be named: " + taskOptions);
        }
        HashMap<String, List<String>> headers = taskOptions.getHeaders();
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (NamespaceManager.getGoogleAppsNamespace().length() != 0 && !headers.containsKey(DEFAULT_NAMESPACE_HEADER)) {
            headers.put(DEFAULT_NAMESPACE_HEADER, Arrays.asList(NamespaceManager.getGoogleAppsNamespace()));
        }
        if (!headers.containsKey(CURRENT_NAMESPACE_HEADER)) {
            String namespace = NamespaceManager.get();
            headers.put(CURRENT_NAMESPACE_HEADER, Arrays.asList(namespace == null ? "" : namespace));
        }
        if ((url = taskOptions.getUrl()) == null) {
            url = this.defaultUrl();
        }
        URI parsedUrl = this.parsePartialUrl(url);
        String query = parsedUrl.getQuery();
        byte[] payload = taskOptions.getPayload();
        List<TaskOptions.Param> params = taskOptions.getParams();
        StringBuilder relativeUrl = new StringBuilder(parsedUrl.getRawPath());
        if (query != null && query.length() != 0 && !params.isEmpty()) {
            throw new IllegalArgumentException("Query string and parameters both present; only one of these may be supplied");
        }
        if (taskOptions.getMethod() == TaskOptions.Method.POST) {
            if (!params.isEmpty() && payload != null) {
                throw new IllegalArgumentException("Message body and parameters both present for POST method; only one of these may be supplied");
            }
            if (query != null && query.length() != 0) {
                throw new IllegalArgumentException("POST method may not have a query string; use the setParamater(s) instead");
            }
            if (!params.isEmpty() || payload == null) {
                payload = this.encodeParamsPost(params);
                useUrlEncodedContentType = true;
            }
        } else {
            if (!params.isEmpty()) {
                query = this.encodeParamsUrlEncoded(params);
            }
            if (query != null && query.length() != 0) {
                relativeUrl.append("?").append(query);
            }
        }
        if (payload != null && payload.length != 0 && !taskOptions.getMethod().supportsBody()) {
            throw new IllegalArgumentException(taskOptions.getMethod().toString() + " method may not specify a payload.");
        }
        long etaMillis = this.determineEta(taskOptions);
        addRequest.setQueueName(this.queueName);
        addRequest.setEtaUsec(etaMillis * 1000L);
        addRequest.setMethod(taskOptions.getMethod().getPbMethod());
        addRequest.setTaskName(taskName == null ? "" : taskName);
        addRequest.setUrl(relativeUrl.toString());
        if (payload != null) {
            addRequest.setBodyAsBytes(payload);
        }
        if (txn != null) {
            addRequest.setTransaction(QueueImpl.localTxnToRemoteTxn(txn));
        }
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            if (useUrlEncodedContentType && entry.getKey().toLowerCase().equals("content-type")) continue;
            for (String value : entry.getValue()) {
                TaskQueuePb.TaskQueueAddRequest.Header header = addRequest.addHeader();
                header.setKey(entry.getKey());
                header.setValue(value);
            }
        }
        RetryOptions retryOptions = taskOptions.getRetryOptions();
        if (retryOptions != null) {
            QueueImpl.fillRetryParameters(retryOptions, addRequest.getMutableRetryParameters());
        }
        if (useUrlEncodedContentType) {
            TaskQueuePb.TaskQueueAddRequest.Header contentTypeHeader = addRequest.addHeader();
            contentTypeHeader.setKey("content-type");
            contentTypeHeader.setValue("application/x-www-form-urlencoded");
        }
        if (addRequest.toProtocolSink().position() > QueueConstants.maxTaskSizeBytes()) {
            throw new IllegalArgumentException("Task size too large");
        }
    }

    private static Transaction localTxnToRemoteTxn(com.google.appengine.api.datastore.Transaction local) {
        Transaction remote = new Transaction();
        remote.setApp(local.getApp());
        remote.setHandle(Long.parseLong(local.getId()));
        return remote;
    }

    private static void fillRetryParameters(RetryOptions retryOptions, TaskQueuePb.TaskQueueRetryParameters retryParameters) {
        if (retryOptions.getTaskRetryLimit() != null) {
            retryParameters.setRetryLimit(retryOptions.getTaskRetryLimit());
        }
        if (retryOptions.getTaskAgeLimitSeconds() != null) {
            retryParameters.setAgeLimitSec(retryOptions.getTaskAgeLimitSeconds());
        }
        if (retryOptions.getMinBackoffSeconds() != null) {
            retryParameters.setMinBackoffSec(retryOptions.getMinBackoffSeconds());
        }
        if (retryOptions.getMaxBackoffSeconds() != null) {
            retryParameters.setMaxBackoffSec(retryOptions.getMaxBackoffSeconds());
        }
        if (retryOptions.getMaxDoublings() != null) {
            retryParameters.setMaxDoublings(retryOptions.getMaxDoublings());
        }
        if (retryParameters.hasMinBackoffSec() && retryParameters.hasMaxBackoffSec()) {
            if (retryParameters.getMinBackoffSec() > retryParameters.getMaxBackoffSec()) {
                throw new IllegalArgumentException("minBackoffSeconds must not be greater than maxBackoffSeconds.");
            }
        } else if (retryParameters.hasMinBackoffSec()) {
            if (retryParameters.getMinBackoffSec() > retryParameters.getMaxBackoffSec()) {
                retryParameters.setMaxBackoffSec(retryParameters.getMinBackoffSec());
            }
        } else if (retryParameters.hasMaxBackoffSec() && retryParameters.getMinBackoffSec() > retryParameters.getMaxBackoffSec()) {
            retryParameters.setMinBackoffSec(retryParameters.getMaxBackoffSec());
        }
    }

    @Override
    public TaskHandle add(TaskOptions taskOptions) {
        return this.add(this.getDatastoreService().getCurrentTransaction(null), taskOptions);
    }

    @Override
    public List<TaskHandle> add(Iterable<TaskOptions> taskOptions) {
        return this.add(this.getDatastoreService().getCurrentTransaction(null), taskOptions);
    }

    @Override
    public TaskHandle add(com.google.appengine.api.datastore.Transaction txn, TaskOptions taskOptions) {
        return this.add(txn, Collections.singletonList(taskOptions)).get(0);
    }

    @Override
    public List<TaskHandle> add(com.google.appengine.api.datastore.Transaction txn, Iterable<TaskOptions> taskOptions) {
        ArrayList<TaskOptions> taskOptionsList = new ArrayList<TaskOptions>();
        HashSet<String> taskNames = new HashSet<String>();
        TaskQueuePb.TaskQueueBulkAddRequest bulkAddRequest = new TaskQueuePb.TaskQueueBulkAddRequest();
        TaskQueuePb.TaskQueueBulkAddResponse bulkAddResponse = new TaskQueuePb.TaskQueueBulkAddResponse();
        for (TaskOptions option : taskOptions) {
            this.fillAddRequest(txn, option, bulkAddRequest.addAddRequest());
            taskOptionsList.add(option);
            if (option.getTaskName() == null || option.getTaskName().equals("") || taskNames.add(option.getTaskName())) continue;
            throw new IllegalArgumentException(String.format("Identical task names in request : \"%s\" duplicated", option.getTaskName()));
        }
        if (bulkAddRequest.addRequestSize() > QueueConstants.maxTasksPerAdd()) {
            throw new IllegalArgumentException(String.format("No more than %d tasks can be added in a single add call", QueueConstants.maxTasksPerAdd()));
        }
        this.apiHelper.makeSyncCall("BulkAdd", bulkAddRequest, bulkAddResponse);
        if (bulkAddResponse.taskResultSize() != bulkAddRequest.addRequestSize()) {
            throw new InternalFailureException(String.format("expected %d results from BulkAdd(), got %d", bulkAddRequest.addRequestSize(), bulkAddResponse.taskResultSize()));
        }
        ArrayList<TaskHandle> tasks = new ArrayList<TaskHandle>();
        for (int i = 0; i < bulkAddResponse.taskResultSize(); ++i) {
            TaskQueuePb.TaskQueueBulkAddResponse.TaskResult taskResult = bulkAddResponse.taskResults().get(i);
            TaskQueuePb.TaskQueueAddRequest addRequest = bulkAddRequest.getAddRequest(i);
            TaskOptions options = (TaskOptions)taskOptionsList.get(i);
            if (taskResult.getResult() == TaskQueuePb.TaskQueueServiceError.ErrorCode.OK.getValue()) {
                String taskName = options.getTaskName();
                if (taskResult.hasChosenTaskName()) {
                    taskName = taskResult.getChosenTaskName();
                }
                tasks.add(new TaskHandle(taskName, this.queueName, addRequest.getEtaUsec() / 1000L));
                continue;
            }
            if (taskResult.getResult() == TaskQueuePb.TaskQueueServiceError.ErrorCode.SKIPPED.getValue()) continue;
            throw QueueApiHelper.translateError(taskResult.getResult(), "");
        }
        return tasks;
    }

    long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    private long determineEta(TaskOptions taskOptions) {
        Long etaMillis = taskOptions.getEtaMillis();
        Long countdownMillis = taskOptions.getCountdownMillis();
        if (etaMillis == null) {
            if (countdownMillis == null) {
                return this.currentTimeMillis();
            }
            if (countdownMillis > QueueConstants.getMaxEtaDeltaMillis()) {
                throw new IllegalArgumentException("ETA too far into the future");
            }
            if (countdownMillis < 0L) {
                throw new IllegalArgumentException("Negative countdown is not allowed");
            }
            return this.currentTimeMillis() + countdownMillis;
        }
        if (countdownMillis == null) {
            if (etaMillis - this.currentTimeMillis() > QueueConstants.getMaxEtaDeltaMillis()) {
                throw new IllegalArgumentException("ETA too far into the future");
            }
            if (etaMillis < 0L) {
                throw new IllegalArgumentException("Negative ETA is invalid");
            }
            return etaMillis;
        }
        throw new IllegalArgumentException("Only one or neither of EtaMillis and CountdownMillis may be specified");
    }

    byte[] encodeParamsPost(List<TaskOptions.Param> params) {
        byte[] payload;
        try {
            payload = this.encodeParamsUrlEncoded(params).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            throw new UnsupportedTranslationException(exception);
        }
        return payload;
    }

    String encodeParamsUrlEncoded(List<TaskOptions.Param> params) {
        StringBuilder result = new StringBuilder();
        try {
            String appender = "";
            for (TaskOptions.Param param : params) {
                result.append(appender);
                appender = "&";
                result.append(param.getURLEncodedName());
                result.append("=");
                result.append(param.getURLEncodedValue());
            }
        }
        catch (UnsupportedEncodingException exception) {
            throw new UnsupportedTranslationException(exception);
        }
        return result.toString();
    }

    private String defaultUrl() {
        return "/_ah/queue/" + this.queueName;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    DatastoreService getDatastoreService() {
        return this.datastoreService;
    }

    @Override
    public void purge() {
        TaskQueuePb.TaskQueuePurgeQueueRequest purgeRequest = new TaskQueuePb.TaskQueuePurgeQueueRequest();
        TaskQueuePb.TaskQueuePurgeQueueResponse purgeResponse = new TaskQueuePb.TaskQueuePurgeQueueResponse();
        purgeRequest.setQueueName(this.queueName);
        this.apiHelper.makeSyncCall("PurgeQueue", purgeRequest, purgeResponse);
    }
}

