/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import twitter4j.Trend;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.internal.util.ParseUtil;

final class TrendJSONImpl
implements Trend,
Serializable {
    private String name;
    private String url = null;
    private String query = null;
    private static final long serialVersionUID = 1925956704460743946L;

    TrendJSONImpl(JSONObject json) {
        this.name = ParseUtil.getRawString("name", json);
        this.url = ParseUtil.getRawString("url", json);
        this.query = ParseUtil.getRawString("query", json);
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Trend)) {
            return false;
        }
        Trend trend = (Trend)o;
        if (!this.name.equals(trend.getName())) {
            return false;
        }
        if (this.query != null ? !this.query.equals(trend.getQuery()) : trend.getQuery() != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(trend.getUrl()) : trend.getUrl() != null);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TrendJSONImpl{name='" + this.name + '\'' + ", url='" + this.url + '\'' + ", query='" + this.query + '\'' + '}';
    }
}

