/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.memcache;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.memcache.ErrorHandler;
import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.InvalidValueException;
import com.google.appengine.api.memcache.LogAndContinueErrorHandler;
import com.google.appengine.api.memcache.MemcacheSerialization;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceException;
import com.google.appengine.api.memcache.MemcacheServicePb;
import com.google.appengine.api.memcache.Stats;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MemcacheServiceImpl
implements MemcacheService {
    static final String PACKAGE = "memcache";
    private static final Logger logger = Logger.getLogger(MemcacheServiceImpl.class.getName());
    private ErrorHandler handler = new LogAndContinueErrorHandler(Level.INFO);
    private String namespace;

    MemcacheServiceImpl(String namespace) {
        if (namespace != null) {
            NamespaceManager.validateNamespace(namespace);
        }
        this.namespace = namespace;
    }

    private boolean makeSyncCall(String methodName, Message request, Message.Builder response, String errorText) {
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, methodName, request.toByteArray());
            response.mergeFrom(responseBytes);
            return true;
        }
        catch (InvalidProtocolBufferException ex) {
            this.handler.handleServiceError(new MemcacheServiceException("Could not decode response:", ex));
        }
        catch (ApiProxy.ApplicationException ae) {
            logger.info(errorText + ": " + ae.getErrorDetail());
            this.handler.handleServiceError(new MemcacheServiceException(errorText));
        }
        catch (ApiProxy.ApiProxyException ex) {
            this.handler.handleServiceError(new MemcacheServiceException(errorText, ex));
        }
        return false;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    @Deprecated
    public void setNamespace(String newNamespace) {
        this.namespace = newNamespace;
    }

    private String getEffectiveNamespace() {
        if (this.namespace != null) {
            return this.namespace;
        }
        return NamespaceManager.get();
    }

    @Override
    public boolean contains(Object key) {
        MemcacheServicePb.MemcacheGetRequest request;
        MemcacheServicePb.MemcacheGetResponse.Builder response = MemcacheServicePb.MemcacheGetResponse.newBuilder();
        try {
            request = MemcacheServicePb.MemcacheGetRequest.newBuilder().setNameSpace(this.getEffectiveNamespace()).addKey(ByteString.copyFrom(MemcacheSerialization.makePbKey(key))).build();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot use as key: '" + key + "'", ex);
        }
        if (!this.makeSyncCall("Get", request, response, "Memcache contains: exception testing contains (" + key + ")")) {
            return false;
        }
        return response.getItemCount() == 1;
    }

    @Override
    public Object get(Object key) {
        MemcacheServicePb.MemcacheGetRequest request;
        MemcacheServicePb.MemcacheGetResponse.Builder response = MemcacheServicePb.MemcacheGetResponse.newBuilder();
        try {
            request = MemcacheServicePb.MemcacheGetRequest.newBuilder().setNameSpace(this.getEffectiveNamespace()).addKey(ByteString.copyFrom(MemcacheSerialization.makePbKey(key))).build();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot use as a key: '" + key + "'", ex);
        }
        if (!this.makeSyncCall("Get", request, response, "Memcache get: exception getting 1 key (" + key + ")")) {
            return null;
        }
        if (response.getItemCount() == 0) {
            return null;
        }
        MemcacheServicePb.MemcacheGetResponse.Item item = response.getItem(0);
        try {
            return MemcacheSerialization.deserialize(item.getValue().toByteArray(), item.getFlags());
        }
        catch (ClassNotFoundException ex) {
            this.handler.handleDeserializationError(new InvalidValueException("Can't find class for value of key '" + key + "'", ex));
            return null;
        }
        catch (IOException ex) {
            throw new InvalidValueException("IO exception parsing value of '" + key + "'", ex);
        }
    }

    @Override
    public Map<Object, Object> getAll(Collection<Object> keys) {
        MemcacheServicePb.MemcacheGetResponse.Builder response = MemcacheServicePb.MemcacheGetResponse.newBuilder();
        MemcacheServicePb.MemcacheGetRequest.Builder requestBuilder = MemcacheServicePb.MemcacheGetRequest.newBuilder();
        requestBuilder.setNameSpace(this.getEffectiveNamespace());
        HashMap<CacheKey, Object> cacheKeyToObjectKey = new HashMap<CacheKey, Object>();
        for (Object key : keys) {
            try {
                byte[] keybytes = MemcacheSerialization.makePbKey(key);
                cacheKeyToObjectKey.put(new CacheKey(keybytes), key);
                requestBuilder.addKey(ByteString.copyFrom(keybytes));
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Cannot use as key: '" + key + "'", ex);
            }
        }
        if (!this.makeSyncCall("Get", requestBuilder.build(), response, "Memcache get: exception getting multiple keys")) {
            return Collections.emptyMap();
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (MemcacheServicePb.MemcacheGetResponse.Item item : response.getItemList()) {
            Object key = null;
            try {
                key = cacheKeyToObjectKey.get(new CacheKey(item.getKey().toByteArray()));
                Object obj = MemcacheSerialization.deserialize(item.getValue().toByteArray(), item.getFlags());
                result.put(key, obj);
            }
            catch (ClassNotFoundException ex) {
                this.handler.handleDeserializationError(new InvalidValueException("Can't find class for value of key '" + key + "'", ex));
                return null;
            }
            catch (IOException ex) {
                throw new InvalidValueException("IO exception parsing value of '" + key + "'", ex);
            }
        }
        return result;
    }

    @Override
    public boolean put(Object key, Object value, Expiration expires, MemcacheService.SetPolicy policy) {
        MemcacheServicePb.MemcacheSetResponse.Builder response = MemcacheServicePb.MemcacheSetResponse.newBuilder();
        MemcacheServicePb.MemcacheSetRequest.Builder requestBuilder = MemcacheServicePb.MemcacheSetRequest.newBuilder();
        requestBuilder.setNameSpace(this.getEffectiveNamespace());
        MemcacheServicePb.MemcacheSetRequest.Item.Builder itemBuilder = MemcacheServicePb.MemcacheSetRequest.Item.newBuilder();
        try {
            MemcacheSerialization.ValueAndFlags vaf = MemcacheSerialization.serialize(value);
            itemBuilder.setValue(ByteString.copyFrom(vaf.value));
            itemBuilder.setFlags(vaf.flags.ordinal());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot use as value: '" + value + "'", ex);
        }
        try {
            itemBuilder.setKey(ByteString.copyFrom(MemcacheSerialization.makePbKey(key)));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot use as key: '" + key + "'", ex);
        }
        itemBuilder.setExpirationTime(expires == null ? 0 : expires.getSecondsValue());
        itemBuilder.setSetPolicy(this.convertSetPolicyToPb(policy));
        requestBuilder.addItem(itemBuilder);
        if (!this.makeSyncCall("Set", requestBuilder.build(), response, "Memcache put: exception setting 1 key (" + key + ") to '" + value + "'")) {
            return false;
        }
        if (response.getSetStatusCount() != 1) {
            throw new MemcacheServiceException("Memcache put: Set one item, got " + response.getSetStatusCount() + " response statuses");
        }
        MemcacheServicePb.MemcacheSetResponse.SetStatusCode status = response.getSetStatus(0);
        if (status == MemcacheServicePb.MemcacheSetResponse.SetStatusCode.ERROR) {
            throw new MemcacheServiceException("Memcache put: Error setting single item (" + key + ")");
        }
        return status == MemcacheServicePb.MemcacheSetResponse.SetStatusCode.STORED;
    }

    private MemcacheServicePb.MemcacheSetRequest.SetPolicy convertSetPolicyToPb(MemcacheService.SetPolicy policy) {
        switch (policy) {
            case SET_ALWAYS: {
                return MemcacheServicePb.MemcacheSetRequest.SetPolicy.SET;
            }
            case ADD_ONLY_IF_NOT_PRESENT: {
                return MemcacheServicePb.MemcacheSetRequest.SetPolicy.ADD;
            }
            case REPLACE_ONLY_IF_PRESENT: {
                return MemcacheServicePb.MemcacheSetRequest.SetPolicy.REPLACE;
            }
        }
        throw new IllegalArgumentException("Unknown policy: " + (Object)((Object)policy));
    }

    @Override
    public void put(Object key, Object value, Expiration expires) {
        this.put(key, value, expires, MemcacheService.SetPolicy.SET_ALWAYS);
    }

    @Override
    public void put(Object key, Object value) {
        this.put(key, value, null, MemcacheService.SetPolicy.SET_ALWAYS);
    }

    @Override
    public Set<Object> putAll(Map<Object, Object> values, Expiration expires, MemcacheService.SetPolicy policy) {
        MemcacheServicePb.MemcacheSetResponse.Builder response = MemcacheServicePb.MemcacheSetResponse.newBuilder();
        MemcacheServicePb.MemcacheSetRequest.Builder requestBuilder = MemcacheServicePb.MemcacheSetRequest.newBuilder();
        requestBuilder.setNameSpace(this.getEffectiveNamespace());
        HashMap<CacheKey, Object> cacheKeyToObjectKey = new HashMap<CacheKey, Object>();
        for (Map.Entry<Object, Object> entry : values.entrySet()) {
            MemcacheServicePb.MemcacheSetRequest.Item.Builder itemBuilder = MemcacheServicePb.MemcacheSetRequest.Item.newBuilder();
            try {
                byte[] sha1 = MemcacheSerialization.makePbKey(entry.getKey());
                cacheKeyToObjectKey.put(new CacheKey(sha1), entry.getKey());
                itemBuilder.setKey(ByteString.copyFrom(sha1));
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Cannot use as key: '" + entry.getKey() + "'", ex);
            }
            try {
                MemcacheSerialization.ValueAndFlags vaf = MemcacheSerialization.serialize(entry.getValue());
                itemBuilder.setValue(ByteString.copyFrom(vaf.value));
                itemBuilder.setFlags(vaf.flags.ordinal());
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Cannot use as value: '" + entry.getValue() + "'", ex);
            }
            itemBuilder.setExpirationTime(expires == null ? 0 : expires.getSecondsValue());
            itemBuilder.setSetPolicy(this.convertSetPolicyToPb(policy));
            requestBuilder.addItem(itemBuilder);
        }
        MemcacheServicePb.MemcacheSetRequest request = requestBuilder.build();
        if (!this.makeSyncCall("Set", request, response, "Memcache put: Unknown exception setting " + values.size() + " keys")) {
            return new HashSet<Object>();
        }
        HashSet<Object> result = new HashSet<Object>();
        HashSet<byte[]> errors = new HashSet<byte[]>();
        if (response.getSetStatusCount() != values.size()) {
            throw new MemcacheServiceException("Memcache put: Set " + values.size() + " items, got " + response.getSetStatusCount() + " response statuses");
        }
        for (int i = 0; i < values.size(); ++i) {
            MemcacheServicePb.MemcacheSetResponse.SetStatusCode status = response.getSetStatus(i);
            byte[] byArray = request.getItem(i).getKey().toByteArray();
            if (status == MemcacheServicePb.MemcacheSetResponse.SetStatusCode.ERROR) {
                errors.add(byArray);
                continue;
            }
            if (status != MemcacheServicePb.MemcacheSetResponse.SetStatusCode.STORED) continue;
            result.add(cacheKeyToObjectKey.get(new CacheKey(byArray)));
        }
        if (errors.size() != 0) {
            StringBuilder builder = new StringBuilder();
            for (Object e : errors) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(e);
            }
            throw new MemcacheServiceException("Memcache put: Set failed to set " + errors.size() + " keys: " + builder.toString());
        }
        return result;
    }

    @Override
    public void putAll(Map<Object, Object> values, Expiration expires) {
        this.putAll(values, expires, MemcacheService.SetPolicy.SET_ALWAYS);
    }

    @Override
    public void putAll(Map<Object, Object> values) {
        this.putAll(values, null, MemcacheService.SetPolicy.SET_ALWAYS);
    }

    @Override
    public boolean delete(Object key) {
        return this.delete(key, 0L);
    }

    @Override
    public boolean delete(Object key, long millisNoReAdd) {
        MemcacheServicePb.MemcacheDeleteRequest request;
        MemcacheServicePb.MemcacheDeleteResponse.Builder response = MemcacheServicePb.MemcacheDeleteResponse.newBuilder();
        try {
            MemcacheServicePb.MemcacheDeleteRequest.Item.Builder item = MemcacheServicePb.MemcacheDeleteRequest.Item.newBuilder().setKey(ByteString.copyFrom(MemcacheSerialization.makePbKey(key))).setDeleteTime((int)(millisNoReAdd / 1000L));
            request = MemcacheServicePb.MemcacheDeleteRequest.newBuilder().setNameSpace(this.getEffectiveNamespace()).addItem(item).build();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot use as key: '" + key + "'", ex);
        }
        if (!this.makeSyncCall("Delete", request, response, "Memcache delete: Unknown exception deleting key: " + key)) {
            return false;
        }
        return response.getDeleteStatus(0) == MemcacheServicePb.MemcacheDeleteResponse.DeleteStatusCode.DELETED;
    }

    @Override
    public Set<Object> deleteAll(Collection<Object> keys) {
        return this.deleteAll(keys, 0L);
    }

    @Override
    public Set<Object> deleteAll(Collection<Object> keys, long millisNoReAdd) {
        MemcacheServicePb.MemcacheDeleteResponse.Builder response;
        HashMap<CacheKey, Object> cacheKeyToObjectKey = new HashMap<CacheKey, Object>();
        MemcacheServicePb.MemcacheDeleteRequest.Builder requestBuilder = MemcacheServicePb.MemcacheDeleteRequest.newBuilder().setNameSpace(this.getEffectiveNamespace());
        for (Object key : keys) {
            try {
                byte[] sha1 = MemcacheSerialization.makePbKey(key);
                cacheKeyToObjectKey.put(new CacheKey(sha1), key);
                requestBuilder.addItem(MemcacheServicePb.MemcacheDeleteRequest.Item.newBuilder().setDeleteTime((int)(millisNoReAdd / 1000L)).setKey(ByteString.copyFrom(sha1)));
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Cannot use as key: '" + key + "'", ex);
            }
        }
        MemcacheServicePb.MemcacheDeleteRequest request = requestBuilder.build();
        if (!this.makeSyncCall("Delete", request, response = MemcacheServicePb.MemcacheDeleteResponse.newBuilder(), "Memcache delete: Unknown exception deleting multiple keys")) {
            return new HashSet<Object>();
        }
        HashSet<Object> retval = new HashSet<Object>();
        for (int i = 0; i < response.getDeleteStatusCount(); ++i) {
            if (response.getDeleteStatus(i) != MemcacheServicePb.MemcacheDeleteResponse.DeleteStatusCode.DELETED) continue;
            retval.add(cacheKeyToObjectKey.get(new CacheKey(request.getItem(i).getKey().toByteArray())));
        }
        return retval;
    }

    private MemcacheServicePb.MemcacheIncrementRequest internalBuildIncrementRequest(Object key, long delta, Long initialValue, MemcacheServicePb.MemcacheIncrementRequest.Builder requestBuilder) {
        try {
            requestBuilder.setKey(ByteString.copyFrom(MemcacheSerialization.makePbKey(key)));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot use as key: '" + key + "'", ex);
        }
        if (delta > 0L) {
            requestBuilder.setDirection(MemcacheServicePb.MemcacheIncrementRequest.Direction.INCREMENT);
            requestBuilder.setDelta(delta);
        } else {
            requestBuilder.setDirection(MemcacheServicePb.MemcacheIncrementRequest.Direction.DECREMENT);
            requestBuilder.setDelta(-delta);
        }
        if (initialValue != null) {
            requestBuilder.setInitialValue(initialValue);
            requestBuilder.setInitialFlags(MemcacheSerialization.Flag.LONG.ordinal());
        }
        return requestBuilder.build();
    }

    @Override
    public Long increment(Object key, long delta) {
        return this.increment(key, delta, null);
    }

    @Override
    public Long increment(Object key, long delta, Long initialValue) {
        MemcacheServicePb.MemcacheIncrementResponse.Builder response = MemcacheServicePb.MemcacheIncrementResponse.newBuilder();
        MemcacheServicePb.MemcacheIncrementRequest.Builder requestBuilder = MemcacheServicePb.MemcacheIncrementRequest.newBuilder();
        MemcacheServicePb.MemcacheIncrementRequest request = this.internalBuildIncrementRequest(key, delta, initialValue, requestBuilder.setNameSpace(this.getEffectiveNamespace()));
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, "Increment", request.toByteArray());
            response.mergeFrom(responseBytes);
        }
        catch (InvalidProtocolBufferException ex) {
            this.handler.handleServiceError(new MemcacheServiceException("Could not decode response:", ex));
        }
        catch (ApiProxy.ApplicationException ex) {
            logger.info(ex.getErrorDetail());
            throw new InvalidValueException("Non-incrementable value for key '" + key + "'");
        }
        catch (ApiProxy.ApiProxyException ex) {
            this.handler.handleServiceError(new MemcacheServiceException("Memcache increment of key '" + key + "': exception", ex));
        }
        if (!response.hasNewValue()) {
            return null;
        }
        return response.getNewValue();
    }

    @Override
    public Map<Object, Long> incrementAll(Collection<Object> keys, long delta) {
        return this.incrementAll(keys, delta, null);
    }

    @Override
    public Map<Object, Long> incrementAll(Collection<Object> keys, long delta, Long initialValue) {
        LinkedHashMap<Object, Long> offsets = new LinkedHashMap<Object, Long>();
        Long deltaLong = delta;
        for (Object key : keys) {
            offsets.put(key, delta);
        }
        return this.incrementAll(offsets, initialValue);
    }

    @Override
    public Map<Object, Long> incrementAll(Map<Object, Long> offsets) {
        return this.incrementAll(offsets, null);
    }

    @Override
    public Map<Object, Long> incrementAll(Map<Object, Long> offsets, Long initialValue) {
        MemcacheServicePb.MemcacheBatchIncrementRequest.Builder requestBuilder = MemcacheServicePb.MemcacheBatchIncrementRequest.newBuilder().setNameSpace(this.getEffectiveNamespace());
        MemcacheServicePb.MemcacheBatchIncrementResponse.Builder response = MemcacheServicePb.MemcacheBatchIncrementResponse.newBuilder();
        for (Map.Entry<Object, Long> entry : offsets.entrySet()) {
            requestBuilder.addItem(this.internalBuildIncrementRequest(entry.getKey(), entry.getValue(), initialValue, MemcacheServicePb.MemcacheIncrementRequest.newBuilder()));
        }
        MemcacheServicePb.MemcacheBatchIncrementRequest request = requestBuilder.build();
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, "BatchIncrement", request.toByteArray());
            response.mergeFrom(responseBytes);
        }
        catch (InvalidProtocolBufferException ex) {
            this.handler.handleServiceError(new MemcacheServiceException("Could not decode response:", ex));
        }
        catch (ApiProxy.ApiProxyException ex) {
            this.handler.handleServiceError(new MemcacheServiceException("Memcache batch increment exception", ex));
        }
        assert (response.getItemCount() == request.getItemCount());
        HashMap<Object, Long> result = new HashMap<Object, Long>();
        int index = 0;
        for (Map.Entry<Object, Long> entry : offsets.entrySet()) {
            MemcacheServicePb.MemcacheIncrementResponse responseItem;
            if ((responseItem = response.getItem(index++)).getIncrementStatus().equals(MemcacheServicePb.MemcacheIncrementResponse.IncrementStatusCode.OK) && responseItem.hasNewValue()) {
                result.put(entry.getKey(), responseItem.getNewValue());
                continue;
            }
            result.put(entry.getKey(), null);
        }
        return result;
    }

    @Override
    public void clearAll() {
        MemcacheServicePb.MemcacheFlushRequest request = MemcacheServicePb.MemcacheFlushRequest.newBuilder().build();
        MemcacheServicePb.MemcacheFlushResponse.Builder response = MemcacheServicePb.MemcacheFlushResponse.newBuilder();
        this.makeSyncCall("FlushAll", request, response, "Memcache flush: exception");
    }

    @Override
    public Stats getStatistics() {
        MemcacheServicePb.MemcacheStatsResponse.Builder response;
        MemcacheServicePb.MemcacheStatsRequest request = MemcacheServicePb.MemcacheStatsRequest.newBuilder().build();
        if (!this.makeSyncCall("Stats", request, response = MemcacheServicePb.MemcacheStatsResponse.newBuilder(), "Memcache getStatistics: exception")) {
            return null;
        }
        MemcacheServicePb.MergedNamespaceStats stats = response.getStats();
        if (stats == null) {
            return new StatsImpl(0L, 0L, 0L, 0L, 0L, 0);
        }
        return new StatsImpl(stats.getHits(), stats.getMisses(), stats.getByteHits(), stats.getItems(), stats.getBytes(), stats.getOldestItemAge());
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.handler;
    }

    @Override
    public void setErrorHandler(ErrorHandler newHandler) {
        this.handler = newHandler;
    }

    public List<Object> grabTail(int itemCount) {
        if (this.getEffectiveNamespace().length() == 0) {
            throw new IllegalStateException("Namespace should be non-empty.");
        }
        MemcacheServicePb.MemcacheGrabTailResponse.Builder response = MemcacheServicePb.MemcacheGrabTailResponse.newBuilder();
        MemcacheServicePb.MemcacheGrabTailRequest.Builder requestBuilder = MemcacheServicePb.MemcacheGrabTailRequest.newBuilder();
        requestBuilder.setNameSpace(this.getEffectiveNamespace());
        requestBuilder.setItemCount(itemCount);
        if (!this.makeSyncCall("GrabTail", requestBuilder.build(), response, "Memcache get: exception getting multiple keys")) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (MemcacheServicePb.MemcacheGrabTailResponse.Item item : response.getItemList()) {
            try {
                Object obj = MemcacheSerialization.deserialize(item.getValue().toByteArray(), item.getFlags());
                result.add(obj);
            }
            catch (ClassNotFoundException ex) {
                this.handler.handleDeserializationError(new InvalidValueException("Can't find class", ex));
                return null;
            }
            catch (IOException ex) {
                throw new InvalidValueException("IO exception parsing value", ex);
            }
        }
        return result;
    }

    private class StatsImpl
    implements Stats {
        private long hits;
        private long misses;
        private long bytesFetched;
        private long items;
        private long bytesStored;
        private int maxCachedTime;

        private StatsImpl(long hits, long misses, long bytesFetched, long items, long bytesStored, int maxCachedTime) {
            this.hits = hits;
            this.misses = misses;
            this.bytesFetched = bytesFetched;
            this.items = items;
            this.bytesStored = bytesStored;
            this.maxCachedTime = maxCachedTime;
        }

        public long getHitCount() {
            return this.hits;
        }

        public long getMissCount() {
            return this.misses;
        }

        public long getBytesReturnedForHits() {
            return this.bytesFetched;
        }

        public long getItemCount() {
            return this.items;
        }

        public long getTotalItemBytes() {
            return this.bytesStored;
        }

        public int getMaxTimeWithoutAccess() {
            return this.maxCachedTime;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Hits: " + this.hits + "\n");
            builder.append("Misses: " + this.misses + "\n");
            builder.append("Bytes Fetched: " + this.bytesFetched + "\n");
            builder.append("Bytes Stored: " + this.bytesStored + "\n");
            builder.append("Items: " + this.items + "\n");
            builder.append("Max Cached Time: " + this.maxCachedTime + "\n");
            return builder.toString();
        }
    }

    private class CacheKey {
        private byte[] keyval;
        private int hashcode;

        public CacheKey(byte[] bytes) {
            this.keyval = bytes;
            this.hashcode = Arrays.hashCode(this.keyval);
        }

        public byte[] getBytes() {
            return this.keyval;
        }

        public boolean equals(Object other) {
            if (other instanceof CacheKey) {
                return Arrays.equals(this.keyval, ((CacheKey)other).keyval);
            }
            return false;
        }

        public int hashCode() {
            return this.hashcode;
        }
    }
}

