/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ConfigurationDirUtilities;
import charactermanaj.util.SetupLocalization;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;

public class ResourceLoader {
    private final ClassLoader classLoader;

    public ResourceLoader() {
        this(true);
    }

    public ResourceLoader(boolean preferredLocal) {
        this(ResourceLoader.getUsersResourceDirClassLoader(ResourceLoader.getDefaultClassLoader(), preferredLocal));
    }

    public ResourceLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader is required.");
        }
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public URL getResource(String name) {
        if (name == null) {
            return null;
        }
        return this.getClassLoader().getResource(name);
    }

    public static ClassLoader getDefaultClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = ResourceLoader.class.getClassLoader();
                }
                return cl;
            }
        });
    }

    public static ClassLoader getUsersResourceDirClassLoader(final ClassLoader parent, final boolean preferredLocal) {
        try {
            File baseDir = ConfigurationDirUtilities.getUserDataDir();
            SetupLocalization localize = new SetupLocalization(baseDir);
            final File resourceDir = localize.getResourceDir();
            if (!resourceDir.exists() || !resourceDir.isDirectory()) {
                return parent;
            }
            URLClassLoader cl = AccessController.doPrivileged(new PrivilegedExceptionAction<URLClassLoader>(){

                @Override
                public URLClassLoader run() throws MalformedURLException {
                    URL[] urls = new URL[]{resourceDir.toURI().toURL()};
                    if (preferredLocal) {
                        return new URLClassLoader(urls, parent){

                            @Override
                            public URL getResource(String name) {
                                ClassLoader parent;
                                URL url = this.findResource(name);
                                if (url == null && (parent = this.getParent()) != null) {
                                    url = parent.getResource(name);
                                }
                                return url;
                            }
                        };
                    }
                    return new URLClassLoader(urls, parent);
                }
            });
            return cl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

