/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.clipboardSupport.ClipboardUtil;
import charactermanaj.graphics.io.FileImageResource;
import charactermanaj.graphics.io.ImageCachedLoader;
import charactermanaj.graphics.io.LoadedImage;
import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.CharacterDataChangeObserver;
import charactermanaj.model.CustomLayerOrder;
import charactermanaj.model.CustomLayerOrderKey;
import charactermanaj.model.RecommendationURL;
import charactermanaj.model.io.CharacterDataDefaultProvider;
import charactermanaj.model.io.CharacterDataPersistent;
import charactermanaj.model.io.CustomLayerOrderPersist;
import charactermanaj.model.io.PartsImageDirectoryWatchAgent;
import charactermanaj.model.io.PartsImageDirectoryWatchAgentFactory;
import charactermanaj.ui.ExportWizardDialog;
import charactermanaj.ui.ImportWizardDialog;
import charactermanaj.ui.ProfileEditDialog;
import charactermanaj.ui.ProfileListManager;
import charactermanaj.ui.ProfileSelectorTableModel;
import charactermanaj.ui.SamplePicturePanel;
import charactermanaj.ui.util.FileDropTarget;
import charactermanaj.ui.util.ScaleSupport;
import charactermanaj.ui.util.SingleRootFileSystemView;
import charactermanaj.util.DesktopUtilities;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import charactermanaj.util.UIHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;

public class ProfileSelectorDialog
extends JDialog {
    private static final long serialVersionUID = -6883202891172975022L;
    private static final Logger logger = Logger.getLogger(ProfileSelectorDialog.class.getName());
    protected static final String STRINGS_RESOURCE = "languages/profileselectordialog";
    private ImageCachedLoader imageLoader = new ImageCachedLoader();
    private boolean canWriteSamplePicture;
    private SamplePicturePanel sampleImgPanel;
    private Action actOK;
    private Action actCancel;
    private Action actProfileNew;
    private Action actProfileCopy;
    private Action actProfileEdit;
    private Action actProfileRemove;
    private Action actProfileBrowse;
    private Action actProfileImport;
    private Action actProfileExport;
    private Action actProfileTemplate;
    private JTable characterList;
    private ProfileSelectorTableModel characterListModel;
    private JTextArea descriptionArea;
    private CharacterData selectedCharacterData;

    public ProfileSelectorDialog(JFrame parent, List<CharacterData> characterDatas) {
        super((Frame)parent, true);
        if (characterDatas == null) {
            throw new IllegalArgumentException();
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProfileSelectorDialog.this.onClosing();
            }
        });
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.setTitle(strings.getProperty("title"));
        JPanel pnlProfiles = new JPanel(new BorderLayout());
        this.characterListModel = new ProfileSelectorTableModel();
        this.characterListModel.setModel(characterDatas);
        this.characterList = new JTable(this.characterListModel){
            private static final long serialVersionUID = 1L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Font f;
                CharacterData cd = ProfileSelectorDialog.this.characterListModel.getRow(row);
                Component comp = super.prepareRenderer(renderer, row, column);
                if (ProfileListManager.isUsingCharacterData(cd)) {
                    f = comp.getFont();
                    comp.setFont(f.deriveFont(1));
                }
                if (!cd.canWrite()) {
                    f = comp.getFont();
                    comp.setFont(f.deriveFont(2));
                }
                return comp;
            }
        };
        this.characterList.setAutoResizeMode(0);
        this.characterList.setSelectionMode(0);
        this.characterList.setRowHeight((int)((double)this.characterList.getFont().getSize() * 1.2));
        ScaleSupport scaleSupport = ScaleSupport.getInstance(this);
        this.characterListModel.adjustColumnModel(this.characterList.getColumnModel(), scaleSupport.getManualScaleX());
        this.characterList.setSelectionMode(0);
        this.characterList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ProfileSelectorDialog.this.updateUIState();
                }
            }
        });
        this.characterList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ProfileSelectorDialog.this.onOK();
                }
            }
        });
        JScrollPane characterListSP = new JScrollPane(this.characterList);
        characterListSP.setVerticalScrollBarPolicy(22);
        characterListSP.setHorizontalScrollBarPolicy(32);
        pnlProfiles.add((Component)characterListSP, "Center");
        this.actOK = new AbstractAction(strings.getProperty("btn.select")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfileSelectorDialog.this.onOK();
            }
        };
        this.actCancel = new AbstractAction(strings.getProperty("btn.cancel")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfileSelectorDialog.this.onCancel();
            }
        };
        this.actProfileNew = new AbstractAction(strings.getProperty("profile.new")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfileSelectorDialog.this.onProfileNew(true);
            }
        };
        this.actProfileCopy = new AbstractAction(strings.getProperty("profile.copy")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfileSelectorDialog.this.onProfileNew(false);
            }
        };
        this.actProfileEdit = new AbstractAction(strings.getProperty("profile.edit")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfileSelectorDialog.this.onProfileEdit();
            }
        };
        this.actProfileRemove = new AbstractAction(strings.getProperty("profile.remove")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfileSelectorDialog.this.onProfileRemove();
            }
        };
        this.actProfileBrowse = new AbstractAction(strings.getProperty("profile.browse")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfileSelectorDialog.this.onProfileBrowse();
            }
        };
        this.actProfileImport = new AbstractAction(strings.getProperty("profile.import")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfileSelectorDialog.this.onProfileImport();
            }
        };
        this.actProfileExport = new AbstractAction(strings.getProperty("profile.export")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfileSelectorDialog.this.onProfileExport();
            }
        };
        this.actProfileTemplate = new AbstractAction(strings.getProperty("profile.template")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfileSelectorDialog.this.onProfileTemplate();
            }
        };
        final JPopupMenu popupTblMenu = new JPopupMenu();
        popupTblMenu.add(new JMenuItem(this.actOK));
        popupTblMenu.add(new JSeparator());
        popupTblMenu.add(new JMenuItem(this.actProfileCopy));
        popupTblMenu.add(new JMenuItem(this.actProfileEdit));
        popupTblMenu.add(new JMenuItem(this.actProfileRemove));
        popupTblMenu.add(new JSeparator());
        popupTblMenu.add(new JMenuItem(this.actProfileBrowse));
        popupTblMenu.add(new JMenuItem(this.actProfileImport));
        popupTblMenu.add(new JMenuItem(this.actProfileExport));
        popupTblMenu.add(new JSeparator());
        popupTblMenu.add(new JMenuItem(this.actProfileTemplate));
        this.characterList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.evaluatePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.evaluatePopup(e);
            }

            private void evaluatePopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popupTblMenu.show(ProfileSelectorDialog.this.characterList, e.getX(), e.getY());
                }
            }
        });
        JButton btnProfileNew = new JButton(this.actProfileNew);
        JButton btnProfileCopy = new JButton(this.actProfileCopy);
        JButton btnProfileEdit = new JButton(this.actProfileEdit);
        JButton btnProfileRemove = new JButton(this.actProfileRemove);
        JButton btnProfileBrowse = new JButton(this.actProfileBrowse);
        JButton btnProfileImport = new JButton(this.actProfileImport);
        JButton btnProfileExport = new JButton(this.actProfileExport);
        JButton btnProfileTemplate = new JButton(this.actProfileTemplate);
        JPanel pnlProfileEditButtons = new JPanel();
        pnlProfileEditButtons.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.insets = new Insets(0, 3, 0, 3);
        pnlProfileEditButtons.add((Component)btnProfileNew, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        pnlProfileEditButtons.add((Component)btnProfileCopy, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        pnlProfileEditButtons.add((Component)btnProfileEdit, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        pnlProfileEditButtons.add((Component)btnProfileRemove, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weighty = 1.0;
        pnlProfileEditButtons.add(Box.createGlue(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weighty = 0.0;
        pnlProfileEditButtons.add((Component)btnProfileBrowse, gbc);
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.weighty = 0.0;
        pnlProfileEditButtons.add((Component)btnProfileImport, gbc);
        gbc.gridx = 0;
        gbc.gridy = 7;
        pnlProfileEditButtons.add((Component)btnProfileExport, gbc);
        gbc.gridx = 0;
        gbc.gridy = 8;
        pnlProfileEditButtons.add((Component)btnProfileTemplate, gbc);
        JPanel pnlProfilesGroup = new JPanel(new BorderLayout());
        pnlProfilesGroup.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(strings.getProperty("profiles"))));
        pnlProfilesGroup.add((Component)pnlProfiles, "Center");
        pnlProfilesGroup.add((Component)pnlProfileEditButtons, "East");
        JPanel infoPanel = new JPanel(new GridLayout(1, 2));
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(strings.getProperty("description"))));
        this.descriptionArea = new JTextArea();
        this.descriptionArea.setEditable(false);
        descriptionPanel.add((Component)new JScrollPane(this.descriptionArea), "Center");
        this.sampleImgPanel = new SamplePicturePanel();
        new DropTarget(this.sampleImgPanel, new FileDropTarget(){

            @Override
            protected void onDropFiles(final List<File> dropFiles) {
                if (dropFiles == null || dropFiles.isEmpty()) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProfileSelectorDialog.this.onDrop(dropFiles);
                    }
                });
            }

            @Override
            protected void onException(Exception ex) {
                ErrorMessageHelper.showErrorDialog(ProfileSelectorDialog.this, ex);
            }
        });
        final JPopupMenu popupMenu = new JPopupMenu();
        final JMenuItem popupMenuCut = popupMenu.add(new AbstractAction(strings.getProperty("samplepicture.cut")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfileSelectorDialog.this.onSamplePictureCut();
            }
        });
        final JMenuItem popupMenuPaste = popupMenu.add(new AbstractAction(strings.getProperty("samplepicture.paste")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfileSelectorDialog.this.onSamplePicturePaste();
            }
        });
        this.sampleImgPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.evaluatePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.evaluatePopup(e);
            }

            private void evaluatePopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popupMenuCut.setEnabled(ProfileSelectorDialog.this.sampleImgPanel.getSamplePictrue() != null && ProfileSelectorDialog.this.canWriteSamplePicture);
                    popupMenuPaste.setEnabled(ProfileSelectorDialog.this.canWriteSamplePicture && ClipboardUtil.hasImage());
                    popupMenu.show(ProfileSelectorDialog.this.sampleImgPanel, e.getX(), e.getY());
                }
            }
        });
        JScrollPane sampleImgPanelSp = new JScrollPane(this.sampleImgPanel);
        sampleImgPanelSp.setBorder(null);
        JPanel sampleImgTitledPanel = new JPanel(new BorderLayout());
        sampleImgTitledPanel.add((Component)sampleImgPanelSp, "Center");
        sampleImgTitledPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(strings.getProperty("sample-image"))));
        infoPanel.add(descriptionPanel);
        infoPanel.add(sampleImgTitledPanel);
        JSplitPane centerPane = new JSplitPane(0, true);
        centerPane.setResizeWeight(1.0);
        centerPane.setDividerLocation(Integer.parseInt(strings.getProperty("dividerLocation")));
        centerPane.add(pnlProfilesGroup);
        centerPane.add(infoPanel);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)centerPane, "Center");
        JPanel btnPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(btnPanel, 2);
        btnPanel.setLayout(boxLayout);
        btnPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 42));
        JButton btnOK = new JButton(this.actOK);
        JButton btnCancel = new JButton(this.actCancel);
        if (Main.isLinuxOrMacOSX()) {
            btnPanel.add(btnCancel);
            btnPanel.add(btnOK);
        } else {
            btnPanel.add(btnOK);
            btnPanel.add(btnCancel);
        }
        JPanel btnPanel2 = new JPanel(new BorderLayout());
        btnPanel2.add((Component)btnPanel, "East");
        contentPane.add((Component)btnPanel2, "South");
        Toolkit tk = Toolkit.getDefaultToolkit();
        JRootPane rootPane = this.getRootPane();
        rootPane.setDefaultButton(btnOK);
        InputMap im = rootPane.getInputMap(2);
        ActionMap am = rootPane.getActionMap();
        im.put(KeyStroke.getKeyStroke(27, 0), "closeProfileSelectorDialog");
        im.put(KeyStroke.getKeyStroke(87, tk.getMenuShortcutKeyMask()), "closeProfileSelectorDialog");
        am.put("closeProfileSelectorDialog", this.actCancel);
        int width = Integer.parseInt(strings.getProperty("windowWidth"));
        int height = Integer.parseInt(strings.getProperty("windowHeight"));
        Dimension dim = new Dimension(width, height);
        dim = scaleSupport.manualScaled(dim);
        this.setSize(dim);
        this.setLocationRelativeTo(parent);
        this.characterList.requestFocus();
        this.updateUIState();
    }

    public CharacterData getSelectedCharacterData() {
        return this.selectedCharacterData;
    }

    protected void updateUIState() {
        CharacterData characterData = null;
        int selRow = this.characterList.getSelectedRow();
        if (selRow >= 0) {
            characterData = this.characterListModel.getRow(selRow);
        }
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        boolean selected = characterData != null;
        boolean enableEdit = characterData != null && characterData.canWrite();
        this.actOK.setEnabled(selected);
        this.actProfileNew.setEnabled(true);
        this.actProfileCopy.setEnabled(selected);
        this.actProfileEdit.setEnabled(selected);
        this.actProfileRemove.setEnabled(selected && enableEdit);
        this.actProfileImport.setEnabled(true);
        this.actProfileExport.setEnabled(selected);
        this.actProfileBrowse.setEnabled(selected);
        this.actProfileTemplate.setEnabled(selected);
        if (enableEdit) {
            this.actProfileEdit.putValue("Name", strings.getProperty("profile.edit"));
        } else {
            this.actProfileEdit.putValue("Name", strings.getProperty("profile.edit.readonly"));
        }
        boolean removable = characterData != null && characterData.isValid() && !ProfileListManager.isUsingCharacterData(characterData) && characterData.canWrite();
        this.actProfileRemove.setEnabled(removable);
        boolean canWriteSamplePicture = false;
        BufferedImage sampleImage = null;
        if (characterData != null && characterData.isValid()) {
            Dimension imageSize;
            StringWriter sw = new StringWriter();
            PrintWriter descriptionBuf = new PrintWriter(sw);
            URI docBase = characterData.getDocBase();
            String author = characterData.getAuthor();
            String description = characterData.getDescription();
            if (docBase != null) {
                descriptionBuf.println("configuration: " + docBase);
            }
            if (author != null && author.length() > 0) {
                descriptionBuf.println("author: " + author);
            }
            if ((imageSize = characterData.getImageSize()) != null) {
                descriptionBuf.println("size: " + imageSize.width + "x" + imageSize.height);
            }
            if (description != null) {
                description = description.replace("\r\n", "\n");
                description = description.replace("\r", "\n");
                description = description.replace("\n", System.getProperty("line.separator"));
                descriptionBuf.println(description);
            }
            this.descriptionArea.setText(sw.toString());
            this.descriptionArea.setSelectionStart(0);
            this.descriptionArea.setSelectionEnd(0);
            try {
                CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
                sampleImage = persist.loadSamplePicture(characterData, this.imageLoader);
                canWriteSamplePicture = persist.canSaveSamplePicture(characterData);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "sample picture loading failed. " + characterData, ex);
                sampleImage = null;
            }
        }
        this.canWriteSamplePicture = canWriteSamplePicture;
        String dropHere = strings.getProperty("dropHere");
        String noPicture = strings.getProperty("nopicture");
        this.sampleImgPanel.setSamplePicture(sampleImage);
        this.sampleImgPanel.setAlternateText(canWriteSamplePicture ? dropHere : noPicture);
    }

    protected void onSamplePictureCut() {
        int selRow = this.characterList.getSelectedRow();
        if (selRow < 0) {
            return;
        }
        CharacterData characterData = this.characterListModel.getRow(selRow);
        BufferedImage img = this.sampleImgPanel.getSamplePictrue();
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (characterData == null || !characterData.isValid() || !this.canWriteSamplePicture || img == null) {
            tk.beep();
            return;
        }
        try {
            Color bgColor = AppConfig.getInstance().getSampleImageBgColor();
            ClipboardUtil.setImage(img, bgColor);
            CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
            persist.saveSamplePicture(characterData, null);
            this.sampleImgPanel.setSamplePicture(null);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onSamplePicturePaste() {
        CharacterData characterData = null;
        int selRow = this.characterList.getSelectedRow();
        if (selRow >= 0) {
            characterData = this.characterListModel.getRow(selRow);
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (characterData == null || !characterData.isValid() || !this.canWriteSamplePicture) {
            tk.beep();
            return;
        }
        try {
            BufferedImage img = ClipboardUtil.getImage();
            if (img != null) {
                CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
                persist.saveSamplePicture(characterData, img);
                this.sampleImgPanel.setSamplePicture(img);
            } else {
                tk.beep();
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onDrop(Collection<File> dropFiles) {
        CharacterData characterData = null;
        int selRow = this.characterList.getSelectedRow();
        if (selRow >= 0) {
            characterData = this.characterListModel.getRow(selRow);
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (dropFiles == null || dropFiles.isEmpty() || !this.canWriteSamplePicture || characterData == null || !characterData.isValid() || !this.canWriteSamplePicture) {
            tk.beep();
            return;
        }
        try {
            File dropFile = dropFiles.iterator().next();
            BufferedImage img = null;
            if (dropFile != null && dropFile.isFile() && dropFile.canRead()) {
                try {
                    LoadedImage loadedImage = this.imageLoader.load(new FileImageResource(dropFile));
                    img = loadedImage.getImage();
                }
                catch (IOException ex) {
                    img = null;
                }
            }
            if (img != null) {
                CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
                persist.saveSamplePicture(characterData, img);
                this.sampleImgPanel.setSamplePicture(img);
            } else {
                tk.beep();
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    @Override
    public void dispose() {
        this.imageLoader.close();
        super.dispose();
    }

    protected void onClosing() {
        this.dispose();
    }

    protected void onOK() {
        this.selectedCharacterData = null;
        int selRow = this.characterList.getSelectedRow();
        if (selRow >= 0) {
            this.selectedCharacterData = this.characterListModel.getRow(selRow);
        }
        if (this.selectedCharacterData == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        this.dispose();
    }

    protected void onCancel() {
        this.selectedCharacterData = null;
        this.onClosing();
    }

    protected void onProfileNew(boolean makeDefault) {
        CharacterData cd = null;
        Map<CustomLayerOrderKey, List<CustomLayerOrder>> customLayerOrderMap = null;
        int selRow = this.characterList.getSelectedRow();
        if (selRow >= 0 && (cd = this.characterListModel.getRow(selRow)).isValid()) {
            try {
                customLayerOrderMap = CustomLayerOrderPersist.newInstance(cd).load();
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "failed to read the custom layer mapping", ex);
            }
        }
        CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
        if (makeDefault || cd == null) {
            try {
                Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
                JComboBox<Map.Entry<String, String>> comboTemplates = new JComboBox<Map.Entry<String, String>>();
                comboTemplates.setEditable(false);
                comboTemplates.setRenderer(new ListCellRenderer(){
                    private JLabel label = new JLabel();

                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        this.label.setOpaque(isSelected && index >= 0);
                        if (isSelected) {
                            this.label.setBackground(list.getSelectionBackground());
                            this.label.setForeground(list.getSelectionForeground());
                        } else {
                            this.label.setBackground(list.getBackground());
                            this.label.setForeground(list.getForeground());
                        }
                        if (value == null) {
                            this.label.setText("");
                        } else {
                            Map.Entry entry = (Map.Entry)value;
                            this.label.setFont(list.getFont());
                            this.label.setText((String)entry.getValue());
                        }
                        return this.label;
                    }
                });
                CharacterDataDefaultProvider defProv = new CharacterDataDefaultProvider();
                for (Map.Entry<String, String> entry : defProv.getCharacterDataTemplates().entrySet()) {
                    comboTemplates.addItem(entry);
                }
                comboTemplates.addItem(new AbstractMap.SimpleEntry<String, String>("", strings.getProperty("template.blank")));
                Dimension preferredSize = comboTemplates.getPreferredSize();
                int comboWidth = Integer.parseInt(strings.getProperty("profileNew.chooseTemplate.combo.width"));
                preferredSize.width = Math.max(preferredSize.width, comboWidth);
                comboTemplates.setPreferredSize(preferredSize);
                int ret = JOptionPane.showConfirmDialog(this, comboTemplates, strings.getProperty("profileNew.chooseTemplate.title"), 2);
                if (ret != 0) {
                    return;
                }
                Map.Entry selection = (Map.Entry)comboTemplates.getSelectedItem();
                if (selection == null) {
                    return;
                }
                String characterXmlName = (String)selection.getKey();
                if (characterXmlName != null && characterXmlName.length() > 0) {
                    cd = defProv.loadPredefinedCharacterData(characterXmlName);
                    customLayerOrderMap = defProv.loadPredefinedCustomLayerOrder(cd, characterXmlName);
                } else {
                    cd = new CharacterData();
                    cd.setRecommendationURLList(new ArrayList<RecommendationURL>());
                    customLayerOrderMap = null;
                }
            }
            catch (Exception ex) {
                ErrorMessageHelper.showErrorDialog(this, ex);
                return;
            }
        }
        CharacterData newCd = cd.duplicateBasicInfo();
        newCd.setDocBase(null);
        newCd.clearPartsSets(false);
        ProfileEditDialog editDlg = new ProfileEditDialog(this, newCd);
        editDlg.setVisible(true);
        newCd = editDlg.getResult();
        if (newCd == null) {
            return;
        }
        try {
            persist.createProfile(newCd, customLayerOrderMap);
            persist.saveFavorites(newCd);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
            return;
        }
        this.characterListModel.add(newCd);
    }

    protected void onProfileEdit() {
        CharacterData cd = null;
        int selRow = this.characterList.getSelectedRow();
        if (selRow >= 0) {
            cd = this.characterListModel.getRow(selRow);
        }
        if (cd == null || !cd.isValid()) {
            return;
        }
        try {
            CharacterData newCd = ProfileListManager.editProfile(this, cd);
            if (newCd == null) {
                return;
            }
            CharacterDataChangeObserver.getDefault().notifyCharacterDataChange(this, newCd, true, true);
            this.characterListModel.set(selRow, newCd);
            this.characterList.repaint();
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
            return;
        }
    }

    protected void onProfileRemove() {
        CharacterData cd = null;
        int selRow = this.characterList.getSelectedRow();
        if (selRow >= 0) {
            cd = this.characterListModel.getRow(selRow);
        }
        if (cd == null || !cd.isValid() || ProfileListManager.isUsingCharacterData(cd) || !cd.canWrite()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        String msgTempl = strings.getProperty("profile.remove.confirm");
        MessageFormat fmt = new MessageFormat(msgTempl);
        String msg = fmt.format(new Object[]{cd.getName()});
        JPanel msgPanel = new JPanel(new BorderLayout(5, 5));
        msgPanel.add((Component)new JLabel(msg), "Center");
        JCheckBox chkRemoveForce = new JCheckBox(strings.getProperty("profile.remove.force"));
        msgPanel.add((Component)chkRemoveForce, "South");
        JOptionPane optionPane = new JOptionPane(msgPanel, 3, 0){
            private static final long serialVersionUID = 1L;

            @Override
            public void selectInitialValue() {
                String noBtnCaption = UIManager.getString("OptionPane.noButtonText");
                for (JButton btn : UIHelper.getInstance().getDescendantOfClass(JButton.class, this)) {
                    if (!btn.getText().equals(noBtnCaption)) continue;
                    btn.requestFocus();
                }
            }
        };
        JDialog dlg = optionPane.createDialog(this, strings.getProperty("confirm.remove"));
        dlg.setVisible(true);
        Object ret = optionPane.getValue();
        if (ret == null || ((Number)ret).intValue() != 0) {
            return;
        }
        if (!cd.canWrite() || cd.getDocBase() == null) {
            JOptionPane.showMessageDialog(this, strings.getProperty("profile.remove.cannot"));
            return;
        }
        boolean forceRemove = chkRemoveForce.isSelected();
        try {
            CharacterDataPersistent persiste = CharacterDataPersistent.getInstance();
            persiste.remove(cd, forceRemove);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
            return;
        }
        this.characterListModel.remove(selRow);
        this.characterList.repaint();
        this.updateUIState();
    }

    protected void onProfileBrowse() {
        CharacterData cd = null;
        int selRow = this.characterList.getSelectedRow();
        if (selRow >= 0) {
            cd = this.characterListModel.getRow(selRow);
        }
        if (cd == null || !cd.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        try {
            URI docBase = cd.getDocBase();
            if (!DesktopUtilities.browseBaseDir(docBase)) {
                JOptionPane.showMessageDialog(this, docBase);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onProfileImport() {
        try {
            CharacterData cd;
            CharacterData selCd = null;
            int selRow = this.characterList.getSelectedRow();
            if (selRow >= 0) {
                selCd = this.characterListModel.getRow(selRow);
            }
            if (selCd != null) {
                Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
                JPanel radioPanel = new JPanel(new BorderLayout());
                JRadioButton btnUpdate = new JRadioButton(strings.getProperty("importToUpdateProfile"));
                JRadioButton btnNew = new JRadioButton(strings.getProperty("importToCreateProfile"));
                ButtonGroup radios = new ButtonGroup();
                radios.add(btnUpdate);
                radios.add(btnNew);
                btnUpdate.setSelected(true);
                radioPanel.add((Component)btnUpdate, "North");
                radioPanel.add((Component)btnNew, "South");
                int ret = JOptionPane.showConfirmDialog(this, radioPanel, strings.getProperty("confirmUpdateProfile"), 2);
                if (ret != 0) {
                    return;
                }
                if (btnNew.isSelected()) {
                    selCd = null;
                }
            }
            if (selCd != null) {
                cd = selCd.duplicateBasicInfo();
                try {
                    ProfileListManager.loadCharacterData(cd);
                    ProfileListManager.loadFavorites(cd);
                }
                catch (IOException ex) {
                    ErrorMessageHelper.showErrorDialog(this, ex);
                }
            } else {
                cd = null;
            }
            PartsImageDirectoryWatchAgentFactory agentFactory = PartsImageDirectoryWatchAgentFactory.getFactory();
            PartsImageDirectoryWatchAgent agent = agentFactory.getAgent(cd);
            agent.suspend();
            try {
                ImportWizardDialog importWizDialog = new ImportWizardDialog(this, cd);
                importWizDialog.setVisible(true);
                CharacterData newCd = importWizDialog.getImportedCharacterData();
                if (importWizDialog.getExitCode() == 2) {
                    this.characterListModel.add(newCd);
                } else if (importWizDialog.getExitCode() == 1) {
                    CharacterDataChangeObserver.getDefault().notifyCharacterDataChange(this, newCd, true, true);
                }
            }
            finally {
                agent.resume();
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onProfileExport() {
        CharacterData cd = null;
        int selRow = this.characterList.getSelectedRow();
        if (selRow >= 0) {
            cd = this.characterListModel.getRow(selRow);
        }
        if (cd == null || !cd.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        try {
            CharacterData newCd = cd.duplicateBasicInfo();
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                ProfileListManager.loadCharacterData(newCd);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            BufferedImage sampleImage = this.sampleImgPanel.getSamplePictrue();
            ExportWizardDialog exportWizDialog = new ExportWizardDialog(this, newCd, sampleImage);
            exportWizDialog.setVisible(true);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
            return;
        }
    }

    protected void onProfileTemplate() {
        try {
            CharacterData cd = null;
            int selRow = this.characterList.getSelectedRow();
            if (selRow >= 0) {
                cd = this.characterListModel.getRow(selRow);
            }
            if (cd == null || !cd.isValid()) {
                Toolkit tk = Toolkit.getDefaultToolkit();
                tk.beep();
                return;
            }
            String defualtName = cd.getId() + "_" + cd.getRev() + ".xml";
            for (char c : "<>|:;*?/\\\"".toCharArray()) {
                defualtName = defualtName.replace(c, '_');
            }
            CustomLayerOrderPersist customLayerPersist = CustomLayerOrderPersist.newInstance(cd);
            Map<CustomLayerOrderKey, List<CustomLayerOrder>> customLayerPatterns = customLayerPersist.load();
            final CharacterDataDefaultProvider defProv = new CharacterDataDefaultProvider();
            File templDir = defProv.getUserTemplateDir();
            templDir.mkdirs();
            JFileChooser fileChooser = new JFileChooser(new SingleRootFileSystemView(templDir)){
                private static final long serialVersionUID = 1L;

                @Override
                public void approveSelection() {
                    Properties strings;
                    File outFile = this.getSelectedFile();
                    if (outFile == null) {
                        return;
                    }
                    String name = outFile.getName();
                    if (!defProv.canFileSave(name) || !name.endsWith(".xml")) {
                        Toolkit tk = Toolkit.getDefaultToolkit();
                        tk.beep();
                        return;
                    }
                    if (outFile.exists() && JOptionPane.showConfirmDialog(this, (strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(ProfileSelectorDialog.STRINGS_RESOURCE)).getProperty("confirmOverwrite"), strings.getProperty("confirm"), 0, 2) != 0) {
                        return;
                    }
                    super.approveSelection();
                }
            };
            fileChooser.setSelectedFile(new File(templDir, defualtName));
            int ret = fileChooser.showSaveDialog(this);
            if (ret != 0) {
                return;
            }
            String localizedName = cd.getName();
            Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
            localizedName = JOptionPane.showInputDialog(this, strings.getProperty("inputTemplateName"), localizedName);
            if (localizedName == null) {
                return;
            }
            File outFile = fileChooser.getSelectedFile();
            defProv.saveTemplate(outFile.getName(), cd, localizedName, customLayerPatterns);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
            return;
        }
    }
}

