/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.graphics.filters.BackgroundColorFilter;
import charactermanaj.model.AppConfig;
import charactermanaj.ui.CheckInfoLayerPanel;
import charactermanaj.ui.PreviewControlPanel;
import charactermanaj.ui.PreviewImagePanel;
import charactermanaj.ui.Wallpaper;
import charactermanaj.ui.util.ScaleSupport;
import charactermanaj.ui.util.ScrollPaneDragScrollSupport;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import charactermanaj.util.UIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class PreviewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final String STRINGS_RESOURCE = "languages/previewpanel";
    private final String indicatorText;
    private final Timer timer;
    private long indicatorDelay;
    private final Object lock = new Object();
    private long loadingTicket;
    private long loadedTicket;
    private long firstWaitingTimestamp;
    private boolean indicatorShown;
    private String title;
    private JLabel lblTitle;
    private JLayeredPane layeredPane;
    private CheckInfoLayerPanel checkInfoLayerPanel;
    private PreviewImagePanel previewImgPanel;
    private JScrollPane previewImgScrollPane;
    private ScrollPaneDragScrollSupport scrollSupport;
    private PreviewControlPanel previewControlPanel;
    private double latestToggleZoom = 2.0;
    private LinkedList<PreviewPanelListener> listeners = new LinkedList();
    private Semaphore zoomLock = new Semaphore(1);
    private Point requestViewPt;

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    @Override
    public void removeNotify() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        super.removeNotify();
    }

    public PreviewPanel(ScaleSupport scaleSupport) {
        this.setLayout(new BorderLayout());
        final AppConfig appConfig = AppConfig.getInstance();
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.timer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.onTimer();
            }
        });
        this.indicatorText = strings.getProperty("indicatorText");
        this.indicatorDelay = appConfig.getPreviewIndicatorDelay();
        UIHelper uiUtl = UIHelper.getInstance();
        JButton saveBtn = uiUtl.createIconButton("icons/save.png");
        JButton copyBtn = uiUtl.createIconButton("icons/copy.png");
        JButton colorBtn = uiUtl.createIconButton("icons/color.png");
        JButton informationBtn = uiUtl.createIconButton("icons/information.png");
        JButton favoriteBtn = uiUtl.createIconButton("icons/favorite.png");
        JButton flipHolizontalBtn = uiUtl.createIconButton("icons/flip.png");
        saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.savePicture(new PreviewPanelEvent((Object)PreviewPanel.this, e));
            }
        });
        copyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.copyPicture(new PreviewPanelEvent((Object)PreviewPanel.this, e));
            }
        });
        colorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.changeBackgroundColor(new PreviewPanelEvent((Object)PreviewPanel.this, e));
            }
        });
        informationBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.showInformation(new PreviewPanelEvent((Object)PreviewPanel.this, e));
            }
        });
        favoriteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.addFavorite(new PreviewPanelEvent((Object)PreviewPanel.this, e));
            }
        });
        flipHolizontalBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.flipHolizontal(new PreviewPanelEvent((Object)PreviewPanel.this, e));
            }
        });
        saveBtn.setToolTipText(strings.getProperty("tooltip.save"));
        copyBtn.setToolTipText(strings.getProperty("tooltip.copy"));
        colorBtn.setToolTipText(strings.getProperty("tooltip.changeBgColor"));
        informationBtn.setToolTipText(strings.getProperty("tooltip.showInformation"));
        favoriteBtn.setToolTipText(strings.getProperty("tooltip.registerFavorites"));
        flipHolizontalBtn.setToolTipText(strings.getProperty("tooltip.flipHorizontal"));
        final JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(flipHolizontalBtn);
        toolBar.add(copyBtn);
        toolBar.add(saveBtn);
        toolBar.add(Box.createHorizontalStrut(8));
        toolBar.add(colorBtn);
        toolBar.add(Box.createHorizontalStrut(4));
        toolBar.add(favoriteBtn);
        toolBar.add(informationBtn);
        this.lblTitle = new JLabel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                int maxWidth = this.getParent().getWidth() - toolBar.getWidth();
                if (dim.width > maxWidth) {
                    dim.width = maxWidth;
                }
                return dim;
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = this.getPreferredSize();
                dim.width = 50;
                return dim;
            }
        };
        this.lblTitle.setBorder(BorderFactory.createEmptyBorder(3, 10, 3, 3));
        JPanel previewPaneHeader = new JPanel();
        previewPaneHeader.setLayout(new BorderLayout());
        previewPaneHeader.add((Component)this.lblTitle, "West");
        previewPaneHeader.add((Component)toolBar, "East");
        this.previewImgPanel = new PreviewImagePanel();
        this.previewImgScrollPane = new JScrollPane(this.previewImgPanel);
        this.previewImgScrollPane.setAutoscrolls(false);
        this.previewImgScrollPane.setWheelScrollingEnabled(false);
        this.previewImgScrollPane.setVerticalScrollBarPolicy(22);
        this.previewImgScrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollSupport = new ScrollPaneDragScrollSupport(this.previewImgScrollPane){

            @Override
            protected void setCursor(Cursor cursor) {
                PreviewPanel.this.setCursor(cursor);
            }
        };
        this.add((Component)previewPaneHeader, "North");
        this.layeredPane = new JLayeredPane();
        this.layeredPane.setLayout(new OverlayLayout(this.layeredPane));
        this.layeredPane.add((Component)this.previewImgScrollPane, JLayeredPane.DEFAULT_LAYER);
        this.checkInfoLayerPanel = new CheckInfoLayerPanel();
        this.layeredPane.add((Component)this.checkInfoLayerPanel, JLayeredPane.POPUP_LAYER);
        this.checkInfoLayerPanel.setVisible(false);
        this.add((Component)this.layeredPane, "Center");
        this.previewControlPanel = new PreviewControlPanel();
        Dimension dim = this.previewControlPanel.getPreferredSize();
        Dimension prevDim = this.previewImgScrollPane.getPreferredSize();
        dim.width = prevDim.width;
        this.previewControlPanel.setPreferredSize(dim);
        this.add((Component)this.previewControlPanel, "South");
        this.previewControlPanel.setPinned(appConfig.isEnableZoomPanel());
        this.previewControlPanel.addPropertyChangeListener("zoomFactorInt", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Integer newValue = (Integer)evt.getNewValue();
                PreviewPanel.this.zoomWithCenterPosition(newValue.doubleValue() / 100.0, null);
            }
        });
        this.previewControlPanel.addPropertyChangeListener("backgroundColorMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BackgroundColorFilter.BackgroundColorMode bgColorMode = (BackgroundColorFilter.BackgroundColorMode)((Object)evt.getNewValue());
                PreviewPanel.this.previewImgPanel.setBackgroundColorMode(bgColorMode);
                if (bgColorMode != BackgroundColorFilter.BackgroundColorMode.ALPHABREND && appConfig.isEnableCheckInfoTooltip()) {
                    PreviewPanel.this.checkInfoLayerPanel.setMessage(null);
                    PreviewPanel.this.checkInfoLayerPanel.setVisible(true);
                } else {
                    PreviewPanel.this.checkInfoLayerPanel.setVisible(false);
                }
            }
        });
        this.previewImgScrollPane.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Rectangle rct = PreviewPanel.this.previewImgScrollPane.getBounds();
                int y = e.getY();
                UIHelper uiUtl = UIHelper.getInstance();
                if (y > rct.height - (int)((double)appConfig.getZoomPanelActivationArea() * uiUtl.getScaleY())) {
                    PreviewPanel.this.previewControlPanel.setVisible(true);
                } else if (!PreviewPanel.this.previewControlPanel.isPinned()) {
                    PreviewPanel.this.previewControlPanel.setVisible(false);
                }
            }
        });
        for (MouseWheelListener listener : this.previewImgScrollPane.getMouseWheelListeners()) {
            this.previewImgScrollPane.removeMouseWheelListener(listener);
        }
        this.previewImgScrollPane.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (Main.isMacOSX() && e.isAltDown() || !Main.isMacOSX() && e.isControlDown()) {
                    PreviewPanel.this.zoomByWheel(e);
                } else {
                    PreviewPanel.this.scrollByWheel(e);
                }
                PreviewPanel.this.updateCheckInfoMessage(e.getPoint());
            }
        });
        this.previewImgScrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PreviewPanel.this.toggleZoom(e.getPoint());
                } else {
                    PreviewPanel.this.scrollSupport.drag(true, e.getPoint());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PreviewPanel.this.scrollSupport.drag(false, e.getPoint());
            }
        });
        this.previewImgScrollPane.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                PreviewPanel.this.updateCheckInfoMessage(e.getPoint());
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                PreviewPanel.this.scrollSupport.dragging(e.getPoint());
                PreviewPanel.this.updateCheckInfoMessage(e.getPoint());
            }
        });
    }

    protected void toggleZoom(Point mousePos) {
        if (this.previewImgPanel.isDefaultZoom()) {
            this.zoomWithCenterPosition(this.latestToggleZoom, mousePos);
        } else {
            double currentZoomFactor;
            this.latestToggleZoom = currentZoomFactor = this.previewImgPanel.getZoomFactor();
            this.zoomWithCenterPosition(1.0, mousePos);
        }
    }

    protected void updateCheckInfoMessage(Point mousePosition) {
        if (!this.checkInfoLayerPanel.isVisible()) {
            return;
        }
        Point imgPos = null;
        if (mousePosition != null) {
            Point panelPt = SwingUtilities.convertPoint(this.previewImgScrollPane, mousePosition, this.previewImgPanel);
            imgPos = this.previewImgPanel.getImagePosition(panelPt);
        }
        if (imgPos != null) {
            int argb = this.previewImgPanel.getImageARGB(imgPos);
            int a = argb >> 24 & 0xFF;
            int r = argb >> 16 & 0xFF;
            int g = argb >> 8 & 0xFF;
            int b = argb & 0xFF;
            int y = (int)(0.298912f * (float)r + 0.586611f * (float)g + 0.114478f * (float)b);
            String text = String.format("(%3d,%3d)\u00a5nA:%3d, Y:%3d\u00a5nR:%3d, G:%3d, B:%3d", imgPos.x, imgPos.y, a, y, r, g, b);
            this.checkInfoLayerPanel.setMessage(text);
            this.checkInfoLayerPanel.setPotision(mousePosition);
        } else {
            this.checkInfoLayerPanel.setMessage(null);
        }
    }

    protected void scroll(int diff_x, int diff_y) {
        this.scrollSupport.scroll(diff_x, diff_y);
    }

    protected void scrollByWheel(MouseWheelEvent e) {
        this.scrollSupport.scrollByWheel(e);
        e.consume();
    }

    protected void zoomByWheel(MouseWheelEvent e) {
        double zoomFactor;
        int wheelRotation = e.getWheelRotation();
        double currentZoom = this.previewImgPanel.getZoomFactor();
        if (wheelRotation < 0) {
            zoomFactor = currentZoom * 1.1;
        } else if (wheelRotation > 0) {
            zoomFactor = currentZoom * 0.9;
        } else {
            return;
        }
        this.zoomWithCenterPosition(zoomFactor, e.getPoint());
        e.consume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zoomWithCenterPosition(double zoomFactor, Point mousePos) {
        if (!this.zoomLock.tryAcquire()) {
            return;
        }
        try {
            Point viewCenter;
            if (zoomFactor < 0.2) {
                zoomFactor = 0.2;
            } else if (zoomFactor > 8.0) {
                zoomFactor = 8.0;
            }
            JViewport vp = this.previewImgScrollPane.getViewport();
            if (mousePos != null) {
                viewCenter = SwingUtilities.convertPoint(this, mousePos, this.previewImgPanel);
            } else {
                Rectangle viewRect = vp.getViewRect();
                viewCenter = new Point(viewRect.x + viewRect.width / 2, viewRect.y + viewRect.height / 2);
            }
            Dimension viewSize = this.previewImgPanel.getScaledSize(true);
            this.previewControlPanel.setZoomFactor(zoomFactor);
            this.previewImgPanel.setZoomFactor(zoomFactor);
            Dimension viewSizeAfter = this.previewImgPanel.getScaledSize(true);
            Dimension visibleSize = vp.getExtentSize();
            if (viewSize != null && viewSizeAfter != null && viewSizeAfter.width > 0 && viewSizeAfter.height > 0 && viewSizeAfter.width > visibleSize.width && viewSizeAfter.height > visibleSize.height) {
                vp.setViewSize(viewSizeAfter);
                int visible_width = Math.max(visibleSize.width, viewSize.width);
                int visible_height = Math.max(visibleSize.height, viewSize.height);
                int visible_width_after = Math.max(visibleSize.width, viewSizeAfter.width);
                int visible_height_after = Math.max(visibleSize.height, viewSizeAfter.height);
                double zoomDiffX = (double)visible_width_after / (double)visible_width;
                double zoomDiffY = (double)visible_height_after / (double)visible_height;
                Point viewCenterAfter = new Point();
                viewCenterAfter.x = (int)Math.round((double)viewCenter.x * zoomDiffX);
                viewCenterAfter.y = (int)Math.round((double)viewCenter.y * zoomDiffY);
                int diff_x = viewCenterAfter.x - viewCenter.x;
                int diff_y = viewCenterAfter.y - viewCenter.y;
                this.scroll(diff_x, diff_y);
            }
            JScrollBar vsb = this.previewImgScrollPane.getVerticalScrollBar();
            JScrollBar hsb = this.previewImgScrollPane.getHorizontalScrollBar();
            vsb.setUnitIncrement(Math.max(1, (int)Math.ceil(zoomFactor)));
            hsb.setUnitIncrement(Math.max(1, (int)Math.ceil(zoomFactor)));
        }
        finally {
            this.zoomLock.release();
        }
    }

    public Point getViewPosition() {
        JViewport vp = this.previewImgScrollPane.getViewport();
        return vp.getViewPosition();
    }

    public void setViewPosition(Point viewPt) {
        JViewport vp = this.previewImgScrollPane.getViewport();
        if (this.previewImgPanel.getPreviewImage() != null) {
            if (viewPt != null) {
                vp.setViewPosition(viewPt);
            }
            this.requestViewPt = null;
        } else {
            this.requestViewPt = viewPt;
        }
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        if (!title.equals(this.title)) {
            this.title = title;
            this.lblTitle.setText(title + (this.indicatorShown ? this.indicatorText : ""));
            this.lblTitle.setToolTipText(title);
        }
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTimer() {
        boolean indicatorShown;
        long firstRequest;
        boolean waiting;
        Object object = this.lock;
        synchronized (object) {
            waiting = this.isWaiting();
            firstRequest = this.firstWaitingTimestamp;
        }
        boolean bl = indicatorShown = waiting && System.currentTimeMillis() - firstRequest > this.indicatorDelay;
        if (this.indicatorShown != indicatorShown) {
            this.indicatorShown = indicatorShown;
            this.lblTitle.setText(this.title + (indicatorShown ? this.indicatorText : ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isWaiting() {
        Object object = this.lock;
        synchronized (object) {
            return this.loadingTicket > this.loadedTicket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoadingRequest(long ticket) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isWaiting() && this.loadedTicket < ticket) {
                this.firstWaitingTimestamp = System.currentTimeMillis();
            }
            this.loadingTicket = ticket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoadingComplete(long ticket) {
        Object object = this.lock;
        synchronized (object) {
            this.loadedTicket = ticket;
        }
    }

    public void setPreviewImage(BufferedImage previewImg) {
        this.previewImgPanel.setPreviewImage(previewImg);
        if (this.requestViewPt != null) {
            this.setViewPosition(this.requestViewPt);
        }
    }

    public BufferedImage getPreviewImage() {
        return this.previewImgPanel.getPreviewImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getScreenImage() {
        JViewport vp = this.previewImgScrollPane.getViewport();
        Dimension dim = vp.getExtentSize();
        BufferedImage img = new BufferedImage(dim.width, dim.height, 2);
        Graphics2D g = img.createGraphics();
        try {
            vp.paint(g);
        }
        finally {
            g.dispose();
        }
        return img;
    }

    public void setWallpaper(Wallpaper wallpaper) {
        this.previewImgPanel.setWallpaper(wallpaper);
    }

    public Wallpaper getWallpaper() {
        return this.previewImgPanel.getWallpaper();
    }

    public double getZoomFactor() {
        return this.previewControlPanel.getZoomFactor();
    }

    public void setZoomFactor(double zoomFactor) {
        this.previewControlPanel.setZoomFactor(zoomFactor);
    }

    public void setVisibleZoomBox(boolean visible) {
        this.previewControlPanel.setPinned(visible);
    }

    public boolean isVisibleZoomBox() {
        return this.previewControlPanel.isPinned();
    }

    public void addPreviewPanelListener(PreviewPanelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(listener);
    }

    public void removePreviewPanelListener(PreviewPanelListener listener) {
        this.listeners.remove(listener);
    }

    protected void savePicture(PreviewPanelEvent e) {
        for (PreviewPanelListener listener : this.listeners) {
            listener.savePicture(e);
        }
    }

    protected void flipHolizontal(PreviewPanelEvent e) {
        for (PreviewPanelListener listener : this.listeners) {
            listener.flipHorizontal(e);
        }
    }

    protected void copyPicture(PreviewPanelEvent e) {
        for (PreviewPanelListener listener : this.listeners) {
            listener.copyPicture(e);
        }
    }

    protected void changeBackgroundColor(PreviewPanelEvent e) {
        for (PreviewPanelListener listener : this.listeners) {
            listener.changeBackgroundColor(e);
        }
    }

    protected void showInformation(PreviewPanelEvent e) {
        for (PreviewPanelListener listener : this.listeners) {
            listener.showInformation(e);
        }
    }

    protected void addFavorite(PreviewPanelEvent e) {
        for (PreviewPanelListener listener : this.listeners) {
            listener.addFavorite(e);
        }
    }

    public static class PreviewPanelEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;
        private int modifiers;

        public PreviewPanelEvent(Object src, ActionEvent e) {
            this(src, e == null ? 0 : e.getModifiers());
        }

        public PreviewPanelEvent(Object src, int modifiers) {
            super(src);
            this.modifiers = modifiers;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public boolean isShiftKeyPressed() {
            return (this.modifiers & 1) != 0;
        }
    }

    public static interface PreviewPanelListener {
        public void savePicture(PreviewPanelEvent var1);

        public void copyPicture(PreviewPanelEvent var1);

        public void changeBackgroundColor(PreviewPanelEvent var1);

        public void showInformation(PreviewPanelEvent var1);

        public void addFavorite(PreviewPanelEvent var1);

        public void flipHorizontal(PreviewPanelEvent var1);
    }
}

