/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.graphics.filters.BackgroundColorFilter;
import charactermanaj.model.AppConfig;
import charactermanaj.ui.Wallpaper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;

class PreviewImagePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BackgroundColorFilter.BackgroundColorMode bgColorMode = BackgroundColorFilter.BackgroundColorMode.ALPHABREND;
    private Wallpaper wallpaper;
    private PropertyChangeListener wallpaperListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PreviewImagePanel.this.onChangeWallpaper();
        }
    };
    private BufferedImage previewImg;
    private BufferedImage previewImgForDraw;
    private Double scaledZoomFactor;
    private double zoomFactor = 1.0;
    private static final double TOLERANT = 0.001;

    public PreviewImagePanel() {
        this.wallpaper = new Wallpaper();
        this.wallpaper.addPropertyChangeListener(this.wallpaperListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g0) {
        Graphics2D g = (Graphics2D)g0;
        super.paintComponent(g);
        if (this.previewImgForDraw == null) {
            return;
        }
        Rectangle imgRct = this.adjustImageRectangle();
        if (this.scaledZoomFactor == null) {
            Object renderingOption = this.getRenderingOption();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, renderingOption);
        }
        if (this.bgColorMode == BackgroundColorFilter.BackgroundColorMode.ALPHABREND) {
            int w = this.getWidth();
            int h = this.getHeight();
            this.wallpaper.drawWallpaper(g, w, h);
        }
        g.drawImage(this.previewImgForDraw, imgRct.x, imgRct.y, imgRct.x + imgRct.width, imgRct.y + imgRct.height, 0, 0, this.previewImgForDraw.getWidth(), this.previewImgForDraw.getHeight(), null);
        AppConfig appConfig = AppConfig.getInstance();
        int drawGridMask = appConfig.getDrawGridMask();
        if ((drawGridMask & this.bgColorMode.mask()) != 0) {
            Color oldc = g.getColor();
            try {
                g.setColor(appConfig.getPreviewGridColor());
                this.drawGrid(g, imgRct.x, imgRct.y, appConfig.getPreviewGridSize());
            }
            finally {
                g.setColor(oldc);
            }
        }
    }

    protected void drawGrid(Graphics2D g, int offset_x, int offset_y, int unit) {
        Rectangle clip = g.getClipBounds();
        int src_w = this.previewImg.getWidth();
        int src_h = this.previewImg.getHeight();
        int my = src_h / unit;
        int mx = src_w / unit;
        int st_x = offset_x + (int)((double)(-1 * unit) * this.zoomFactor);
        int en_x = offset_x + (int)((double)((mx + 1) * unit) * this.zoomFactor);
        int w = en_x - st_x + 1;
        for (int y = -1; y <= my + 1; ++y) {
            int y1 = y * unit;
            Rectangle rct = new Rectangle(st_x, offset_y + (int)((double)y1 * this.zoomFactor), w, 1);
            if (clip != null && !clip.intersects(rct)) continue;
            g.drawLine(rct.x, rct.y, rct.x + rct.width, rct.y);
        }
        int st_y = offset_y + (int)((double)(-1 * unit) * this.zoomFactor);
        int en_y = offset_y + (int)((double)((my + 1) * unit) * this.zoomFactor);
        int h = en_y - st_y + 1;
        for (int x = -1; x <= mx + 1; ++x) {
            int x1 = x * unit;
            Rectangle rct = new Rectangle(offset_x + (int)((double)x1 * this.zoomFactor), st_y, 1, h);
            g.drawLine(rct.x, rct.y, rct.x, rct.y + rct.height);
        }
    }

    protected Object getRenderingOption() {
        AppConfig appConfig = AppConfig.getInstance();
        double rendringOptimizeThreshold = this.bgColorMode == BackgroundColorFilter.BackgroundColorMode.ALPHABREND ? appConfig.getRenderingOptimizeThresholdForNormal() : appConfig.getRenderingOptimizeThresholdForCheck();
        Object renderingHint = this.zoomFactor < rendringOptimizeThreshold ? (this.zoomFactor <= 1.0 || !appConfig.isEnableInterpolationBicubic() ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_BICUBIC) : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        return renderingHint;
    }

    public Rectangle adjustImageRectangle() {
        if (this.previewImg == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        int client_w = this.getWidth();
        int client_h = this.getHeight();
        int src_w = this.previewImg.getWidth();
        int src_h = this.previewImg.getHeight();
        int w = (int)Math.round((double)src_w * this.zoomFactor);
        int h = (int)Math.round((double)src_h * this.zoomFactor);
        int offset_x = 0;
        if (w < client_w) {
            offset_x = (client_w - w) / 2;
        }
        int offset_y = 0;
        if (h < client_h) {
            offset_y = (client_h - h) / 2;
        }
        return new Rectangle(offset_x, offset_y, w, h);
    }

    public Point getImagePosition(Point pt) {
        if (pt == null || this.previewImg == null) {
            return null;
        }
        Rectangle imgRct = this.adjustImageRectangle();
        if (!imgRct.contains(pt.x, pt.y)) {
            return null;
        }
        Point ret = (Point)pt.clone();
        ret.x -= imgRct.x;
        ret.y -= imgRct.y;
        ret.x = (int)Math.floor((double)ret.x / this.zoomFactor);
        ret.y = (int)Math.floor((double)ret.y / this.zoomFactor);
        return ret;
    }

    public Point getMousePosition(Point pt) {
        if (pt == null || this.previewImg == null) {
            return null;
        }
        Rectangle imgRct = this.adjustImageRectangle();
        Point ret = (Point)pt.clone();
        ret.x = (int)Math.ceil((double)ret.x * this.zoomFactor);
        ret.y = (int)Math.ceil((double)ret.y * this.zoomFactor);
        ret.x += imgRct.x;
        ret.y += imgRct.y;
        return ret;
    }

    public int getImageARGB(Point pt) {
        if (pt == null) {
            throw new IllegalArgumentException();
        }
        try {
            return this.previewImg.getRGB(pt.x, pt.y);
        }
        catch (RuntimeException ex) {
            return 0;
        }
    }

    protected void recalcScaledSize() {
        Dimension scaledSize = this.getScaledSize(true);
        if (scaledSize != null) {
            this.setPreferredSize(scaledSize);
            this.revalidate();
        }
    }

    protected Dimension getScaledSize(boolean needOffset) {
        if (this.previewImg == null) {
            return null;
        }
        int src_w = this.previewImg.getWidth();
        int src_h = this.previewImg.getHeight();
        int w = (int)Math.round((double)src_w * this.zoomFactor);
        int h = (int)Math.round((double)src_h * this.zoomFactor);
        Dimension scaledSize = new Dimension(w, h);
        if (this.bgColorMode != BackgroundColorFilter.BackgroundColorMode.ALPHABREND) {
            AppConfig appConfig = AppConfig.getInstance();
            int unfilledSpace = appConfig.getPreviewUnfilledSpaceForCheckMode();
            scaledSize.width += Math.max(0, unfilledSpace * 2);
            scaledSize.height += Math.max(0, unfilledSpace * 2);
        }
        return scaledSize;
    }

    public void setPreviewImage(BufferedImage previewImg) {
        BufferedImage oldimg = this.previewImg;
        this.previewImg = previewImg;
        this.recalcScaledSize();
        this.makeDrawImage(true);
        this.repaint();
        this.firePropertyChange("previewImage", oldimg, previewImg);
    }

    public BufferedImage getPreviewImage() {
        return this.previewImg;
    }

    public void setWallpaper(Wallpaper wallpaper) {
        if (wallpaper == null) {
            throw new IllegalArgumentException();
        }
        if (!this.wallpaper.equals(wallpaper)) {
            Wallpaper wallpaperOld = this.wallpaper;
            if (wallpaperOld != null) {
                wallpaperOld.removePropertyChangeListener(this.wallpaperListener);
            }
            this.wallpaper = wallpaper;
            if (this.wallpaper != null) {
                this.wallpaper.addPropertyChangeListener(this.wallpaperListener);
            }
            this.firePropertyChange("wallpaper", wallpaperOld, this.wallpaper);
            this.onChangeWallpaper();
        }
    }

    public Wallpaper getWallpaper() {
        return this.wallpaper;
    }

    protected void onChangeWallpaper() {
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeDrawImage(boolean changeImage) {
        BufferedImage img;
        if (this.previewImg == null) {
            this.previewImgForDraw = null;
            this.scaledZoomFactor = null;
            return;
        }
        if (changeImage || this.scaledZoomFactor != null) {
            if (this.bgColorMode == BackgroundColorFilter.BackgroundColorMode.ALPHABREND) {
                img = this.previewImg;
            } else {
                Color bgColor = this.wallpaper.getBackgroundColor();
                BackgroundColorFilter bgColorFilter = new BackgroundColorFilter(this.bgColorMode, bgColor);
                img = bgColorFilter.filter(this.previewImg, null);
            }
        } else {
            img = this.previewImgForDraw;
        }
        Object renderingOption = this.getRenderingOption();
        if (!renderingOption.equals(RenderingHints.VALUE_INTERPOLATION_BICUBIC)) {
            this.previewImgForDraw = img;
            this.scaledZoomFactor = null;
            return;
        }
        Dimension scaledSize = this.getScaledSize(false);
        BufferedImage offscreen = new BufferedImage(scaledSize.width, scaledSize.height, 2);
        Graphics2D g = offscreen.createGraphics();
        try {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.drawImage(img, 0, 0, scaledSize.width, scaledSize.height, 0, 0, img.getWidth(), img.getHeight(), null);
        }
        finally {
            g.dispose();
        }
        this.previewImgForDraw = offscreen;
        this.scaledZoomFactor = this.zoomFactor;
    }

    public void setBackgroundColorMode(BackgroundColorFilter.BackgroundColorMode bgColorMode) {
        if (bgColorMode == null) {
            throw new IllegalArgumentException();
        }
        if (this.bgColorMode != bgColorMode) {
            BackgroundColorFilter.BackgroundColorMode oldcm = bgColorMode;
            this.bgColorMode = bgColorMode;
            this.makeDrawImage(true);
            this.recalcScaledSize();
            this.repaint();
            this.firePropertyChange("backgroundColorMode", (Object)oldcm, (Object)bgColorMode);
        }
    }

    public BackgroundColorFilter.BackgroundColorMode setBackgroundColorMode() {
        return this.bgColorMode;
    }

    public void setZoomFactor(double zoomFactor) {
        if (Math.abs(zoomFactor - this.zoomFactor) > 0.001) {
            double oldzoom = this.zoomFactor;
            this.zoomFactor = zoomFactor;
            this.recalcScaledSize();
            this.makeDrawImage(false);
            this.repaint();
            this.firePropertyChange("zoomFactor", oldzoom, zoomFactor);
        }
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public boolean isDefaultZoom() {
        return this.zoomFactor - 1.0 < 0.001;
    }
}

