/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

class ColorCell
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String title = "Color";
    private JPanel box;
    private JLabel label;
    private JButton button;
    private ActionListener actionListener;
    private Color bgColor = Color.WHITE;
    private Color selectedColor;

    public ColorCell() {
        this((ActionListener)null);
    }

    public ColorCell(ActionListener actionListener) {
        super(new BorderLayout());
        this.actionListener = actionListener;
        this.box = new JPanel(new BorderLayout());
        this.label = new JLabel();
        this.label.setHorizontalAlignment(0);
        this.box.add((Component)this.label, "Center");
        AbstractAction actColorChoose = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorCell.this.onClick(e);
            }
        };
        this.button = new JButton(actColorChoose);
        Dimension dim = this.button.getPreferredSize();
        dim.width = 24;
        this.button.setPreferredSize(dim);
        this.add((Component)this.box, "Center");
        this.add((Component)this.button, "East");
        this.setSelectedColor(Color.BLACK);
        this.box.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ColorCell.this.onClick(null);
                    e.consume();
                }
            }
        });
        InputMap im = this.getInputMap(0);
        im.put(KeyStroke.getKeyStroke(' '), "ON_CLICK_COLOR_CHOOSER");
        ActionMap am = this.getActionMap();
        am.put("ON_CLICK_COLOR_CHOOSER", actColorChoose);
        this.setMinimumSize(new Dimension(50, 30));
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String old = this.title;
        if (old == null ? title != null : !old.equals(title)) {
            this.title = title;
            this.firePropertyChange("title", old, title);
        }
    }

    public Border getBoxBorder() {
        return this.box.getBorder();
    }

    public void setBoxBorder(Border border) {
        this.box.setBorder(border);
    }

    public void onClick(ActionEvent e) {
        Color selColor = JColorChooser.showDialog(this, this.title, this.selectedColor);
        if (selColor != null) {
            this.setSelectedColor(selColor);
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(e);
            }
        }
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color color) {
        Color old = this.selectedColor;
        if (old == null ? color != null : !old.equals(color)) {
            Color premultipliedColor;
            this.selectedColor = color;
            boolean dummyColor = false;
            if (color == null) {
                color = Color.BLACK;
                dummyColor = true;
            }
            Color colorForeground = new Color(color.getRGB() ^ 0xFFFFFF).brighter();
            int alpha = color.getAlpha();
            if (alpha == 255) {
                premultipliedColor = color;
            } else {
                float[] rgb = color.getRGBColorComponents(null);
                float[] bgRgb = this.bgColor.getRGBColorComponents(null);
                float a = (float)alpha / 255.0f;
                rgb[0] = rgb[0] * a + bgRgb[0] * (1.0f - a);
                rgb[1] = rgb[1] * a + bgRgb[1] * (1.0f - a);
                rgb[2] = rgb[2] * a + bgRgb[2] * (1.0f - a);
                premultipliedColor = new Color(rgb[0], rgb[1], rgb[2]);
            }
            this.box.setBackground(premultipliedColor);
            this.label.setForeground(colorForeground);
            String msg = dummyColor ? "" : (alpha != 255 ? String.format("#%08X", (long)color.getRGB() & 0xFFFFFFFFL) : String.format("#%06X", (long)color.getRGB() & 0xFFFFFFL));
            this.label.setText(msg);
            this.firePropertyChange("selectedColor", old, color);
        }
    }
}

