/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.model.AppConfig;
import charactermanaj.ui.ColorCellEditor;
import charactermanaj.ui.ColorCellRender;
import charactermanaj.ui.RecentCharactersDir;
import charactermanaj.ui.util.ScaleSupport;
import charactermanaj.util.BeanPropertiesUtilities;
import charactermanaj.util.ConfigurationDirUtilities;
import charactermanaj.util.DesktopUtilities;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import charactermanaj.util.SetupLocalization;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class AppConfigDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(AppConfigDialog.class.getName());
    private AppConfigTableModel appConfigTableModel;
    private JTable appConfigTable;
    private JCheckBox chkResetDoNotAskAgain;
    private RecentCharactersDir recentCharactersDir;
    private AbstractAction actApply;
    private boolean orgDoNotAskAgain;

    public AppConfigDialog(JFrame parent) {
        super((Frame)parent, true);
        try {
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    AppConfigDialog.this.onClose();
                }
            });
            this.initComponent();
            this.loadData();
        }
        catch (RuntimeException ex) {
            logger.log(Level.SEVERE, "appConfig construct failed.", ex);
            this.dispose();
            throw ex;
        }
    }

    private void initComponent() {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/appconfigdialog");
        this.setTitle(strings.getProperty("title"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel btnPanel = new JPanel();
        btnPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 45));
        GridBagLayout btnPanelLayout = new GridBagLayout();
        btnPanel.setLayout(btnPanelLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        this.actApply = new AbstractAction(strings.getProperty("btn.apply")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AppConfigDialog.this.onUpdate();
            }
        };
        AbstractAction actCancel = new AbstractAction(strings.getProperty("btn.cancel")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AppConfigDialog.this.onClose();
            }
        };
        AbstractAction actLocalization = new AbstractAction(strings.getProperty("btn.setupLocalization")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AppConfigDialog.this.onSetupLocalization();
            }
        };
        AbstractAction actResetSettings = new AbstractAction(strings.getProperty("btn.resetSettingsToDefault")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AppConfigDialog.this.onResetSettings();
            }
        };
        Box pnlButtons = Box.createHorizontalBox();
        pnlButtons.add(new JButton(actLocalization));
        pnlButtons.add(new JButton(actResetSettings));
        this.chkResetDoNotAskAgain = new JCheckBox(strings.getProperty("chk.askForCharactersDir"));
        this.chkResetDoNotAskAgain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppConfigDialog.this.updateUIState();
            }
        });
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        btnPanel.add((Component)this.chkResetDoNotAskAgain, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        btnPanel.add((Component)pnlButtons, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        btnPanel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridx = Main.isLinuxOrMacOSX() ? 2 : 1;
        gbc.weightx = 0.0;
        JButton btnApply = new JButton(this.actApply);
        btnPanel.add((Component)btnApply, gbc);
        gbc.gridx = Main.isLinuxOrMacOSX() ? 1 : 2;
        gbc.weightx = 0.0;
        JButton btnCancel = new JButton(actCancel);
        btnPanel.add((Component)btnCancel, gbc);
        this.add((Component)btnPanel, "South");
        Dimension dim = new Dimension(600, 400);
        ScaleSupport scaleSupport = ScaleSupport.getInstance(this);
        if (scaleSupport != null) {
            dim = scaleSupport.manualScaled(dim);
        }
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
        JLabel lblCaution = new JLabel(strings.getProperty("caution"), 0);
        lblCaution.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        lblCaution.setForeground(Color.red);
        contentPane.add((Component)lblCaution, "North");
        this.appConfigTableModel = new AppConfigTableModel();
        AppConfig appConfig = AppConfig.getInstance();
        final Color invalidBgColor = appConfig.getInvalidBgColor();
        this.appConfigTable = new JTable(this.appConfigTableModel){
            private static final long serialVersionUID = 1L;
            private Class<?> editingClass;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                AppConfigRow configRow = AppConfigDialog.this.appConfigTableModel.getItems().get(row);
                if (configRow.isRejected()) {
                    comp.setBackground(invalidBgColor);
                } else if (this.isCellSelected(row, column)) {
                    comp.setBackground(this.getSelectionBackground());
                } else {
                    comp.setBackground(this.getBackground());
                }
                if (configRow.isModified() && !configRow.isRejected()) {
                    comp.setForeground(invalidBgColor);
                } else {
                    comp.setForeground(this.getForeground());
                }
                return comp;
            }

            @Override
            public String getToolTipText(MouseEvent event) {
                int row = this.rowAtPoint(event.getPoint());
                int col = this.columnAtPoint(event.getPoint());
                if (AppConfigTableModel.COLUMNS[col] == ColumnDef.NAME) {
                    int modelRow = this.convertRowIndexToModel(row);
                    return AppConfigDialog.this.appConfigTableModel.getItems().get(modelRow).getDisplayName();
                }
                return super.getToolTipText(event);
            }

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                this.editingClass = null;
                int modelColumn = this.convertColumnIndexToModel(column);
                if (AppConfigTableModel.COLUMNS[modelColumn] == ColumnDef.VALUE) {
                    int modelRow = this.convertRowIndexToModel(row);
                    AppConfigRow rowData = AppConfigDialog.this.appConfigTableModel.getItems().get(modelRow);
                    Class<?> dataType = rowData.getPropertyType();
                    TableCellRenderer renderer = this.getDefaultRenderer(dataType);
                    if (renderer != null) {
                        return renderer;
                    }
                }
                return super.getCellRenderer(row, column);
            }

            @Override
            public TableCellEditor getCellEditor(int row, int column) {
                this.editingClass = null;
                int modelColumn = this.convertColumnIndexToModel(column);
                if (AppConfigTableModel.COLUMNS[modelColumn] == ColumnDef.VALUE) {
                    int modelRow = this.convertRowIndexToModel(row);
                    AppConfigRow rowData = AppConfigDialog.this.appConfigTableModel.getItems().get(modelRow);
                    this.editingClass = rowData.getPropertyType();
                    return this.getDefaultEditor(this.editingClass);
                }
                return super.getCellEditor(row, column);
            }

            @Override
            public Class<?> getColumnClass(int column) {
                return this.editingClass != null ? this.editingClass : super.getColumnClass(column);
            }
        };
        this.appConfigTable.setShowGrid(true);
        this.appConfigTable.setGridColor(appConfig.getGridColor());
        this.appConfigTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.appConfigTable.setAutoResizeMode(0);
        this.appConfigTable.setCellSelectionEnabled(true);
        this.appConfigTable.setRowHeight((int)((double)this.appConfigTable.getFont().getSize() * 1.2));
        this.appConfigTable.setDefaultRenderer(Color.class, new ColorCellRender());
        this.appConfigTable.setDefaultEditor(Color.class, new ColorCellEditor());
        this.appConfigTableModel.adjustColumnModel(this.appConfigTable.getColumnModel(), scaleSupport.getManualScaleX());
        this.appConfigTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                AppConfigDialog.this.updateUIState();
            }
        });
        JScrollPane appConfigTableSP = new JScrollPane(this.appConfigTable);
        appConfigTableSP.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3), BorderFactory.createTitledBorder(strings.getProperty("table.caption"))));
        appConfigTableSP.setVerticalScrollBarPolicy(22);
        contentPane.add((Component)appConfigTableSP, "Center");
        Toolkit tk = Toolkit.getDefaultToolkit();
        JRootPane rootPane = this.getRootPane();
        InputMap im = rootPane.getInputMap(2);
        ActionMap am = rootPane.getActionMap();
        im.put(KeyStroke.getKeyStroke(27, 0), "closeAppConfigDialog");
        im.put(KeyStroke.getKeyStroke(87, tk.getMenuShortcutKeyMask()), "closeAppConfigDialog");
        am.put("closeAppConfigDialog", actCancel);
        this.updateUIState();
    }

    protected void updateUIState() {
        AppConfig appConfig;
        boolean hasModified = false;
        for (AppConfigRow itemRow : this.appConfigTableModel.getItems()) {
            if (itemRow.isModified()) {
                hasModified = true;
                continue;
            }
            if (!itemRow.isRejected()) continue;
            itemRow.setRejected(false);
        }
        if (this.orgDoNotAskAgain != this.chkResetDoNotAskAgain.isSelected()) {
            hasModified = true;
        }
        boolean enableSave = !(appConfig = AppConfig.getInstance()).getPrioritySaveFileList().isEmpty();
        this.actApply.setEnabled(enableSave && hasModified);
    }

    private void loadData() {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/appconfigdialog");
        BeanPropertiesUtilities.PropertyAccessorMap<AppConfig> accessorMap = BeanPropertiesUtilities.getPropertyAccessorMap(AppConfig.class);
        AppConfig appConfig = AppConfig.getInstance();
        accessorMap.setBean(appConfig);
        ArrayList<AppConfigRow> items = new ArrayList<AppConfigRow>();
        int fallbackOrder = 1000;
        for (Map.Entry<String, BeanPropertiesUtilities.PropertyAccessor> accessorEntry : accessorMap.entrySet()) {
            String name = accessorEntry.getKey();
            BeanPropertiesUtilities.PropertyAccessor accessor = accessorEntry.getValue();
            Object value = accessor.getValue();
            String displayName = strings.getProperty(name, name);
            int pt = displayName.indexOf(";");
            String order = Integer.toString(fallbackOrder++);
            if (pt > 0) {
                order = displayName.substring(0, pt);
                displayName = displayName.substring(pt + 1);
            }
            AppConfigRow rowItem = new AppConfigRow(name, accessor, value);
            rowItem.setDisplayName(displayName);
            rowItem.setOrder(order);
            items.add(rowItem);
        }
        Collections.sort(items, new Comparator<AppConfigRow>(){

            @Override
            public int compare(AppConfigRow o1, AppConfigRow o2) {
                int ret = o1.getOrder().compareTo(o2.getOrder());
                if (ret == 0) {
                    ret = o1.getDisplayName().compareTo(o2.getDisplayName());
                }
                if (ret == 0) {
                    ret = o1.getName().compareTo(o2.getName());
                }
                return ret;
            }
        });
        this.appConfigTableModel.setItems(items);
        try {
            this.recentCharactersDir = RecentCharactersDir.load();
            if (this.recentCharactersDir != null) {
                File lastUseCharactersDir = this.recentCharactersDir.getLastUseCharacterDir();
                boolean enableLastUseCharacterDir = lastUseCharactersDir != null && lastUseCharactersDir.isDirectory();
                boolean doNotAskAgain = enableLastUseCharacterDir && this.recentCharactersDir.isDoNotAskAgain();
                this.chkResetDoNotAskAgain.setEnabled(enableLastUseCharacterDir);
                this.chkResetDoNotAskAgain.setSelected(!doNotAskAgain);
            }
        }
        catch (Exception ex) {
            this.recentCharactersDir = null;
            logger.log(Level.WARNING, "RecentCharactersDir load failed.", ex);
        }
        this.orgDoNotAskAgain = this.chkResetDoNotAskAgain.isSelected();
    }

    protected void onResetSettings() {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/appconfigdialog");
        if (JOptionPane.showConfirmDialog(this, strings.getProperty("confirm.resetSettingsToDefault"), strings.getProperty("confirm.close.caption"), 0, 3) != 0) {
            return;
        }
        Map<String, Object> defMap = AppConfig.getDefaultProperties();
        for (AppConfigRow rowItem : this.appConfigTableModel.getItems()) {
            String name = rowItem.getName();
            if (!defMap.containsKey(name)) continue;
            Object value = defMap.get(name);
            rowItem.setValue(value);
        }
        this.appConfigTableModel.fireTableDataChanged();
    }

    protected void onSetupLocalization() {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/appconfigdialog");
        if (JOptionPane.showConfirmDialog(this, strings.getProperty("setupLocalization"), strings.getProperty("confirm.setupLocalization.caption"), 2, 2) != 0) {
            return;
        }
        try {
            File baseDir = ConfigurationDirUtilities.getUserDataDir();
            SetupLocalization setup = new SetupLocalization(baseDir);
            setup.setupToLocal(EnumSet.allOf(SetupLocalization.Resources.class), true);
            File resourceDir = setup.getResourceDir();
            DesktopUtilities.open(resourceDir);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onClose() {
        Properties strings;
        if (this.appConfigTableModel.isModified() && JOptionPane.showConfirmDialog(this, (strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/appconfigdialog")).getProperty("confirm.close"), strings.getProperty("confirm.close.caption"), 0, 3) != 0) {
            return;
        }
        this.dispose();
    }

    protected void onUpdate() {
        boolean updateRecentCharactersDir;
        if (this.appConfigTable.isEditing()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/appconfigdialog");
        HashMap<String, Object> modifiedValues = new HashMap<String, Object>();
        for (AppConfigRow rowItem : this.appConfigTableModel.getItems()) {
            if (!rowItem.isModified()) continue;
            String name = rowItem.getName();
            Object value = rowItem.getValue();
            modifiedValues.put(name, value);
        }
        boolean bl = updateRecentCharactersDir = this.orgDoNotAskAgain != this.chkResetDoNotAskAgain.isSelected();
        if (!updateRecentCharactersDir && modifiedValues.isEmpty()) {
            return;
        }
        if (!modifiedValues.isEmpty()) {
            Set<String> rejectNames = AppConfig.checkProperties(modifiedValues);
            if (!rejectNames.isEmpty()) {
                this.appConfigTableModel.setRejectNames(rejectNames);
                JOptionPane.showMessageDialog(this, strings.getProperty("error.message"), strings.getProperty("error.caption"), 0);
                return;
            }
            try {
                AppConfig appConfig = AppConfig.getInstance();
                appConfig.update(modifiedValues);
                appConfig.saveConfig();
            }
            catch (Exception ex) {
                ErrorMessageHelper.showErrorDialog(this, ex);
                return;
            }
        }
        if (updateRecentCharactersDir) {
            try {
                if (this.chkResetDoNotAskAgain.isEnabled()) {
                    boolean doNotAskAgain;
                    boolean bl2 = doNotAskAgain = !this.chkResetDoNotAskAgain.isSelected();
                    if (doNotAskAgain != this.recentCharactersDir.isDoNotAskAgain()) {
                        this.recentCharactersDir.setDoNotAskAgain(doNotAskAgain);
                        this.recentCharactersDir.saveRecents();
                    }
                }
            }
            catch (Exception ex) {
                ErrorMessageHelper.showErrorDialog(this, ex);
                return;
            }
        }
        String message = strings.getProperty("caution");
        JOptionPane.showMessageDialog(this, message);
        this.dispose();
    }

    private static class AppConfigTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        protected static final ColumnDef[] COLUMNS = ColumnDef.values();
        private List<AppConfigRow> items = Collections.emptyList();

        private AppConfigTableModel() {
        }

        public List<AppConfigRow> getItems() {
            return this.items;
        }

        public void setItems(List<AppConfigRow> items) {
            if (items == null) {
                items = Collections.emptyList();
            }
            this.items = items;
            this.fireTableDataChanged();
        }

        public void setRejectNames(Set<String> rejectNames) {
            if (rejectNames == null) {
                rejectNames = Collections.emptySet();
            }
            for (AppConfigRow item : this.items) {
                String key = item.getName();
                boolean rejected = rejectNames.contains(key);
                item.setRejected(rejected);
            }
            this.fireTableDataChanged();
        }

        public boolean isModified() {
            for (AppConfigRow rowItem : this.items) {
                if (!rowItem.isModified()) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getRowCount() {
            return this.items.size();
        }

        @Override
        public int getColumnCount() {
            return COLUMNS.length;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return COLUMNS[columnIndex].getType();
        }

        @Override
        public String getColumnName(int column) {
            Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/appconfigdialog");
            String reskey = COLUMNS[column].getResourceKey();
            return strings.getProperty(reskey, reskey);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return COLUMNS[columnIndex].isEditable();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            AppConfigRow row = this.items.get(rowIndex);
            return COLUMNS[columnIndex].getValue(row);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            AppConfigRow row = this.items.get(rowIndex);
            COLUMNS[columnIndex].setValue(row, aValue);
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }

        public void adjustColumnModel(TableColumnModel columnModel, double scale) {
            Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/appconfigdialog");
            int mx = columnModel.getColumnCount();
            for (int idx = 0; idx < mx; ++idx) {
                String reskey = COLUMNS[idx].getResourceKey() + ".width";
                int width = Integer.parseInt(strings.getProperty(reskey));
                columnModel.getColumn(idx).setPreferredWidth((int)((double)width * scale));
            }
        }
    }

    private static class AppConfigRow {
        private final String name;
        private final BeanPropertiesUtilities.PropertyAccessor accessor;
        private String order = "";
        private String displayName;
        private Object orgValue;
        private Object value;
        private boolean rejected;

        public AppConfigRow(String name, BeanPropertiesUtilities.PropertyAccessor accessor, Object value) {
            this.name = name;
            this.accessor = accessor;
            this.value = value;
            this.orgValue = value;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getPropertyType() {
            Class<Object> dataType = this.accessor.getPropertyType();
            if (dataType.isPrimitive()) {
                if (dataType.equals(Integer.TYPE)) {
                    dataType = Integer.class;
                } else if (dataType.equals(Long.TYPE)) {
                    dataType = Long.class;
                } else if (dataType.equals(Float.TYPE)) {
                    dataType = Float.class;
                } else if (dataType.equals(Double.TYPE)) {
                    dataType = Double.class;
                } else if (dataType.equals(Boolean.TYPE)) {
                    dataType = Boolean.class;
                }
            }
            return dataType;
        }

        public String getOrder() {
            return this.order;
        }

        public void setOrder(String order) {
            if (order == null) {
                order = "";
            }
            this.order = order;
        }

        public String getDisplayName() {
            return this.displayName == null || this.displayName.length() == 0 ? this.name : this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean isRejected() {
            return this.rejected;
        }

        public void setRejected(boolean rejected) {
            this.rejected = rejected;
        }

        public boolean isModified() {
            return this.orgValue == null ? this.value != null : !this.orgValue.equals(this.value);
        }
    }

    public static enum ColumnDef {
        NAME("column.key", (Class)String.class, false){

            @Override
            public Object getValue(AppConfigRow row) {
                return row.getDisplayName();
            }
        }
        ,
        VALUE("column.value", (Class)String.class, true){

            @Override
            public Object getValue(AppConfigRow row) {
                return row.getValue();
            }

            @Override
            public void setValue(AppConfigRow row, Object value) {
                row.setValue(value);
            }
        };

        private final String reskey;
        private final Class<?> type;
        private final boolean editable;

        private ColumnDef(String reskey, Class<?> type, boolean editable) {
            this.reskey = reskey;
            this.type = type;
            this.editable = editable;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public String getResourceKey() {
            return this.reskey;
        }

        public Class<?> getType() {
            return this.type;
        }

        public abstract Object getValue(AppConfigRow var1);

        public void setValue(AppConfigRow row, Object value) {
            throw new UnsupportedOperationException(this.name());
        }
    }
}

