/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.graphics.io.FileImageResource;
import charactermanaj.graphics.io.ImageLoader;
import charactermanaj.graphics.io.ImageSaveHelper;
import charactermanaj.graphics.io.LoadedImage;
import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.CustomLayerOrder;
import charactermanaj.model.CustomLayerOrderKey;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.io.CharacterDataDefaultProvider;
import charactermanaj.model.io.CharacterDataIniReader;
import charactermanaj.model.io.CharacterDataXMLReader;
import charactermanaj.model.io.CharacterDataXMLWriter;
import charactermanaj.model.io.CustomLayerOrderPersist;
import charactermanaj.model.io.TextReadHelper;
import charactermanaj.model.io.WorkingSetPersist;
import charactermanaj.util.DirectoryConfig;
import charactermanaj.util.FileNameNormalizer;
import charactermanaj.util.FileUserData;
import charactermanaj.util.FileUtilities;
import charactermanaj.util.UserData;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CharacterDataPersistent {
    public static final String CONFIG_FILE = "character.xml";
    public static final String COMPATIBLE_CONFIG_NAME = "character.ini";
    private static final String FAVORITES_FILE_NAME = "favorites.xml";
    private static final String SAMPLE_IMAGE_FILENAME = "preview.png";
    private static final Logger logger = Logger.getLogger(CharacterDataPersistent.class.getName());
    private final CharacterDataXMLReader characterDataXmlReader = new CharacterDataXMLReader();
    private final CharacterDataXMLWriter characterDataXmlWriter = new CharacterDataXMLWriter();
    private static final CharacterDataPersistent singleton = new CharacterDataPersistent();

    private CharacterDataPersistent() {
    }

    public static CharacterDataPersistent getInstance() {
        return singleton;
    }

    public void createProfile(CharacterData characterData) throws IOException {
        File characterPropXML;
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        String id = characterData.getId();
        if (id == null || id.trim().length() == 0) {
            throw new IOException("missing character-id:" + characterData);
        }
        DirectoryConfig dirConfig = DirectoryConfig.getInstance();
        File charactersDir = dirConfig.getCharactersDir();
        if (!charactersDir.exists() && !charactersDir.mkdirs()) {
            throw new IOException("can't create the characters directory. " + charactersDir);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "check characters-dir: " + charactersDir + ": exists=" + charactersDir.exists());
        }
        File baseDir = null;
        String suffix = "";
        String name = characterData.getName();
        if (name == null) {
            name = characterData.getId();
        }
        int retry = 0;
        while ((baseDir = new File(charactersDir, name + suffix)).exists()) {
            if (retry > 100) {
                throw new IOException("character directory conflict.:" + baseDir);
            }
            suffix = this.generateSuffix(retry);
            ++retry;
        }
        if (!baseDir.exists()) {
            if (!baseDir.mkdirs()) {
                throw new IOException("can't create directory. " + baseDir);
            }
            logger.log(Level.INFO, "create character-dir: " + baseDir);
        }
        if ((characterPropXML = new File(baseDir, CONFIG_FILE)).exists() && !characterPropXML.isFile()) {
            throw new IOException("character.xml is not a regular file.:" + characterPropXML);
        }
        if (characterPropXML.exists() && !characterPropXML.canWrite()) {
            throw new IOException("character.xml is not writable.:" + characterPropXML);
        }
        URI docBase = characterPropXML.toURI();
        characterData.setDocBase(docBase);
        if (characterData.getRev() == null) {
            characterData.setRev(this.generateRev());
        }
        this.saveCharacterDataToXML(characterData);
        this.preparePartsDir(characterData);
    }

    public void createProfile(CharacterData characterData, Map<CustomLayerOrderKey, List<CustomLayerOrder>> customLayerPatterns) throws IOException {
        this.createProfile(characterData);
        if (characterData.isEnableCustonLayerPattern() && customLayerPatterns != null) {
            CustomLayerOrderPersist persist = CustomLayerOrderPersist.newInstance(characterData);
            persist.save(customLayerPatterns);
        }
    }

    public String generateRev() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
        return fmt.format(new Date());
    }

    protected String generateSuffix(int retryCount) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
        String suffix = "_" + fmt.format(new Date());
        if (retryCount > 0) {
            suffix = suffix + "_" + retryCount;
        }
        return suffix;
    }

    public void updateProfile(CharacterData characterData) throws IOException {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        characterData.checkWritable();
        if (!characterData.isValid()) {
            throw new IOException("invalid profile: " + characterData);
        }
        this.saveCharacterDataToXML(characterData);
        this.preparePartsDir(characterData);
    }

    protected void preparePartsDir(CharacterData characterData) throws IOException {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        characterData.checkWritable();
        if (!characterData.isValid()) {
            throw new IOException("invalid profile: " + characterData);
        }
        URI docBase = characterData.getDocBase();
        if (!"file".equals(docBase.getScheme())) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u4ee5\u5916\u306f\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093\u3002:" + docBase);
        }
        File docBaseFile = new File(docBase);
        File baseDir = docBaseFile.getParentFile();
        if (!baseDir.exists() && !baseDir.mkdirs()) {
            throw new IOException("can't create directory. " + baseDir);
        }
        for (PartsCategory partsCategory : characterData.getPartsCategories()) {
            for (Layer layer : partsCategory.getLayers()) {
                File layerDir = new File(baseDir, layer.getDir());
                if (layerDir.exists() || layerDir.mkdirs()) continue;
                throw new IOException("can't create directory. " + layerDir);
            }
        }
    }

    public void convertCharacterNantokaIniToXml(File dataDir) {
        if (dataDir == null || !dataDir.isDirectory() || !dataDir.canWrite()) {
            return;
        }
        File[] dirs = dataDir.listFiles();
        if (dirs == null) {
            dirs = new File[]{};
        }
        for (File dir : dirs) {
            File characterIniFile;
            File characterXmlFile;
            if (!dir.isDirectory() || (characterXmlFile = new File(dir, CONFIG_FILE)).exists() || !(characterIniFile = new File(dir, COMPATIBLE_CONFIG_NAME)).exists() || !characterIniFile.canWrite() || !dir.canWrite()) continue;
            File eyeColorFolder = new File(dir, "eye_color");
            boolean hasEyeColorFolder = eyeColorFolder.exists() && eyeColorFolder.isDirectory();
            CharacterDataDefaultProvider.DefaultCharacterDataVersion version = hasEyeColorFolder ? CharacterDataDefaultProvider.DefaultCharacterDataVersion.V3 : CharacterDataDefaultProvider.DefaultCharacterDataVersion.V2;
            String readme = null;
            File readmeFile = new File(dir, "readme.txt");
            if (readmeFile.exists() && readmeFile.canRead()) {
                try {
                    readme = TextReadHelper.readTextTryEncoding(new FileInputStream(readmeFile));
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, ex.toString(), ex);
                }
            }
            try {
                this.convertFromCharacterIni(characterIniFile, characterXmlFile, version, readme);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "character.xml\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002:" + characterXmlFile, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> listProfileAsync(final ListProfileCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException();
        }
        DirectoryConfig dirConfig = DirectoryConfig.getInstance();
        File baseDir = dirConfig.getCharactersDir();
        this.convertCharacterNantokaIniToXml(baseDir);
        FileNameNormalizer normalizer = FileNameNormalizer.getDefault();
        final AtomicBoolean cancelled = new AtomicBoolean(false);
        int numOfProcessors = Runtime.getRuntime().availableProcessors();
        final ExecutorService executorSrv = Executors.newFixedThreadPool(numOfProcessors);
        try {
            File[] dirs = baseDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    boolean accept;
                    boolean bl = accept = pathname.isDirectory() && !pathname.getName().startsWith(".");
                    if (accept) {
                        File configFile = new File(pathname, CharacterDataPersistent.CONFIG_FILE);
                        accept = configFile.exists() && configFile.canRead();
                    }
                    return accept;
                }
            });
            if (dirs == null) {
                dirs = new File[]{};
            }
            for (File dir : dirs) {
                String path = normalizer.normalize(dir.getPath());
                final File normDir = new File(path);
                executorSrv.submit(new Runnable(){

                    @Override
                    public void run() {
                        boolean terminate = false;
                        File characterDataXml = new File(normDir, CharacterDataPersistent.CONFIG_FILE);
                        if (characterDataXml.exists()) {
                            try {
                                File docBaseFile = new File(normDir, CharacterDataPersistent.CONFIG_FILE);
                                URI docBase = docBaseFile.toURI();
                                CharacterData characterData = CharacterDataPersistent.this.loadProfile(docBase);
                                terminate = !callback.receiveCharacterData(characterData);
                            }
                            catch (Exception ex) {
                                boolean bl = terminate = !callback.occureException(normDir, ex);
                            }
                        }
                        if (terminate) {
                            logger.log(Level.FINE, "shutdownNow listProfile");
                            executorSrv.shutdownNow();
                            cancelled.set(true);
                        }
                    }
                });
            }
        }
        finally {
            executorSrv.shutdown();
        }
        Future<Object> awaiter = new Future<Object>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (executorSrv.isTerminated()) {
                    return false;
                }
                executorSrv.shutdownNow();
                cancelled.set(true);
                return true;
            }

            @Override
            public boolean isCancelled() {
                return cancelled.get();
            }

            @Override
            public boolean isDone() {
                return executorSrv.isTerminated();
            }

            @Override
            public Object get() throws InterruptedException, ExecutionException {
                try {
                    return this.get(300L, TimeUnit.SECONDS);
                }
                catch (TimeoutException ex) {
                    throw new ExecutionException(ex);
                }
            }

            @Override
            public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                executorSrv.shutdown();
                if (!executorSrv.isTerminated()) {
                    executorSrv.awaitTermination(timeout, unit);
                }
                return null;
            }
        };
        return awaiter;
    }

    public List<CharacterData> listProfiles(final ProfileListErrorHandler errorHandler) {
        final ArrayList profiles = new ArrayList();
        Future<?> awaiter = this.listProfileAsync(new ListProfileCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean receiveCharacterData(CharacterData characterData) {
                List list = profiles;
                synchronized (list) {
                    profiles.add(characterData);
                }
                return true;
            }

            @Override
            public boolean occureException(File dir, Exception ex) {
                if (errorHandler != null) {
                    errorHandler.occureException(dir, ex);
                }
                return true;
            }
        });
        try {
            awaiter.get();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "listProfile abort.", ex);
        }
        Collections.sort(profiles, CharacterData.SORT_DISPLAYNAME);
        return Collections.unmodifiableList(profiles);
    }

    public CharacterData loadProfile(URI docBase) throws IOException {
        if (docBase == null) {
            throw new IllegalArgumentException();
        }
        CharacterData characterData = this.characterDataXmlReader.loadCharacterDataFromXML(docBase);
        return characterData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveCharacterDataToXML(CharacterData characterData) throws IOException {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        characterData.checkWritable();
        if (!characterData.isValid()) {
            throw new IOException("invalid profile: " + characterData);
        }
        URI docBase = characterData.getDocBase();
        if (!"file".equals(docBase.getScheme())) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u4ee5\u5916\u306f\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093: " + docBase);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.characterDataXmlWriter.writeXMLCharacterData(characterData, bos);
        }
        finally {
            bos.close();
        }
        File characterPropXML = new File(docBase);
        File baseDir = characterPropXML.getParentFile();
        if (!baseDir.exists() && !baseDir.mkdirs()) {
            logger.log(Level.WARNING, "can't create directory. " + baseDir);
        }
        FileOutputStream fos = new FileOutputStream(characterPropXML);
        try {
            fos.write(bos.toByteArray());
        }
        finally {
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFavorites(CharacterData characterData) throws IOException {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        UserData favoritesData = this.getFavoritesUserData(characterData);
        OutputStream os = favoritesData.getOutputStream();
        try {
            this.characterDataXmlWriter.saveFavorites(characterData, os);
        }
        finally {
            os.close();
        }
    }

    private UserData getFavoritesUserData(CharacterData characterData) {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        URI docBase = characterData.getDocBase();
        File characterDir = new File(docBase).getParentFile();
        return new FileUserData(new File(characterDir, FAVORITES_FILE_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFavorites(CharacterData characterData) throws IOException {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        UserData favoritesXml = this.getFavoritesUserData(characterData);
        if (favoritesXml.exists() && favoritesXml.length() > 0L) {
            InputStream is = favoritesXml.openStream();
            try {
                this.characterDataXmlReader.loadPartsSet(characterData, is);
            }
            finally {
                is.close();
            }
        }
    }

    public void remove(CharacterData cd, boolean forceRemove) throws IOException {
        if (cd == null || cd.getDocBase() == null) {
            throw new IllegalArgumentException();
        }
        URI docBase = cd.getDocBase();
        File xmlFile = new File(docBase);
        if (!xmlFile.exists() || !xmlFile.isFile()) {
            return;
        }
        File baseDir = xmlFile.getParentFile();
        if (!baseDir.exists()) {
            return;
        }
        WorkingSetPersist workingSetPersist = WorkingSetPersist.getInstance();
        workingSetPersist.removeWorkingSet(cd);
        if (!forceRemove) {
            this.logicalDelete(xmlFile);
        } else {
            try {
                FileUtilities.delete(baseDir);
            }
            catch (IOException ex) {
                this.logicalDelete(xmlFile);
                throw ex;
            }
        }
    }

    private void logicalDelete(File xmlFile) throws IOException {
        File baseDir = xmlFile.getParentFile();
        String suffix = "." + System.currentTimeMillis() + ".deleted";
        File bakFile = new File(xmlFile.getPath() + suffix);
        if (!xmlFile.renameTo(bakFile)) {
            throw new IOException("can not rename configuration file.:" + xmlFile);
        }
        File parentBak = new File(baseDir.getPath() + suffix);
        if (!baseDir.renameTo(parentBak)) {
            throw new IOException("can't rename directory. " + baseDir);
        }
    }

    public BufferedImage loadSamplePicture(CharacterData characterData, ImageLoader loader) throws IOException {
        if (characterData == null || loader == null) {
            throw new IllegalArgumentException();
        }
        if (!characterData.isValid()) {
            return null;
        }
        File sampleImageFile = this.getSamplePictureFile(characterData);
        if (sampleImageFile != null && sampleImageFile.exists()) {
            LoadedImage loadedImage = loader.load(new FileImageResource(sampleImageFile));
            return loadedImage.getImage();
        }
        return null;
    }

    public boolean canSaveSamplePicture(CharacterData characterData) {
        if (characterData == null || !characterData.isValid()) {
            return false;
        }
        File sampleImageFile = this.getSamplePictureFile(characterData);
        if (sampleImageFile != null) {
            File parentDir;
            if (sampleImageFile.exists() && sampleImageFile.canWrite()) {
                return true;
            }
            if (!sampleImageFile.exists() && (parentDir = sampleImageFile.getParentFile()) != null) {
                return parentDir.canWrite();
            }
        }
        return false;
    }

    protected File getSamplePictureFile(CharacterData characterData) {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        URI docBase = characterData.getDocBase();
        if (docBase != null && "file".endsWith(docBase.getScheme())) {
            File docBaseFile = new File(docBase);
            return new File(docBaseFile.getParentFile(), SAMPLE_IMAGE_FILENAME);
        }
        return null;
    }

    public void saveSamplePicture(CharacterData characterData, BufferedImage samplePicture) throws IOException {
        if (!this.canSaveSamplePicture(characterData)) {
            throw new IOException("can not write a sample picture.:" + characterData);
        }
        File sampleImageFile = this.getSamplePictureFile(characterData);
        if (samplePicture != null) {
            AppConfig appConfig = AppConfig.getInstance();
            Color sampleImageBgColor = appConfig.getSampleImageBgColor();
            ImageSaveHelper imageSaveHelper = new ImageSaveHelper();
            imageSaveHelper.savePicture(samplePicture, sampleImageBgColor, sampleImageFile, null);
        } else if (sampleImageFile.exists()) {
            FileUtilities.delete(sampleImageFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertFromCharacterIni(File characterIniFile, File characterXmlFile, CharacterDataDefaultProvider.DefaultCharacterDataVersion version, String description) throws IOException {
        CharacterData characterData;
        if (characterIniFile == null || characterXmlFile == null || version == null) {
            throw new IllegalArgumentException();
        }
        FileInputStream is = new FileInputStream(characterIniFile);
        try {
            CharacterDataIniReader iniReader = new CharacterDataIniReader();
            characterData = iniReader.readCharacterDataFromIni(is, version);
        }
        finally {
            is.close();
        }
        if (description != null) {
            characterData.setDescription(description);
        }
        URI docBase = characterXmlFile.toURI();
        characterData.setDocBase(docBase);
        boolean succeeded = false;
        try {
            FileOutputStream outstm = new FileOutputStream(characterXmlFile);
            try {
                this.characterDataXmlWriter.writeXMLCharacterData(characterData, outstm);
            }
            finally {
                outstm.close();
            }
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                try {
                    if (characterXmlFile.exists()) {
                        characterXmlFile.delete();
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002:" + characterXmlFile, ex);
                }
            }
        }
    }

    public void compensateRecommendationList(CharacterData characterData) {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        if (characterData.getRecommendationURLList() != null) {
            return;
        }
        CharacterDataDefaultProvider defProv = new CharacterDataDefaultProvider();
        CharacterData defaultCd = defProv.createDefaultCharacterData(CharacterDataDefaultProvider.DefaultCharacterDataVersion.V3);
        characterData.setRecommendationURLList(defaultCd.getRecommendationURLList());
    }

    public static interface ListProfileCallback {
        public boolean receiveCharacterData(CharacterData var1);

        public boolean occureException(File var1, Exception var2);
    }

    public static interface ProfileListErrorHandler {
        public void occureException(File var1, Throwable var2);
    }
}

