/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.CharacterData;
import charactermanaj.model.io.AbstractCharacterDataArchiveFile;
import charactermanaj.util.FileNameNormalizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CharacterDataDirectoryFile
extends AbstractCharacterDataArchiveFile {
    private static final Logger logger = Logger.getLogger(CharacterDataDirectoryFile.class.getName());
    protected File baseDir;

    @Override
    protected URI getContentURI(String name) throws IOException {
        return new File(this.baseDir, name).toURI();
    }

    @Override
    public Collection<AbstractCharacterDataArchiveFile.PartsImageContent> getPartsImageContents(CharacterData characterData, boolean newly) {
        if (!newly && this.isOverlapped(characterData)) {
            return Collections.emptyList();
        }
        return super.getPartsImageContents(characterData, newly);
    }

    protected boolean isOverlapped(CharacterData characterData) {
        if (characterData == null) {
            return false;
        }
        URI docBase = characterData.getDocBase();
        if (docBase == null || !"file".equals(docBase.getScheme())) {
            return false;
        }
        String folderPlace = File.separator;
        String basePath = new File(docBase).getParent() + folderPlace;
        String sourcePath = this.baseDir.getPath() + folderPlace;
        boolean result = basePath.contains(sourcePath);
        logger.log(Level.FINE, "checkOverlapped: " + basePath + " * " + sourcePath + " :" + result);
        return result;
    }

    @Override
    public void close() throws IOException {
    }

    public CharacterDataDirectoryFile(File file) throws IOException {
        super(file);
        this.baseDir = file;
        this.load(this.baseDir, "");
        this.searchRootPrefix();
    }

    private void load(File dir, String prefix) {
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        FileNameNormalizer normalizer = FileNameNormalizer.getDefault();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                String name = normalizer.normalize(file.getName());
                String entryName = prefix + name;
                if (file.isDirectory()) {
                    this.load(file, entryName + "/");
                    continue;
                }
                this.addEntry(new DirFileContent(file, entryName));
            }
        }
    }

    protected static class DirFileContent
    implements AbstractCharacterDataArchiveFile.FileContent {
        private String entryName;
        private File entry;

        protected DirFileContent(File entry, String entryName) {
            this.entry = entry;
            this.entryName = entryName;
        }

        @Override
        public String getEntryName() {
            return this.entryName;
        }

        @Override
        public long lastModified() {
            return this.entry.lastModified();
        }

        @Override
        public long length() {
            return this.entry.length();
        }

        @Override
        public InputStream openStream() throws IOException {
            return new FileInputStream(this.entry);
        }
    }
}

