/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.model.CharacterData;
import charactermanaj.model.IndependentPartsColorInfo;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IndependentPartsSetInfo {
    private static final Logger logger = Logger.getLogger(IndependentPartsSetInfo.class.getName());
    private String id;
    private String displayName;
    private Color backgroundColor;
    private double[] affineTransformParameter;
    private Set<String> activeCustomLayerPatternIds;
    private Map<String, Map<String, List<IndependentPartsColorInfo>>> partsMap = new HashMap<String, Map<String, List<IndependentPartsColorInfo>>>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public double[] getAffineTransformParameter() {
        return this.affineTransformParameter;
    }

    public void setAffineTransformParameter(double[] affineTransformParameter) {
        this.affineTransformParameter = affineTransformParameter;
    }

    public Set<String> getActiveCustomLayerPatternIds() {
        return this.activeCustomLayerPatternIds;
    }

    public void setActiveCustomLayerPatternIds(Set<String> activeCustomLayerPatternIds) {
        this.activeCustomLayerPatternIds = activeCustomLayerPatternIds;
    }

    public Map<String, Map<String, List<IndependentPartsColorInfo>>> getPartsMap() {
        return this.partsMap;
    }

    public void setPartsMap(Map<String, Map<String, List<IndependentPartsColorInfo>>> partsMap) {
        if (partsMap == null) {
            throw new IllegalArgumentException();
        }
        this.partsMap = partsMap;
    }

    public static PartsSet convertPartsSet(IndependentPartsSetInfo partsSetInfo, CharacterData characterData, boolean presetParts) {
        double[] affineTrans;
        if (partsSetInfo == null || characterData == null) {
            throw new IllegalArgumentException();
        }
        PartsSet partsSet = new PartsSet();
        partsSet.setPartsSetId(partsSetInfo.getId());
        partsSet.setLocalizedName(partsSetInfo.getDisplayName());
        partsSet.setPresetParts(presetParts);
        Color backgroundColor = partsSetInfo.getBackgroundColor();
        if (backgroundColor != null) {
            partsSet.setBgColor(backgroundColor);
        }
        if ((affineTrans = partsSetInfo.getAffineTransformParameter()) != null) {
            partsSet.setAffineTransformParameter(affineTrans);
        }
        Map<String, Map<String, List<IndependentPartsColorInfo>>> partsMap = partsSetInfo.getPartsMap();
        for (Map.Entry<String, Map<String, List<IndependentPartsColorInfo>>> categoryEntry : partsMap.entrySet()) {
            String categoryId = categoryEntry.getKey();
            Map<String, List<IndependentPartsColorInfo>> categoryPartsMap = categoryEntry.getValue();
            PartsCategory partsCategory = characterData.getPartsCategory(categoryId);
            if (partsCategory == null) {
                logger.log(Level.WARNING, "undefined category-id: " + categoryId);
                continue;
            }
            for (Map.Entry<String, List<IndependentPartsColorInfo>> partsEntry : categoryPartsMap.entrySet()) {
                String partsName = partsEntry.getKey();
                List<IndependentPartsColorInfo> colorInfoList = partsEntry.getValue();
                PartsIdentifier partsIdentifier = new PartsIdentifier(partsCategory, partsName, partsName);
                PartsColorInfo partsColorInfo = IndependentPartsColorInfo.buildPartsColorInfo(characterData, partsCategory, colorInfoList);
                partsSet.appendParts(partsCategory, partsIdentifier, partsColorInfo);
            }
        }
        partsSet.setActiveCustomLayerPatternIds(partsSetInfo.getActiveCustomLayerPatternIds());
        return partsSet;
    }
}

