/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.graphics.io.ImagePreviewFileChooser;
import charactermanaj.ui.ColorBox;
import charactermanaj.ui.model.PredefinedWallpaper;
import charactermanaj.ui.model.WallpaperInfo;
import charactermanaj.util.LocalizedMessageComboBoxRender;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WallpaperDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected static final String STRINGS_RESOURCE = "languages/wallpaperdialog";
    private static ArrayList<PredefinedWallpaper> predefinedWallpapers = new ArrayList();
    private WallpaperInfo wallpaperInfo = new WallpaperInfo();
    private JRadioButton radioNone;
    private JRadioButton radioFile;
    private JRadioButton radioPredefined;
    private JList listPredefinedWallpapers;
    private JSpinner spinnerAlpha;
    private JTextField txtFile;
    private AbstractAction actChooseFile;
    private ColorBox colorBox;

    public WallpaperDialog(JFrame parent) {
        super((Frame)parent, true);
        try {
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    WallpaperDialog.this.onCancel();
                }
            });
            WallpaperDialog.initPredefinedWallpapers();
            this.initComponent();
        }
        catch (RuntimeException ex) {
            this.dispose();
            throw ex;
        }
    }

    private static synchronized void initPredefinedWallpapers() {
        if (!predefinedWallpapers.isEmpty()) {
            return;
        }
        predefinedWallpapers.addAll(PredefinedWallpaper.getPredefinedWallpapers());
    }

    private void initComponent() {
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.setTitle(strings.getProperty("title"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout(3, 3));
        this.getRootPane().setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel wallpaperPanel = this.createWallpaperChoosePanel(strings);
        JPanel bgcolorPanel = this.createBgColorPanel(strings);
        JPanel btnPanel = this.createButtonPanel(strings);
        contentPane.add((Component)bgcolorPanel, "North");
        contentPane.add((Component)wallpaperPanel, "Center");
        contentPane.add((Component)btnPanel, "South");
        this.setSize(400, 350);
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createButtonPanel(Properties strings) {
        JPanel btnPanel = new JPanel();
        AbstractAction actOK = new AbstractAction(strings.getProperty("btn.ok")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                WallpaperDialog.this.onOK();
            }
        };
        AbstractAction actCancel = new AbstractAction(strings.getProperty("btn.cancel")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                WallpaperDialog.this.onCancel();
            }
        };
        JButton btnOK = new JButton(actOK);
        JButton btnCancel = new JButton(actCancel);
        BoxLayout bl = new BoxLayout(btnPanel, 2);
        btnPanel.setLayout(bl);
        btnPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 45));
        btnPanel.add(Box.createHorizontalGlue());
        if (Main.isLinuxOrMacOSX()) {
            btnPanel.add(btnCancel);
            btnPanel.add(btnOK);
        } else {
            btnPanel.add(btnOK);
            btnPanel.add(btnCancel);
        }
        JRootPane rootPane = this.getRootPane();
        rootPane.setDefaultButton(btnOK);
        InputMap im = rootPane.getInputMap(2);
        ActionMap am = rootPane.getActionMap();
        Toolkit tk = Toolkit.getDefaultToolkit();
        im.put(KeyStroke.getKeyStroke(27, 0), "closeWallpaperDialog");
        im.put(KeyStroke.getKeyStroke(87, tk.getMenuShortcutKeyMask()), "closeWallpaperDialog");
        am.put("closeWallpaperDialog", actCancel);
        return btnPanel;
    }

    private JPanel createBgColorPanel(Properties strings) {
        JPanel bgcolorPanel = new JPanel();
        bgcolorPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(strings.getProperty("group.bgcolor")), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        GridBagLayout gbl = new GridBagLayout();
        bgcolorPanel.setLayout(gbl);
        this.colorBox = new ColorBox();
        this.colorBox.getColorDisplayPanel().setPreferredSize(new Dimension(48, 20));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.anchor = 10;
        gbc.fill = 0;
        bgcolorPanel.add((Component)this.colorBox, gbc);
        return bgcolorPanel;
    }

    private JPanel createWallpaperChoosePanel(Properties strings) {
        JPanel wallpaperPanel = new JPanel();
        wallpaperPanel.setBorder(BorderFactory.createTitledBorder(strings.getProperty("group.wallpaper")));
        GridBagLayout gbl = new GridBagLayout();
        wallpaperPanel.setLayout(gbl);
        this.radioNone = new JRadioButton(strings.getProperty("radio.none"));
        this.radioFile = new JRadioButton(strings.getProperty("radio.file"));
        this.radioPredefined = new JRadioButton(strings.getProperty("radio.predefined"));
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(this.radioNone);
        btnGroup.add(this.radioFile);
        btnGroup.add(this.radioPredefined);
        this.radioNone.setSelected(true);
        this.txtFile = new JTextField();
        this.actChooseFile = new AbstractAction(strings.getProperty("btn.chooseFile")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                WallpaperDialog.this.onChooseFile();
            }
        };
        JButton btnChooseFile = new JButton(this.actChooseFile);
        this.listPredefinedWallpapers = new JList<PredefinedWallpaper>(predefinedWallpapers.toArray(new PredefinedWallpaper[predefinedWallpapers.size()]));
        this.listPredefinedWallpapers.setCellRenderer(new LocalizedMessageComboBoxRender(strings));
        SpinnerNumberModel alphaSpModel = new SpinnerNumberModel(100, 0, 100, 1);
        this.spinnerAlpha = new JSpinner(alphaSpModel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.weightx = 0.0;
        wallpaperPanel.add((Component)this.radioNone, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.weightx = 0.0;
        wallpaperPanel.add((Component)this.radioFile, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        wallpaperPanel.add(Box.createHorizontalStrut(20), gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        wallpaperPanel.add((Component)this.txtFile, gbc);
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        wallpaperPanel.add((Component)btnChooseFile, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.weightx = 0.0;
        wallpaperPanel.add((Component)this.radioPredefined, gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        wallpaperPanel.add((Component)new JScrollPane(this.listPredefinedWallpapers), gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 0, 0, 0);
        wallpaperPanel.add((Component)new JLabel(strings.getProperty("label.wallpaperImageAlpha")), gbc);
        JPanel alphaPanel = new JPanel(new BorderLayout(3, 3));
        alphaPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        alphaPanel.add((Component)this.spinnerAlpha, "Center");
        alphaPanel.add((Component)new JLabel("%"), "East");
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.ipady = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 0;
        gbc.anchor = 17;
        wallpaperPanel.add((Component)alphaPanel, gbc);
        this.listPredefinedWallpapers.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                WallpaperDialog.this.radioPredefined.setSelected(true);
            }
        });
        return wallpaperPanel;
    }

    protected void onChooseFile() {
        File selectedFile = this.wallpaperInfo.getFile();
        ImagePreviewFileChooser fileChooser = new ImagePreviewFileChooser();
        fileChooser.setSelectedFile(selectedFile);
        if (fileChooser.showOpenDialog(this) != 0) {
            return;
        }
        selectedFile = fileChooser.getSelectedFile();
        this.txtFile.setText(selectedFile == null ? "" : selectedFile.getPath());
        this.radioFile.setSelected(selectedFile != null);
    }

    protected void applyByWallpaperInfo() {
        File imageFile = this.wallpaperInfo.getFile();
        this.txtFile.setText(imageFile == null ? "" : imageFile.getPath());
        PredefinedWallpaper selectedPredefinedWp = null;
        String resource = this.wallpaperInfo.getResource();
        for (PredefinedWallpaper predefinedWp : predefinedWallpapers) {
            if (!predefinedWp.getResource().equals(resource)) continue;
            selectedPredefinedWp = predefinedWp;
        }
        this.listPredefinedWallpapers.setSelectedValue(selectedPredefinedWp, true);
        int alphaInt = (int)(this.wallpaperInfo.getAlpha() * 100.0f);
        this.spinnerAlpha.setValue(alphaInt);
        Color bgColor = this.wallpaperInfo.getBackgroundColor();
        this.colorBox.setColorKey(bgColor);
        WallpaperInfo.WallpaperResourceType typ = this.wallpaperInfo.getType();
        if (typ == WallpaperInfo.WallpaperResourceType.FILE) {
            this.radioFile.setSelected(true);
        } else if (typ == WallpaperInfo.WallpaperResourceType.PREDEFINED) {
            this.radioPredefined.setSelected(true);
        } else {
            this.radioNone.setSelected(true);
        }
    }

    public WallpaperInfo createWallpaperInfo() {
        WallpaperInfo wallpaperInfo = this.wallpaperInfo.clone();
        WallpaperInfo.WallpaperResourceType typ = this.radioFile.isSelected() ? WallpaperInfo.WallpaperResourceType.FILE : (this.radioPredefined.isSelected() ? WallpaperInfo.WallpaperResourceType.PREDEFINED : WallpaperInfo.WallpaperResourceType.NONE);
        String strSelectedFile = this.txtFile.getText();
        File selectedFile = null;
        if (strSelectedFile != null && (strSelectedFile = strSelectedFile.trim()).length() > 0) {
            selectedFile = new File(strSelectedFile);
        }
        wallpaperInfo.setFile(selectedFile);
        PredefinedWallpaper predefinedWp = (PredefinedWallpaper)this.listPredefinedWallpapers.getSelectedValue();
        wallpaperInfo.setResource(predefinedWp == null ? null : predefinedWp.getResource());
        wallpaperInfo.setType(typ);
        int alphaInt = (Integer)this.spinnerAlpha.getValue();
        float alpha = (float)alphaInt / 100.0f;
        wallpaperInfo.setAlpha(alpha);
        Color bgColor = this.colorBox.getColorKey();
        wallpaperInfo.setBackgroundColor(bgColor);
        return wallpaperInfo;
    }

    protected void onOK() {
        WallpaperInfo wallpaperInfo = this.createWallpaperInfo();
        if (!this.checkValidate(wallpaperInfo)) {
            return;
        }
        this.wallpaperInfo = wallpaperInfo;
        this.dispose();
    }

    protected void onCancel() {
        this.wallpaperInfo = null;
        this.dispose();
    }

    protected boolean checkValidate(WallpaperInfo wallpaperInfo) {
        String resource;
        String messageid = null;
        WallpaperInfo.WallpaperResourceType typ = wallpaperInfo.getType();
        if (typ == WallpaperInfo.WallpaperResourceType.FILE) {
            File selectedFile = wallpaperInfo.getFile();
            if (selectedFile == null) {
                messageid = "error.require.imageFile";
            } else if (!(selectedFile.exists() && selectedFile.isFile() && selectedFile.canRead())) {
                messageid = "error.invalid.imageFile";
            }
        } else if (typ == WallpaperInfo.WallpaperResourceType.PREDEFINED && ((resource = wallpaperInfo.getResource()) == null || resource.trim().length() == 0)) {
            messageid = "error.require.resource";
        }
        if (messageid != null) {
            Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
            String message = strings.getProperty(messageid);
            JOptionPane.showMessageDialog(this, message, "ERROR", 0);
        }
        return messageid == null;
    }

    public void setWallpaperInfo(WallpaperInfo wallpaperInfo) {
        if (wallpaperInfo == null) {
            wallpaperInfo = new WallpaperInfo();
        }
        this.wallpaperInfo = wallpaperInfo;
    }

    public WallpaperInfo getWallpaperInfo() {
        return this.wallpaperInfo;
    }

    public WallpaperInfo showDialog() {
        this.applyByWallpaperInfo();
        this.setVisible(true);
        return this.wallpaperInfo;
    }
}

