/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.ui.ExportPresetModel;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExportPresetTableModel
extends AbstractTableModelWithComboBoxModel<ExportPresetModel> {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames;
    private static final int[] columnWidths;
    private boolean enabled = true;
    private String defaultPresetId;

    ExportPresetTableModel() {
    }

    public void adjustColumnModel(TableColumnModel columnModel) {
        for (int idx = 0; idx < columnWidths.length; ++idx) {
            columnModel.getColumn(idx).setPreferredWidth(columnWidths[idx]);
        }
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ExportPresetModel presetModel = (ExportPresetModel)this.getRow(rowIndex);
        switch (columnIndex) {
            case 0: {
                return presetModel.isSelected() && this.isEnabled();
            }
            case 1: {
                return presetModel.getPartsSet().getPartsSetId().equals(this.defaultPresetId) && this.isEnabled();
            }
            case 2: {
                return presetModel.getPartsSetName();
            }
            case 3: {
                StringBuilder buf = new StringBuilder();
                for (PartsIdentifier partsIdentifier : presetModel.getMissingPartsIdentifiers()) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(partsIdentifier.getLocalizedPartsName());
                }
                return buf.toString();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ExportPresetModel presetModel = (ExportPresetModel)this.getRow(rowIndex);
        switch (columnIndex) {
            case 0: {
                if (((Boolean)aValue).booleanValue()) {
                    presetModel.setSelected(true);
                    break;
                }
                presetModel.setSelected(false);
                if (!presetModel.getPartsSet().getPartsSetId().equals(this.defaultPresetId)) break;
                this.defaultPresetId = null;
                this.fireTableRowsUpdated(rowIndex, rowIndex);
                return;
            }
            case 1: {
                if (((Boolean)aValue).booleanValue()) {
                    this.defaultPresetId = presetModel.getPartsSet().getPartsSetId();
                    presetModel.setSelected(true);
                    this.fireTableDataChanged();
                    return;
                }
            }
            default: {
                return;
            }
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0 || columnIndex == 1) {
            return this.isEnabled();
        }
        return false;
    }

    public void sort() {
        Collections.sort(this.elements);
        this.fireTableDataChanged();
    }

    public void selectAll() {
        for (ExportPresetModel model : this.elements) {
            model.setSelected(true);
        }
        this.fireTableDataChanged();
    }

    public void deselectAll() {
        for (ExportPresetModel model : this.elements) {
            model.setSelected(false);
        }
        this.fireTableDataChanged();
    }

    public List<PartsSet> getSelectedPresets() {
        ArrayList<PartsSet> partsSets = new ArrayList<PartsSet>();
        for (ExportPresetModel presetModel : this.elements) {
            if (!presetModel.isSelected() || !this.isEnabled()) continue;
            PartsSet partsSet = presetModel.getPartsSet().clone();
            partsSet.setPresetParts(true);
            partsSets.add(partsSet);
        }
        return partsSets;
    }

    public int getSelectedCount() {
        int count = 0;
        for (ExportPresetModel presetModel : this.elements) {
            if (!presetModel.isSelected() || !this.isEnabled()) continue;
            ++count;
        }
        return count;
    }

    public String getDefaultPresetId() {
        return this.defaultPresetId;
    }

    public void setDefaultPresetId(String defaultPresetId) {
        this.defaultPresetId = defaultPresetId;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.fireTableDataChanged();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    static {
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("languages/exportwizdialog");
        columnNames = new String[]{strings.getProperty("preset.column.selected"), strings.getProperty("preset.column.default"), strings.getProperty("preset.column.name"), strings.getProperty("preset.column.missingparts")};
        columnWidths = new int[]{Integer.parseInt(strings.getProperty("preset.column.selected.width")), Integer.parseInt(strings.getProperty("preset.column.default.width")), Integer.parseInt(strings.getProperty("preset.column.name.width")), Integer.parseInt(strings.getProperty("preset.column.missingparts.width"))};
    }
}

