/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PartsIdentifier
implements Serializable,
Comparable<PartsIdentifier> {
    private static final long serialVersionUID = 8943101890389091718L;
    private final PartsCategory partsCategory;
    private final String partsName;
    private final String localizedName;

    public PartsIdentifier(PartsCategory partsCategory, String partsName, String localizedName) {
        if (partsName == null || partsCategory == null) {
            throw new IllegalArgumentException();
        }
        this.partsCategory = partsCategory;
        this.partsName = partsName;
        this.localizedName = localizedName == null || localizedName.trim().length() == 0 ? partsName : localizedName;
    }

    public PartsCategory getPartsCategory() {
        return this.partsCategory;
    }

    public boolean hasLayer(Layer layer) {
        return this.partsCategory.hasLayer(layer);
    }

    public int hashCode() {
        return this.partsName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof PartsIdentifier) {
            return this.partsName.equals(((PartsIdentifier)obj).partsName) && this.partsCategory.isSameCategoryID(((PartsIdentifier)obj).getPartsCategory());
        }
        return false;
    }

    public static boolean equals(PartsIdentifier a, PartsIdentifier b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    @Override
    public int compareTo(PartsIdentifier o) {
        if (o == this) {
            return 0;
        }
        int ret = this.partsCategory.compareTo(o.partsCategory);
        if (ret == 0) {
            ret = this.localizedName.compareTo(o.localizedName);
        }
        if (ret == 0) {
            ret = this.partsName.compareTo(o.partsName);
        }
        return ret;
    }

    public String getPartsName() {
        return this.partsName;
    }

    public String getLocalizedPartsName() {
        return this.localizedName;
    }

    public PartsIdentifier setLocalizedPartsName(String localizedName) {
        if (localizedName == null || localizedName.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        return new PartsIdentifier(this.partsCategory, this.partsName, localizedName);
    }

    public String toString() {
        return this.getLocalizedPartsName();
    }
}

