/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ApplicationLogger;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DesktopUtilities {
    private static final Logger logger = ApplicationLogger.getLogger();
    private static Object desktopObj;
    private static Method methodBrowse;
    private static Method methodEdit;
    private static Method methodOpen;

    private DesktopUtilities() {
        throw new RuntimeException("utilities class.");
    }

    public static boolean isSupported() {
        return desktopObj != null;
    }

    protected static boolean callMethod(Method method, Object arg) throws IOException {
        if (desktopObj == null) {
            return false;
        }
        try {
            method.invoke(desktopObj, arg);
            return true;
        }
        catch (InvocationTargetException ex) {
            Throwable iex = ex.getCause();
            if (iex != null && iex instanceof IOException) {
                throw (IOException)iex;
            }
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static boolean browse(URI uri) throws IOException {
        return DesktopUtilities.callMethod(methodBrowse, uri);
    }

    public static boolean browseBaseDir(URL docBase) throws IOException {
        File baseDir = null;
        try {
            if (docBase != null) {
                baseDir = new File(docBase.getPath()).getParentFile();
            }
        }
        catch (Exception ex) {
            baseDir = null;
        }
        if (baseDir == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return false;
        }
        return DesktopUtilities.open(baseDir);
    }

    public static boolean edit(File file) throws IOException {
        return DesktopUtilities.callMethod(methodEdit, file);
    }

    public static boolean open(File file) throws IOException {
        return DesktopUtilities.callMethod(methodOpen, file);
    }

    static {
        try {
            Class<?> clz = Class.forName("java.awt.Desktop");
            Method mtdGetDesktop = clz.getMethod("getDesktop", new Class[0]);
            methodBrowse = clz.getMethod("browse", URI.class);
            methodEdit = clz.getMethod("edit", File.class);
            methodOpen = clz.getMethod("open", File.class);
            desktopObj = mtdGetDesktop.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.INFO, "AWT Desktop is not suuported.");
            desktopObj = null;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "AWT Desktop failed.", ex);
            desktopObj = null;
        }
    }
}

