/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ApplicationLogger;
import java.awt.Color;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanPropertiesUtilities {
    private static final Logger logger = ApplicationLogger.getLogger();

    private BeanPropertiesUtilities() {
        throw new RuntimeException("utilities class.");
    }

    public static Set<String> loadFromProperties(Object bean, Properties props) {
        if (bean == null || props == null) {
            throw new IllegalArgumentException();
        }
        HashSet<String> rejectNames = new HashSet<String>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor propDesc : beanInfo.getPropertyDescriptors()) {
                String name;
                String strVal;
                Class<?> typ = propDesc.getPropertyType();
                Method mtdReader = propDesc.getReadMethod();
                Method mtdWriter = propDesc.getWriteMethod();
                if (mtdReader == null || mtdWriter == null || (strVal = props.getProperty(name = propDesc.getName())) == null) continue;
                try {
                    Object val;
                    if (String.class.equals(typ)) {
                        val = strVal;
                    } else if (strVal.length() == 0) {
                        val = null;
                    } else if (Boolean.class.equals(typ) || Boolean.TYPE.equals(typ)) {
                        val = Boolean.valueOf(strVal);
                    } else if (Integer.class.equals(typ) || Integer.TYPE.equals(typ)) {
                        val = Integer.valueOf(strVal);
                    } else if (Long.class.equals(typ) || Long.TYPE.equals(typ)) {
                        val = Long.valueOf(strVal);
                    } else if (Float.class.equals(typ) || Float.TYPE.equals(typ)) {
                        val = Float.valueOf(strVal);
                    } else if (Double.class.equals(typ) || Double.TYPE.equals(typ)) {
                        val = Double.valueOf(strVal);
                    } else if (BigInteger.class.equals(typ)) {
                        val = new BigInteger(strVal);
                    } else if (BigDecimal.class.equals(typ)) {
                        val = new BigDecimal(strVal);
                    } else if (Color.class.equals(typ)) {
                        val = Color.decode(strVal);
                    } else {
                        rejectNames.add(name);
                        logger.log(Level.WARNING, "unsupported propery type: " + typ + "/beanClass=" + bean.getClass() + " #" + name);
                        continue;
                    }
                    mtdWriter.invoke(bean, val);
                }
                catch (Exception ex) {
                    rejectNames.add(name);
                    logger.log(Level.WARNING, "invalid propery: " + typ + "/beanClass=" + bean.getClass() + " #" + name + " /val=" + strVal);
                }
            }
        }
        catch (IntrospectionException ex) {
            throw new RuntimeException("bean intorospector failed. :" + bean.getClass(), ex);
        }
        return rejectNames;
    }

    public static void saveToProperties(Object bean, Properties props) {
        if (bean == null || props == null) {
            throw new IllegalArgumentException();
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor propDesc : beanInfo.getPropertyDescriptors()) {
                String strVal;
                Method mtdReader = propDesc.getReadMethod();
                Method mtdWriter = propDesc.getWriteMethod();
                if (mtdReader == null || mtdWriter == null) continue;
                String name = propDesc.getName();
                Object val = mtdReader.invoke(bean, new Object[0]);
                if (val == null) {
                    strVal = "";
                } else if (val instanceof String) {
                    strVal = (String)val;
                } else if (val instanceof Number) {
                    strVal = ((Number)val).toString();
                } else if (val instanceof Boolean) {
                    strVal = (Boolean)val != false ? "true" : "false";
                } else if (val instanceof Color) {
                    strVal = "#" + Integer.toHexString(((Color)val).getRGB() & 0xFFFFFF);
                } else {
                    logger.log(Level.WARNING, "unsupported propery type: " + val.getClass() + "/beanClass=" + bean.getClass() + " #" + name);
                    continue;
                }
                props.setProperty(name, strVal);
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("bean property read failed. :" + bean.getClass(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("bean property read failed. :" + bean.getClass(), ex);
        }
        catch (IntrospectionException ex) {
            throw new RuntimeException("bean intorospector failed. :" + bean.getClass(), ex);
        }
    }
}

