/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.model;

import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsColorManager;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.ui.ImageSelectPanel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartsSelectionManager {
    private HashMap<PartsCategory, ImageSelectPanel> imageSelectPanels = new HashMap();
    private PartsColorManager partsColorMrg;
    private Color imageBgColor = Color.white;
    private double[] affineTransformParameter;

    public void loadParts() {
        for (ImageSelectPanel panel : this.imageSelectPanels.values()) {
            panel.loadParts();
        }
    }

    public PartsSelectionManager(PartsColorManager partsColorMrg) {
        if (partsColorMrg == null) {
            throw new IllegalArgumentException();
        }
        this.partsColorMrg = partsColorMrg;
    }

    public void register(ImageSelectPanel imageSelectPanel) {
        if (imageSelectPanel == null) {
            throw new IllegalArgumentException();
        }
        this.imageSelectPanels.put(imageSelectPanel.getPartsCategory(), imageSelectPanel);
    }

    public List<PartsIdentifier> getSelectedPartsIdentifiers(PartsCategory partsCategory) {
        if (partsCategory == null) {
            throw new IllegalArgumentException();
        }
        ImageSelectPanel panel = this.imageSelectPanels.get(partsCategory);
        if (panel != null) {
            return Collections.unmodifiableList(panel.getSelectedPartsIdentifiers());
        }
        return Collections.emptyList();
    }

    public PartsIdentifier getSelectedPartsIdentifier(PartsCategory partsCategory) {
        if (partsCategory == null) {
            throw new IllegalArgumentException();
        }
        ImageSelectPanel panel = this.imageSelectPanels.get(partsCategory);
        if (panel != null) {
            return panel.getSelectedPartsIdentifier();
        }
        return null;
    }

    public Collection<PartsCategory> getAllCategories() {
        ArrayList<PartsCategory> partsCategories = new ArrayList<PartsCategory>();
        partsCategories.addAll(this.imageSelectPanels.keySet());
        return partsCategories;
    }

    public void selectPartsSet(PartsSet partsSet) {
        if (partsSet == null) {
            throw new IllegalArgumentException();
        }
        for (ImageSelectPanel panel : this.imageSelectPanels.values()) {
            PartsCategory partsCategory = panel.getPartsCategory();
            List partsIdentifiers = (List)partsSet.get(partsCategory);
            panel.selectParts(partsIdentifiers);
            if (partsIdentifiers == null) continue;
            for (PartsIdentifier partsIdentifier : partsIdentifiers) {
                PartsColorInfo partsColorInfo = partsSet.getColorInfo(partsIdentifier);
                if (partsColorInfo == null) continue;
                this.partsColorMrg.setPartsColorInfo(partsIdentifier, partsColorInfo, false);
            }
        }
        Color bgColor = partsSet.getBgColor();
        if (bgColor != null) {
            this.imageBgColor = bgColor;
        }
        this.affineTransformParameter = partsSet.getAffineTransformParameter();
    }

    public PartsSet createPartsSet() {
        PartsSet presetParts = new PartsSet();
        for (ImageSelectPanel imageSelectPanel : this.imageSelectPanels.values()) {
            PartsCategory category = imageSelectPanel.getPartsCategory();
            for (PartsIdentifier partsIdentifier : imageSelectPanel.getSelectedPartsIdentifiers()) {
                PartsColorInfo partsColorInfo = this.partsColorMrg.getPartsColorInfo(partsIdentifier, false);
                presetParts.appendParts(category, partsIdentifier, partsColorInfo);
            }
        }
        presetParts.setBgColor(this.imageBgColor);
        presetParts.setAffineTransformParameter(this.affineTransformParameter);
        return presetParts;
    }

    public void scrollToSelectedParts() {
        for (ImageSelectPanel imageSelectPanel : this.imageSelectPanels.values()) {
            imageSelectPanel.scrollToSelectedRow();
        }
    }

    public void setSelection(PartsIdentifier partsIdentifier) {
        if (partsIdentifier == null) {
            return;
        }
        PartsCategory partsCategory = partsIdentifier.getPartsCategory();
        ImageSelectPanel imageSelectPanel = this.imageSelectPanels.get(partsCategory);
        if (imageSelectPanel != null) {
            imageSelectPanel.setSelection(partsIdentifier);
        }
    }

    public Color getImageBgColor() {
        return this.imageBgColor;
    }

    public void setImageBgColor(Color imageBgColor) {
        if (imageBgColor == null) {
            imageBgColor = Color.white;
        }
        this.imageBgColor = imageBgColor;
    }

    public double[] getAffineTransformParameter() {
        return this.affineTransformParameter == null ? null : (double[])this.affineTransformParameter.clone();
    }

    public void setAffineTransformParameter(double[] affineTransformParameter) {
        if (affineTransformParameter != null && affineTransformParameter.length != 4 && affineTransformParameter.length != 6) {
            throw new IllegalArgumentException("affineTransformParameter invalid length.");
        }
        this.affineTransformParameter = affineTransformParameter == null ? null : (double[])affineTransformParameter.clone();
    }
}

