/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.ui.PartsSelectRow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PartsSelectListModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7604828023134579608L;
    private PartsCategory partsCategory;
    private ArrayList<PartsSelectRow> partsSelectRowList;

    public PartsSelectListModel(PartsCategory partsCategory) {
        if (partsCategory == null) {
            throw new IllegalArgumentException();
        }
        this.partsSelectRowList = new ArrayList();
        this.partsCategory = partsCategory;
    }

    public void load(Collection<PartsIdentifier> partsIdentifiers) {
        if (partsIdentifiers == null) {
            throw new IllegalArgumentException();
        }
        HashMap<PartsIdentifier, Integer> selectedPartsIdentifiers = new HashMap<PartsIdentifier, Integer>();
        for (PartsIdentifier partsIdentifier : this.getSelectedPartsIdentifiers()) {
            selectedPartsIdentifiers.put(partsIdentifier, selectedPartsIdentifiers.size());
        }
        ArrayList<PartsSelectRow> partsSelectList = new ArrayList<PartsSelectRow>();
        Iterator<PartsIdentifier> i$ = partsIdentifiers.iterator();
        while (i$.hasNext()) {
            PartsIdentifier partsIdentifier;
            Integer selIndex = (Integer)selectedPartsIdentifiers.get(partsIdentifier = i$.next());
            PartsSelectRow rowModel = new PartsSelectRow(partsIdentifier, selIndex != null);
            int order = selIndex != null ? selIndex : 0;
            rowModel.setDisplayOrder(order);
            partsSelectList.add(rowModel);
        }
        if (this.partsCategory.isMultipleSelectable()) {
            Collections.sort(partsSelectList);
        } else {
            Collections.sort(partsSelectList, new Comparator<PartsSelectRow>(){

                @Override
                public int compare(PartsSelectRow o1, PartsSelectRow o2) {
                    return o1.getPartsIdentifier().compareTo(o2.getPartsIdentifier());
                }
            });
        }
        this.partsSelectRowList = partsSelectList;
        this.fireTableDataChanged();
    }

    public PartsSelectRow getRow(int rowIndex) {
        return this.partsSelectRowList.get(rowIndex);
    }

    public ArrayList<PartsSelectRow> getRowModelList() {
        return this.partsSelectRowList;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.partsSelectRowList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PartsSelectRow rowModel = this.partsSelectRowList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return rowModel.isChecked();
            }
            case 1: {
                return rowModel.getPartsName();
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 0) {
            return;
        }
        PartsSelectRow rowModel = this.partsSelectRowList.get(rowIndex);
        boolean checked = (Boolean)aValue;
        if (!checked && rowModel.isChecked() && !this.partsCategory.isMultipleSelectable()) {
            return;
        }
        rowModel.setChecked(checked);
        boolean unchecked = false;
        if (checked && !this.partsCategory.isMultipleSelectable()) {
            int mx = this.partsSelectRowList.size();
            for (int idx = 0; idx < mx; ++idx) {
                PartsSelectRow otherRow;
                if (idx == rowIndex || !(otherRow = this.partsSelectRowList.get(idx)).isChecked()) continue;
                otherRow.setChecked(false);
                unchecked = true;
            }
        }
        if (!unchecked) {
            this.fireTableCellUpdated(rowIndex, columnIndex);
        } else {
            this.fireTableDataChanged();
        }
    }

    public void sort() {
        int mx = this.partsSelectRowList.size();
        for (int idx = 0; idx < mx; ++idx) {
            this.partsSelectRowList.get(idx).setDisplayOrder(idx);
        }
        Collections.sort(this.partsSelectRowList);
        this.fireTableDataChanged();
    }

    public List<PartsIdentifier> getSelectedPartsIdentifiers() {
        ArrayList<PartsIdentifier> selectedRows = new ArrayList<PartsIdentifier>();
        for (PartsSelectRow rowModel : this.partsSelectRowList) {
            if (!rowModel.isChecked()) continue;
            selectedRows.add(rowModel.getPartsIdentifier());
        }
        return selectedRows;
    }

    public boolean[] getChecks(int[] rowIndexes) {
        if (rowIndexes == null) {
            rowIndexes = new int[]{};
        }
        int mx = rowIndexes.length;
        boolean[] results = new boolean[mx];
        for (int idx = 0; idx < mx; ++idx) {
            int rowIndex = rowIndexes[idx];
            PartsSelectRow row = this.partsSelectRowList.get(rowIndex);
            results[idx] = row.isChecked();
        }
        return results;
    }

    public void setChecks(boolean checked, int[] selectedRows) {
        int idx;
        PartsSelectRow row;
        if (selectedRows == null || selectedRows.length == 0) {
            return;
        }
        ArrayList<Integer> affectRows = new ArrayList<Integer>();
        if (!checked) {
            if (!this.partsCategory.isMultipleSelectable()) {
                return;
            }
            for (int selRow : selectedRows) {
                row = this.partsSelectRowList.get(selRow);
                if (!row.isChecked()) continue;
                row.setChecked(false);
                affectRows.add(selRow);
            }
        } else if (this.partsCategory.isMultipleSelectable()) {
            for (int selRow : selectedRows) {
                row = this.partsSelectRowList.get(selRow);
                if (row.isChecked()) continue;
                row.setChecked(true);
                affectRows.add(selRow);
            }
        } else {
            int selRow = selectedRows[0];
            PartsSelectRow row2 = this.partsSelectRowList.get(selRow);
            if (!row2.isChecked()) {
                row2.setChecked(true);
                affectRows.add(selRow);
                int mx = this.partsSelectRowList.size();
                for (idx = 0; idx < mx; ++idx) {
                    PartsSelectRow otherRow = this.partsSelectRowList.get(idx);
                    if (idx == selRow || !otherRow.isChecked()) continue;
                    otherRow.setChecked(false);
                    affectRows.add(idx);
                }
            }
        }
        if (affectRows.isEmpty()) {
            return;
        }
        int minIdx = 0;
        int maxIdx = 0;
        Iterator i$ = affectRows.iterator();
        while (i$.hasNext()) {
            idx = (Integer)i$.next();
            minIdx = Math.min(minIdx, idx);
            maxIdx = Math.max(maxIdx, idx);
        }
        this.fireTableRowsUpdated(minIdx, maxIdx);
    }
}

