/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.ui.MainFrame;
import charactermanaj.util.ApplicationLogger;
import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import java.awt.Image;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MainFramePartialForMacOSX {
    private static final Logger logger = ApplicationLogger.getLogger();

    private MainFramePartialForMacOSX() {
    }

    public static void setupScreenMenu(MainFrame mainFrame) {
        if (mainFrame == null) {
            throw new IllegalArgumentException();
        }
        Application app = Application.getApplication();
        app.setEnabledAboutMenu(true);
        app.setEnabledPreferencesMenu(true);
        ApplicationAdapter listener = new ApplicationAdapter(){

            public void handleAbout(ApplicationEvent arg0) {
                if (MainFrame.activedMainFrame != null) {
                    MainFrame.activedMainFrame.onAbout();
                }
                arg0.setHandled(true);
            }

            public void handleQuit(ApplicationEvent arg0) {
                if (MainFrame.activedMainFrame != null) {
                    MainFrame.closeAllProfiles();
                }
                arg0.setHandled(true);
                System.exit(0);
            }

            public void handlePreferences(ApplicationEvent arg0) {
                if (MainFrame.activedMainFrame != null) {
                    MainFrame.activedMainFrame.onPreferences();
                }
                arg0.setHandled(true);
            }
        };
        app.addApplicationListener((ApplicationListener)listener);
        try {
            Class<?> clz = app.getClass();
            Method mtd = clz.getMethod("setDockIconImage", Image.class);
            mtd.invoke((Object)app, mainFrame.icon);
        }
        catch (NoSuchMethodException ex) {
            logger.log(Level.INFO, "dockIcon not supported.", ex);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "dockIcon failed.", ex);
        }
    }
}

