/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.io.AbstractCharacterDataArchiveFile;
import charactermanaj.ui.ImportWizardCardPanel;
import charactermanaj.ui.ImportWizardDialog;
import charactermanaj.ui.SamplePicturePanel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class ImportTypeSelectPanel
extends ImportWizardCardPanel {
    private static final long serialVersionUID = 1L;
    public static final String PANEL_NAME = "importTypeSelectPanel";
    private SamplePicturePanel samplePicturePanel;
    private JTextField txtCharacterId;
    private JTextField txtCharacterRev;
    private JTextField txtCharacterName;
    private JTextField txtAuthor;
    private JTextArea txtDescription;
    private JCheckBox chkCharacterDef;
    private JCheckBox chkPartsImages;
    private JCheckBox chkPresets;
    private JCheckBox chkSampleImage;
    private JCheckBox chkExportSubset;
    private JCheckBox chkAddDescription;
    private String additionalDescription;
    private boolean noContents;

    public ImportTypeSelectPanel() {
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/importwizdialog");
        GridBagLayout basicPanelLayout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(basicPanelLayout);
        JPanel contentsSpecPanel = new JPanel();
        contentsSpecPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(strings.getProperty("basic.contentsSpec"))));
        BoxLayout contentsSpecPanelLayout = new BoxLayout(contentsSpecPanel, 3);
        contentsSpecPanel.setLayout(contentsSpecPanelLayout);
        this.chkCharacterDef = new JCheckBox(strings.getProperty("characterdef"));
        this.chkPartsImages = new JCheckBox(strings.getProperty("basic.chk.partsImages"));
        this.chkPresets = new JCheckBox(strings.getProperty("basic.chk.presets"));
        this.chkSampleImage = new JCheckBox(strings.getProperty("basic.chk.samplePicture"));
        contentsSpecPanel.add(this.chkCharacterDef);
        contentsSpecPanel.add(this.chkPartsImages);
        contentsSpecPanel.add(this.chkPresets);
        contentsSpecPanel.add(this.chkSampleImage);
        JPanel archiveInfoPanel = new JPanel();
        archiveInfoPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(strings.getProperty("basic.archiveInfo"))));
        Dimension archiveInfoPanelMinSize = new Dimension(300, 200);
        archiveInfoPanel.setMinimumSize(archiveInfoPanelMinSize);
        archiveInfoPanel.setPreferredSize(archiveInfoPanelMinSize);
        GridBagLayout commentPanelLayout = new GridBagLayout();
        archiveInfoPanel.setLayout(commentPanelLayout);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.anchor = 17;
        gbc.fill = 1;
        this.chkExportSubset = new JCheckBox(strings.getProperty("exportSubset"));
        this.chkExportSubset.setEnabled(false);
        archiveInfoPanel.add((Component)this.chkExportSubset, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        archiveInfoPanel.add((Component)new JLabel(strings.getProperty("basic.profileId"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.txtCharacterId = new JTextField();
        this.txtCharacterId.setEditable(false);
        archiveInfoPanel.add((Component)this.txtCharacterId, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        archiveInfoPanel.add((Component)new JLabel(strings.getProperty("basic.profileRev"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.txtCharacterRev = new JTextField();
        this.txtCharacterRev.setEditable(false);
        archiveInfoPanel.add((Component)this.txtCharacterRev, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        archiveInfoPanel.add((Component)new JLabel(strings.getProperty("basic.profileName"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.txtCharacterName = new JTextField();
        this.txtCharacterName.setEditable(false);
        archiveInfoPanel.add((Component)this.txtCharacterName, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        archiveInfoPanel.add((Component)new JLabel(strings.getProperty("author"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.txtAuthor = new JTextField();
        this.txtAuthor.setEditable(false);
        archiveInfoPanel.add((Component)this.txtAuthor, gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        archiveInfoPanel.add((Component)new JLabel(strings.getProperty("description"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.gridheight = 5;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.txtDescription = new JTextArea();
        this.txtDescription.setFont(this.getFont());
        archiveInfoPanel.add((Component)new JScrollPane(this.txtDescription), gbc);
        gbc.gridx = 0;
        gbc.gridy = 10;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.chkAddDescription = new JCheckBox(strings.getProperty("appendDescription"));
        archiveInfoPanel.add((Component)this.chkAddDescription, gbc);
        this.samplePicturePanel = new SamplePicturePanel();
        JScrollPane samplePicturePanelSP = new JScrollPane(this.samplePicturePanel);
        samplePicturePanelSP.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(strings.getProperty("basic.sampleImage"))));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        this.add((Component)contentsSpecPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        this.add((Component)archiveInfoPanel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        this.add((Component)samplePicturePanelSP, gbc);
        ActionListener modListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportTypeSelectPanel.this.fireChangeEvent();
            }
        };
        this.chkCharacterDef.addActionListener(modListener);
        this.chkPartsImages.addActionListener(modListener);
        this.chkPresets.addActionListener(modListener);
        this.chkSampleImage.addActionListener(modListener);
        this.chkAddDescription.addActionListener(modListener);
    }

    public void onActive(ImportWizardDialog parent, ImportWizardCardPanel previousPanel) {
        if (previousPanel == parent.importPartsSelectPanel) {
            return;
        }
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/importwizdialog");
        Collection<CharacterData> profiles = parent.profiles;
        CharacterData current = parent.current;
        CharacterData cd = parent.fileSelectPanel.getCharacterData();
        Properties exportInfoProp = parent.fileSelectPanel.getExportInfoProp();
        boolean partsFlag = true;
        String readme = null;
        boolean updatable = current != null && current.isValid();
        boolean creatable = profiles != null && cd != null && cd.isValid();
        boolean matchID = false;
        boolean matchREV = false;
        if (cd != null && cd.isValid()) {
            boolean subsetFlag = true;
            boolean presetFlag = false;
            partsFlag = false;
            if (exportInfoProp != null) {
                subsetFlag = Boolean.parseBoolean(exportInfoProp.getProperty("EXPORT_SUBSET"));
                presetFlag = Boolean.parseBoolean(exportInfoProp.getProperty("EXPORT_PRESETS"));
                partsFlag = Boolean.parseBoolean(exportInfoProp.getProperty("EXPORT_PARTS_IMAGES"));
            }
            if (!updatable) {
                this.chkCharacterDef.setEnabled(false);
                this.chkCharacterDef.setSelected(!subsetFlag && creatable);
            } else {
                this.chkCharacterDef.setEnabled(!subsetFlag && creatable);
                this.chkCharacterDef.setSelected(false);
            }
            this.chkPresets.setEnabled(presetFlag && (updatable || creatable));
            this.chkPresets.setSelected(presetFlag);
            this.txtCharacterId.setText(cd.getId());
            this.txtCharacterRev.setText(cd.getRev());
            this.txtCharacterName.setText(cd.getName());
            if (current != null) {
                boolean bl = current.getId() == null ? cd.getId() == null : (matchID = current.getId().equals(cd.getId()));
                matchREV = current.getRev() == null ? cd.getRev() == null : current.getRev().equals(cd.getRev());
            } else {
                matchID = true;
                matchREV = true;
            }
            AppConfig appConfig = AppConfig.getInstance();
            Color invalidBgColor = appConfig.getInvalidBgColor();
            this.txtCharacterId.setBackground(matchID ? this.getBackground() : invalidBgColor);
            this.txtCharacterRev.setBackground(matchREV ? this.getBackground() : invalidBgColor);
            this.txtAuthor.setText(cd.getAuthor());
            readme = cd.getDescription();
            this.chkExportSubset.setSelected(subsetFlag);
        } else {
            this.chkCharacterDef.setEnabled(false);
            this.chkCharacterDef.setSelected(false);
            this.chkPresets.setEnabled(false);
            this.chkPresets.setSelected(false);
            this.txtCharacterId.setText("");
            this.txtCharacterRev.setText("");
            this.txtCharacterName.setText("");
            this.txtAuthor.setText("");
            readme = parent.fileSelectPanel.getReadme();
            this.chkExportSubset.setSelected(true);
        }
        boolean existsReadme = readme != null && readme.trim().length() > 0;
        this.additionalDescription = existsReadme ? readme : "";
        this.txtDescription.setText(this.additionalDescription);
        this.chkAddDescription.setEnabled((updatable || creatable) && existsReadme);
        this.chkAddDescription.setSelected((updatable || creatable) && existsReadme);
        Collection<AbstractCharacterDataArchiveFile.PartsImageContent> partsImageContentsMapForCur = parent.fileSelectPanel.getPartsImageContentsForCurrentProfile();
        Collection<AbstractCharacterDataArchiveFile.PartsImageContent> partsImageContentsMapForNew = parent.fileSelectPanel.getPartsImageContentsForNewProfile();
        if (!(partsFlag && (updatable && !partsImageContentsMapForCur.isEmpty() || creatable && !partsImageContentsMapForNew.isEmpty()) && (updatable || creatable))) {
            this.chkPartsImages.setEnabled(false);
            this.chkPartsImages.setSelected(false);
        } else {
            this.chkPartsImages.setEnabled(true);
            this.chkPartsImages.setSelected(true);
        }
        BufferedImage samplePicture = parent.fileSelectPanel.getSamplePicture();
        if (samplePicture != null && (updatable || creatable)) {
            this.samplePicturePanel.setSamplePicture(samplePicture);
            this.chkSampleImage.setEnabled(true);
            this.chkSampleImage.setSelected(false);
        } else {
            this.samplePicturePanel.setSamplePicture(samplePicture);
            this.chkSampleImage.setEnabled(false);
            this.chkSampleImage.setSelected(false);
        }
        boolean bl = this.noContents = !this.chkCharacterDef.isEnabled() && !this.chkPartsImages.isEnabled() && !this.chkPresets.isEnabled() && !this.chkSampleImage.isEnabled();
        if (this.noContents) {
            JOptionPane.showMessageDialog(this, strings.getProperty("noContents"));
        } else if (cd == null) {
            JOptionPane.showMessageDialog(this, strings.getProperty("notFormalArchive"));
        } else if (!matchID) {
            JOptionPane.showMessageDialog(this, strings.getProperty("unmatchedProfileId"));
        } else if (!matchREV) {
            JOptionPane.showMessageDialog(this, strings.getProperty("unmatchedProfileRev"));
        }
    }

    public boolean isNewProfile() {
        return this.chkCharacterDef.isSelected();
    }

    public boolean isImportPreset() {
        return this.chkPresets.isSelected();
    }

    public boolean isImportPartsImages() {
        return this.chkPartsImages.isSelected();
    }

    public boolean isImportSampleImage() {
        return this.chkSampleImage.isSelected();
    }

    public boolean isAddDescription() {
        return this.chkAddDescription.isSelected();
    }

    public String getAdditionalDescription() {
        return this.txtDescription.getText();
    }

    public boolean isReadyPrevious() {
        return true;
    }

    public String doPrevious() {
        return "fileSelectPanel";
    }

    public boolean isReadyNext() {
        return this.isImportPartsImages() || this.isImportPreset();
    }

    public boolean isReadyFinish() {
        return !this.isImportPartsImages() && !this.isImportPreset() && (this.isNewProfile() || this.isImportSampleImage());
    }

    public String doNext() {
        return "importPartsSelectPanel";
    }
}

