/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsManageData;
import charactermanaj.model.io.AbstractCharacterDataArchiveFile;
import charactermanaj.model.io.CharacterDataArchiveFile;
import charactermanaj.model.io.CharacterDataFileReaderWriterFactory;
import charactermanaj.ui.ArchiveFileDialog;
import charactermanaj.ui.ImportWizardCardPanel;
import charactermanaj.ui.ImportWizardDialog;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImportFileSelectPanel
extends ImportWizardCardPanel {
    private static final long serialVersionUID = 1L;
    public static final String PANEL_NAME = "fileSelectPanel";
    private static ArchiveFileDialog archiveFileDialog = new ArchiveFileDialog();
    private ImportWizardDialog parent;
    private JTextField txtFile;
    private File file;
    private CharacterDataArchiveFile archiveFile;
    private CharacterData characterData;
    private BufferedImage samplePicture;
    private String readme;
    private Properties exportInfoProp;
    private Collection<AbstractCharacterDataArchiveFile.PartsImageContent> partsImageContentsMapForCurrentProfile;
    private Collection<AbstractCharacterDataArchiveFile.PartsImageContent> partsImageContentsMapForNewProfile;
    private PartsManageData partsManageData;

    public ImportFileSelectPanel() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/importwizdialog");
        GridBagConstraints gbc = new GridBagConstraints();
        this.txtFile = new JTextField();
        this.txtFile.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                this.fireEvent();
            }

            public void insertUpdate(DocumentEvent e) {
                this.fireEvent();
            }

            public void changedUpdate(DocumentEvent e) {
                this.fireEvent();
            }

            protected void fireEvent() {
                ImportFileSelectPanel.this.fireChangeEvent();
            }
        });
        AbstractAction actChooseFile = new AbstractAction(strings.getProperty("browse")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ImportFileSelectPanel.this.onChooseFile();
            }
        };
        JPanel fileChoosePanel = new JPanel(new BorderLayout(3, 3));
        fileChoosePanel.setBorder(BorderFactory.createTitledBorder(strings.getProperty("importingArchiveFile")));
        fileChoosePanel.add((Component)new JLabel(strings.getProperty("file"), 4), "West");
        fileChoosePanel.add((Component)this.txtFile, "Center");
        fileChoosePanel.add((Component)new JButton(actChooseFile), "East");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.anchor = 17;
        gbc.fill = 1;
        this.add((Component)fileChoosePanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(Box.createVerticalGlue(), gbc);
    }

    protected void onChooseFile() {
        File file;
        File initFile = null;
        if (this.txtFile.getText().trim().length() > 0) {
            initFile = new File(this.txtFile.getText());
        }
        if ((file = archiveFileDialog.showOpenDialog(this, initFile)) != null) {
            this.txtFile.setText(file.getPath());
            this.fireChangeEvent();
        }
    }

    @Override
    public boolean isReadyNext() {
        String fileTxt = this.txtFile.getText();
        return fileTxt != null && fileTxt.trim().length() > 0;
    }

    @Override
    public void onActive(ImportWizardDialog parent, ImportWizardCardPanel previousPanel) {
        this.parent = parent;
        this.closeArchive();
        this.file = null;
        this.archiveFile = null;
        this.characterData = null;
        this.exportInfoProp = null;
        this.samplePicture = null;
        this.readme = null;
        this.partsImageContentsMapForCurrentProfile = null;
        this.partsImageContentsMapForNewProfile = null;
        this.partsManageData = null;
    }

    public void closeArchive() {
        if (this.archiveFile != null) {
            try {
                this.archiveFile.close();
            }
            catch (IOException ex) {
                ErrorMessageHelper.showErrorDialog(this, ex);
            }
            this.archiveFile = null;
        }
    }

    @Override
    public String doNext() {
        if (!this.isReadyNext()) {
            return null;
        }
        File file = new File(this.txtFile.getText());
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u304c\u3042\u308a\u307e\u305b\u3093\u3002", "ERROR", 0);
            return null;
        }
        try {
            CharacterDataFileReaderWriterFactory factory = CharacterDataFileReaderWriterFactory.getInstance();
            this.file = file;
            this.archiveFile = factory.openArchive(file);
            this.readme = this.archiveFile.readReadMe();
            this.characterData = this.archiveFile.readCharacterData();
            if (this.characterData == null) {
                this.characterData = this.archiveFile.readCharacterINI();
                if (this.characterData != null) {
                    this.exportInfoProp = new Properties();
                    this.exportInfoProp.setProperty("EXPORT_SUBSET", "false");
                    this.exportInfoProp.setProperty("EXPORT_PRESETS", "true");
                    this.exportInfoProp.setProperty("EXPORT_PARTS_IMAGES", "true");
                    if (this.readme != null && this.readme.trim().length() > 0) {
                        this.characterData.setDescription(this.readme);
                    }
                } else {
                    this.exportInfoProp = null;
                }
            } else {
                this.exportInfoProp = this.archiveFile.readExportProp();
            }
            this.samplePicture = this.archiveFile.readSamplePicture();
            this.partsImageContentsMapForCurrentProfile = this.archiveFile.getPartsImageContents(this.parent.current);
            this.partsImageContentsMapForNewProfile = this.archiveFile.getPartsImageContents(this.characterData);
            this.partsManageData = this.archiveFile.getPartsManageData();
            return "importTypeSelectPanel";
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
            return null;
        }
    }

    public File getFile() {
        return this.file;
    }

    public CharacterDataArchiveFile getArchiveFile() {
        return this.archiveFile;
    }

    public CharacterData getCharacterData() {
        return this.characterData;
    }

    public BufferedImage getSamplePicture() {
        return this.samplePicture;
    }

    public String getReadme() {
        return this.readme;
    }

    public Properties getExportInfoProp() {
        return this.exportInfoProp;
    }

    public Collection<AbstractCharacterDataArchiveFile.PartsImageContent> getPartsImageContentsForCurrentProfile() {
        return this.partsImageContentsMapForCurrentProfile;
    }

    public Collection<AbstractCharacterDataArchiveFile.PartsImageContent> getPartsImageContentsForNewProfile() {
        return this.partsImageContentsMapForNewProfile;
    }

    public PartsManageData getPartsManageData() {
        return this.partsManageData;
    }
}

