/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.PartsSpec;
import charactermanaj.ui.ExportPartsSelectModel;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExportPartsTableModel
extends AbstractTableModelWithComboBoxModel<ExportPartsSelectModel> {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames;
    private static final int[] columnWidths;
    private boolean enabled = true;

    ExportPartsTableModel() {
    }

    public void adjustColumnModel(TableColumnModel columnModel) {
        for (int idx = 0; idx < columnWidths.length; ++idx) {
            columnModel.getColumn(idx).setPreferredWidth(columnWidths[idx]);
        }
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ExportPartsSelectModel partsSelectModel = (ExportPartsSelectModel)this.getRow(rowIndex);
        switch (columnIndex) {
            case 0: {
                return partsSelectModel.isChecked() && this.enabled;
            }
            case 1: {
                return partsSelectModel.getPartsCategory().getLocalizedCategoryName();
            }
            case 2: {
                return partsSelectModel.getPartsName();
            }
            case 3: {
                Timestamp tm = partsSelectModel.getTimestamp();
                if (tm != null) {
                    return tm.toString();
                }
                return "";
            }
            case 4: {
                return partsSelectModel.getAuthor();
            }
            case 5: {
                return partsSelectModel.getVersion();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ExportPartsSelectModel partsSelectModel = (ExportPartsSelectModel)this.getRow(rowIndex);
        switch (columnIndex) {
            case 0: {
                partsSelectModel.setChecked((Boolean)aValue);
                break;
            }
            default: {
                return;
            }
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.isEnabled();
        }
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        return String.class;
    }

    public void sort() {
        Collections.sort(this.elements);
        this.fireTableDataChanged();
    }

    public void sortByTimestamp() {
        Collections.sort(this.elements, new Comparator<ExportPartsSelectModel>(){

            @Override
            public int compare(ExportPartsSelectModel o1, ExportPartsSelectModel o2) {
                int ret = 0;
                Timestamp t1 = o1.getTimestamp();
                Timestamp t2 = o2.getTimestamp();
                ret = t1 == null || t2 == null ? (t1 == null && t2 == null ? 0 : (t1 == null ? 1 : -1)) : t2.compareTo(t1);
                if (ret == 0) {
                    ret = o1.compareTo(o2);
                }
                return ret;
            }
        });
        this.fireTableDataChanged();
    }

    public void selectAll() {
        for (ExportPartsSelectModel model : this.elements) {
            model.setChecked(true);
        }
        this.fireTableDataChanged();
    }

    public void deselectAll() {
        for (ExportPartsSelectModel model : this.elements) {
            model.setChecked(false);
        }
        this.fireTableDataChanged();
    }

    public Map<PartsIdentifier, PartsSpec> getSelectedParts() {
        HashMap<PartsIdentifier, PartsSpec> selectedPartsMap = new HashMap<PartsIdentifier, PartsSpec>();
        for (ExportPartsSelectModel partsSelectModel : this.elements) {
            if (!partsSelectModel.isChecked() || !this.isEnabled()) continue;
            selectedPartsMap.put(partsSelectModel.getPartsIdentifier(), partsSelectModel.getPartsSpec());
        }
        return selectedPartsMap;
    }

    public Map<PartsSet, List<PartsIdentifier>> checkMissingPartsList(Collection<PartsSet> partsSets) {
        if (partsSets == null) {
            throw new IllegalArgumentException();
        }
        Map<PartsIdentifier, PartsSpec> selectedPartsMap = this.getSelectedParts();
        HashMap<PartsSet, List<PartsIdentifier>> missingPartsMap = new HashMap<PartsSet, List<PartsIdentifier>>();
        for (PartsSet partsSet : partsSets) {
            ArrayList<PartsIdentifier> missingPartss = new ArrayList<PartsIdentifier>();
            for (PartsCategory partsCategory : partsSet.keySet()) {
                for (PartsIdentifier requirePartsIdentifier : (List)partsSet.get(partsCategory)) {
                    if (selectedPartsMap.containsKey(requirePartsIdentifier)) continue;
                    missingPartss.add(requirePartsIdentifier);
                }
            }
            Collections.sort(missingPartss);
            missingPartsMap.put(partsSet, missingPartss);
        }
        return missingPartsMap;
    }

    public void selectByPartsSet(Collection<PartsSet> partsSets) {
        if (partsSets == null) {
            throw new IllegalArgumentException();
        }
        HashSet<PartsIdentifier> requirePartsIdentifiers = new HashSet<PartsIdentifier>();
        for (PartsSet partsSet : partsSets) {
            for (PartsCategory partsCategory : partsSet.keySet()) {
                for (PartsIdentifier partsIdentifier : (List)partsSet.get(partsCategory)) {
                    requirePartsIdentifiers.add(partsIdentifier);
                }
            }
        }
        for (ExportPartsSelectModel partsSelectModel : this.elements) {
            if (!requirePartsIdentifiers.contains(partsSelectModel.getPartsIdentifier())) continue;
            partsSelectModel.setChecked(true);
        }
        this.fireTableDataChanged();
    }

    public int getSelectedCount() {
        int count = 0;
        for (ExportPartsSelectModel partsSelectModel : this.elements) {
            if (!partsSelectModel.isChecked() || !this.isEnabled()) continue;
            ++count;
        }
        return count;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.fireTableDataChanged();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setCheck(int[] selRows, boolean checked) {
        if (selRows == null || selRows.length == 0) {
            return;
        }
        Arrays.sort(selRows);
        for (int selRow : selRows) {
            ExportPartsSelectModel rowModel = (ExportPartsSelectModel)this.getRow(selRow);
            rowModel.setChecked(checked);
        }
        this.fireTableRowsUpdated(selRows[0], selRows[selRows.length - 1]);
    }

    static {
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/exportwizdialog");
        columnNames = new String[]{strings.getProperty("parts.column.selected"), strings.getProperty("parts.column.category"), strings.getProperty("parts.column.name"), strings.getProperty("parts.column.timestamp"), strings.getProperty("parts.column.author"), strings.getProperty("parts.column.version")};
        columnWidths = new int[]{Integer.parseInt(strings.getProperty("parts.column.selected.width")), Integer.parseInt(strings.getProperty("parts.column.category.width")), Integer.parseInt(strings.getProperty("parts.column.name.width")), Integer.parseInt(strings.getProperty("parts.column.timestamp.width")), Integer.parseInt(strings.getProperty("parts.column.author.width")), Integer.parseInt(strings.getProperty("parts.column.version.width"))};
    }
}

