/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CategoriesTableRow
implements Comparable<CategoriesTableRow> {
    private int order;
    private String categoryId;
    private String localizedCategoryName;
    private boolean multipleSelectable;
    private int visibleRows;
    private ArrayList<Layer> layers = new ArrayList();

    public CategoriesTableRow(int order, String categoryId, String localizedCategoryName, boolean multipleSelectable, int visibleRows, Layer[] layers) {
        if (categoryId == null || categoryId.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        if (layers == null) {
            layers = new Layer[]{};
        }
        if (localizedCategoryName == null || localizedCategoryName.trim().length() == 0) {
            localizedCategoryName = categoryId;
        }
        this.order = order;
        this.categoryId = categoryId.trim();
        this.localizedCategoryName = localizedCategoryName.trim();
        this.multipleSelectable = multipleSelectable;
        this.layers.addAll(Arrays.asList(layers));
        this.visibleRows = visibleRows;
    }

    public CategoriesTableRow(PartsCategory partsCategory) {
        if (partsCategory == null) {
            throw new IllegalArgumentException();
        }
        this.order = partsCategory.getOrder();
        this.categoryId = partsCategory.getCategoryId();
        this.localizedCategoryName = partsCategory.getLocalizedCategoryName();
        this.multipleSelectable = partsCategory.isMultipleSelectable();
        this.layers.addAll(partsCategory.getLayers());
        this.visibleRows = partsCategory.getVisibleRows();
    }

    public PartsCategory convert() {
        return new PartsCategory(this.order, this.categoryId, this.localizedCategoryName, this.multipleSelectable, this.visibleRows, this.layers.toArray(new Layer[this.layers.size()]));
    }

    @Override
    public int compareTo(CategoriesTableRow o) {
        int ret = this.order - o.getOrder();
        if (ret == 0) {
            ret = this.localizedCategoryName.compareTo(this.localizedCategoryName);
        }
        if (ret == 0) {
            ret = this.categoryId.compareTo(o.getCategoryId());
        }
        return ret;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof CategoriesTableRow) {
            return this.categoryId.equals(((CategoriesTableRow)obj).getCategoryId());
        }
        return false;
    }

    public static boolean equals(CategoriesTableRow o1, CategoriesTableRow o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isMultipleSelectable() {
        return this.multipleSelectable;
    }

    public void setMultipleSelectable(boolean multipleSelectable) {
        this.multipleSelectable = multipleSelectable;
    }

    public int getVisibleRows() {
        return this.visibleRows;
    }

    public void setVisibleRows(int visibleRows) {
        this.visibleRows = visibleRows;
    }

    public boolean hasLayer(Layer layer) {
        if (layer != null) {
            for (Layer memberLayer : this.layers) {
                if (!Layer.equals(memberLayer, layer)) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<Layer> getLayers() {
        return Collections.unmodifiableCollection(this.layers);
    }

    public void setLayers(Collection<Layer> layers) {
        this.layers.clear();
        if (layers != null) {
            this.layers.addAll(layers);
        }
    }

    public Layer getLayer(String layerId) {
        if (layerId == null) {
            return null;
        }
        for (Layer layer : this.layers) {
            if (!layer.getId().equals(layerId)) continue;
            return layer;
        }
        return null;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getLocalizedCategoryName() {
        return this.localizedCategoryName;
    }

    public void setLocalizedCategoryName(String localizedCategoryName) {
        if (localizedCategoryName == null || localizedCategoryName.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.localizedCategoryName = localizedCategoryName.trim();
    }

    public int hashCode() {
        return this.categoryId.hashCode();
    }

    public String toString() {
        return this.getLocalizedCategoryName();
    }
}

