/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import charactermanaj.graphics.io.PNGFileImageHeader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;

public class PNGFileImageHeaderReader {
    public static final byte[] FILE_HEADER = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final PNGFileImageHeaderReader singletion = new PNGFileImageHeaderReader();

    private PNGFileImageHeaderReader() {
    }

    public static PNGFileImageHeaderReader getInstance() {
        return singletion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PNGFileImageHeader readHeader(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        InputStream is = url.openStream();
        try {
            PNGFileImageHeader pNGFileImageHeader = this.readHeader(is);
            return pNGFileImageHeader;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PNGFileImageHeader readHeader(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            PNGFileImageHeader pNGFileImageHeader = this.readHeader(is);
            return pNGFileImageHeader;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public PNGFileImageHeader readHeader(InputStream is) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException();
        }
        DataInputStream dis = new DataInputStream(is);
        try {
            byte[] fileHeader = new byte[FILE_HEADER.length];
            dis.readFully(fileHeader);
            if (!Arrays.equals(fileHeader, FILE_HEADER)) {
                return null;
            }
            PNGFileImageHeader imageHeader = null;
            boolean hasTransparencyInfomation = false;
            while (true) {
                int chunkLen = dis.readInt();
                byte[] chunkType = new byte[4];
                dis.readFully(chunkType);
                if (Arrays.equals(chunkType, "IHDR".getBytes())) {
                    imageHeader = new PNGFileImageHeader();
                    imageHeader.setWidth(dis.readInt());
                    imageHeader.setHeight(dis.readInt());
                    imageHeader.setBitDepth(dis.readByte() & 0xFF);
                    imageHeader.setColorType(dis.readByte() & 0xFF);
                    imageHeader.setCompressionMethod(dis.readByte() & 0xFF);
                    imageHeader.setFilterMethod(dis.readByte() & 0xFF);
                    imageHeader.setInterlaceMethod(dis.readByte() & 0xFF);
                    int zan = chunkLen - 13;
                    if (zan < 0) {
                        throw new EOFException("IHDR too short");
                    }
                    dis.skipBytes(zan);
                } else if (Arrays.equals(chunkType, "tRNS".getBytes())) {
                    hasTransparencyInfomation = chunkLen > 0;
                    dis.skipBytes(chunkLen);
                } else {
                    if (Arrays.equals(chunkType, "IEND".getBytes())) break;
                    dis.skipBytes(chunkLen);
                }
                dis.readInt();
            }
            if (imageHeader != null) {
                imageHeader.setTransparencyInformation(hasTransparencyInfomation);
            }
            return imageHeader;
        }
        catch (EOFException eOFException) {
            return null;
        }
    }
}

