/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics;

import charactermanaj.graphics.ColorConvertedImageCache;
import charactermanaj.graphics.filters.ColorConvertFilter;
import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.filters.GammaTableFactory;
import charactermanaj.graphics.io.ImageCachedLoader;
import charactermanaj.graphics.io.ImageResource;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class ColorConvertedImageCachedLoader {
    public static final int MAX_CACHE = 20;
    public static final long DEFAULT_SWEEP_THRESHOLD = 60000L;
    private int cacheSize;
    private LinkedList<ColorConvertedImageCache> caches = new LinkedList();
    private ImageCachedLoader loader;

    public ColorConvertedImageCachedLoader() {
        this(20, 60000L);
    }

    public ColorConvertedImageCachedLoader(int cacheSize, long sweepThreshold) {
        if (cacheSize < 1) {
            cacheSize = 1;
        }
        this.cacheSize = cacheSize;
        this.loader = new ImageCachedLoader(cacheSize, sweepThreshold);
    }

    public BufferedImage load(ImageResource file, ColorConvertParameter colorConvParam) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (colorConvParam == null) {
            colorConvParam = new ColorConvertParameter();
        }
        long lastModified = file.lastModified();
        Iterator ite = this.caches.iterator();
        while (ite.hasNext()) {
            ColorConvertedImageCache cache = (ColorConvertedImageCache)ite.next();
            if (!((Object)file).equals(cache.getImageResource())) continue;
            ite.remove();
            if (cache.getLastModified() != lastModified || !cache.getColorConvParam().equals(colorConvParam)) break;
            this.caches.addFirst(cache);
            this.loader.sweep();
            return cache.getImage();
        }
        colorConvParam = colorConvParam.clone();
        BufferedImage img = this.loader.load(file);
        img = this.colorConvert(img, colorConvParam);
        ColorConvertedImageCache cache = new ColorConvertedImageCache();
        cache.setImageResource(file);
        cache.setLastModified(lastModified);
        cache.setImage(img);
        cache.setColorConvParam(colorConvParam);
        this.caches.addFirst(cache);
        while (this.caches.size() > this.cacheSize) {
            this.caches.removeLast();
        }
        return img;
    }

    protected BufferedImage colorConvert(BufferedImage img, ColorConvertParameter param) {
        float[] factors = new float[]{param.getFactorR(), param.getFactorG(), param.getFactorB(), param.getFactorA()};
        float[] offsets = new float[]{param.getOffsetR(), param.getOffsetG(), param.getOffsetB(), param.getOffsetA()};
        RescaleOp rescale_op = new RescaleOp(factors, offsets, null);
        float[] gammas = new float[]{param.getGammaA(), param.getGammaR(), param.getGammaG(), param.getGammaB()};
        float[] hsbs = new float[]{param.getHue(), param.getSaturation(), param.getBrightness()};
        ColorConvertFilter colorConvert_op = new ColorConvertFilter(param.getColorReplace(), hsbs, param.getGrayLevel(), new GammaTableFactory(gammas));
        img = colorConvert_op.filter(img, null);
        img = rescale_op.filter(img, img);
        return img;
    }
}

