/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.clipboardSupport;

import charactermanaj.graphics.io.ImageSaveHelper;
import java.awt.Color;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class ImageSelection
implements Transferable {
    private BufferedImage img;
    private Color bgColor;
    public static final DataFlavor bufferedImageDataFlavor = new DataFlavor(BufferedImage.class, null);

    public ImageSelection(BufferedImage img, Color bgColor) {
        if (img == null) {
            throw new IllegalArgumentException();
        }
        this.img = img;
        this.bgColor = bgColor == null ? Color.white : bgColor;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor != null && flavor.equals(DataFlavor.imageFlavor)) {
            ImageSaveHelper imageSaveHelper = new ImageSaveHelper();
            return imageSaveHelper.createJpegFormatPicture(this.img, this.bgColor);
        }
        if (flavor != null && flavor.equals(bufferedImageDataFlavor)) {
            return this.img;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.imageFlavor, bufferedImageDataFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor != null && (flavor.equals(DataFlavor.imageFlavor) || flavor.equals(bufferedImageDataFlavor));
    }
}

