if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'cgikit/command'
	require 'TestApp/app'
	require 'TestApp/StringPage/StringPage'
	require 'TestApp/LinkPage/LinkPage'
	require 'test_common'
end


class TestElementLink < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@app.main = LinkPage
		@does_test_other = true
	end

	def test_api_nothing_bound
		dec = {:TestAPI => {:element=>Link}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_api_either_bound
		dec = {:TestAPI => {:element=>Link, :action=>:action, :href=>:href, :page=>:page}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_api_page_bound
		dec = {:TestAPI => {:element=>Link, :page=>:page}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_api_action_bound
		dec = {:TestAPI => {:element=>Link, :action=>:actio}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_api_href_bound
		dec = {:TestAPI => {:element=>Link, :href=>:href}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_api_direct_action_with_action_class
		dec = {:TestAPI => {:element=>Link, :direct_action=>'default',
			 :action_class=>DirectAction}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_api_direct_action_without_action_class
		dec = {:TestAPI => {:element=>Link, :direct_action=>'default'}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	# enabled, href, string, secure, query
	def test_non_action_attributes
		response = @app.run
		command = Command.new(response)
		assert_nil(command.link(LinkPage::TEST_ENABLED_NAME))
		assert(LinkPage.test_string(command.link(LinkPage::TEST_STRING_NAME)))
		assert(LinkPage.test_href(command.link(LinkPage::TEST_HREF_NAME)))
		assert(LinkPage.test_secure(command.link(LinkPage::TEST_SECURE_NAME)))
		assert(LinkPage.test_query(command.link(LinkPage::TEST_QUERY_NAME)))
	end

	def test_page
		response = @app.run
		command = Command.new(response)
		command.link(LinkPage::TEST_PAGE_NAME).submit
		response = @app.run(command)
		assert_equal(LinkPage::TEST_PAGE, response.component.class)
	end

	def test_action
		response = @app.run
		command = Command.new(response)
		command.link(LinkPage::TEST_ACTION_NAME).submit
		response = @app.run(command)
		assert(LinkPage.test_action(response.content))
	end

	def test_direct_action
		response = @app.run
		command = Command.new(response)
		command.link(LinkPage::TEST_DIRECT_ACTION_NAME).submit
		response = @app.run(command)
		assert(LinkPageDirectAction.test_direct_action(response.content))
	end

	def test_escape
		response = @app.run
		pattern = /#{LinkPage::TEST_ESCAPE}/
		assert_no_match(pattern, response.content)
	end

end


if __FILE__ == $0 then
	suite = TestElementLink.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
