if __FILE__ == $0
  $LOAD_PATH.unshift '../lib' 
  require 'test/unit'
  require 'test/unit/ui/console/testrunner'
  require 'cgikit'
  require 'tempfile'
end

class TestByteData < Test::Unit::TestCase

  include CGIKit

end


class TestTempfileByteData < Test::Unit::TestCase

  include CGIKit

  def setup
    @str = 'dummydata'
    @tmp = Tempfile.new('test')
    @tmp.write(@str)
    @data = TempfileByteData.new(@tmp)
  end

  def test_tempfile?
    assert(@data.tempfile?)
  end

  def test_bytes
    assert_equal(@str, @data.bytes)
  end

  def test_write
    append = 'append'
    @data << append
    assert_equal(@str + append, @data.bytes)
  end

end

if __FILE__ == $0 then
  suite = Test::Unit::TestSuite.new
  #suite << TestByteData.suite
  suite << TestTempfileByteData.suite
  runner = Test::Unit::UI::Console::TestRunner.new suite
  runner.start
end
