require 'webrick/httpservlet/abstract'

module CGIKit::Adapter

  # The adapter and WEBrick::CGIKitServlet are for WEBrick
  # writtend by Ken-ichi HASHIMOTO and Shinya Kawaji. Thanks!
  class WEBrick
    GENERAL_HEADER = %w[
      Cache-Control
      Connection
      Date
      Pragma
      Trailer
      Transfet-Encoding
      Upgrade
      Via
      Warning
    ]

    RESPONSE_HEADER = %w[
      Accept-Ranges
      Age
      ETag
      Location
      Proxy-Authenticate
      Retry-After
      Server
      Vary
      WWW-Authenticate
    ]

    ENTITY_HEADER = %w[
      Allow
      Content-Encoding
      Content-Language
      Content-Length
      Content-Location
      Content-MD5
      Content-Range
      Content-Disposition
      Expires
      Last-Modified
    ]

    LEAVE_HEADER = {}
    (GENERAL_HEADER + RESPONSE_HEADER + ENTITY_HEADER).each{|key|
      LEAVE_HEADER[key] = true
    }

    def run(request, response)
      # set request
      headers = request.meta_vars
      
      ##############################################################################
      # This implementation is DANGEROUS and not elemegant. If WEBrick is updated, #
      # it is necessary to modify these lines.                                     #
      ##############################################################################
      
      input = request.instance_variable_get('@socket')
      # Why is this line needed?
      request.instance_variable_set('@socket', nil)
      
      params = CGIKit::Utilities.query_from_headers(headers, input)
      ckrequest = CGIKit::Request.new(headers, params)
      
      # run
      if block_given?
        ckresponse = yield(ckrequest)
      end

      # set response
      response.request_http_version = ckresponse.http_version
      response.status = ckresponse.status
      ckresponse.headers.each{|key, val|
        if LEAVE_HEADER[key]
          response[key] = val
        end
      }
      response['Content-Type'] = ckresponse.headers['Content-Type']
      if ckresponse.encoding
        response['Content-Type'] << "; charset=#{ckresponse.encoding}"
      end
      ckresponse.cookies.each{|cookie|
        response.cookies << cookie
      }

      response.body = ckresponse.content
    end
  end
end

module WEBrick
  module CGIKitServlet

    class ApplicationHandler < HTTPServlet::AbstractServlet
      def initialize(server, app)
        @app = app
        @app.adapter_class = CGIKit::Adapter::WEBrick
        @app.session_store_class = CGIKit::MemorySessionStore
        @app.template_store_class = CGIKit::MemoryTemplateStore
        @app.resource_store_class = CGIKit::MemoryResourceStore
      end

      def do_GET(req, res)
        @app.run(req, res)
      end
      alias_method :do_POST, :do_GET
    end

    class PathHandler < ApplicationHandler
      def initialize(server, component_path, app = Application.new)
        app.component_path = component_path
        super(server, app)
      end
    end

    class HashHandler < ApplicationHandler
      def initialize(server, hash, app = Application.new)
        app.take_values_from_hash(hash)
        super(server, app)
      end
    end
  end
end

