module CGIKit

  module RSS

    class AutoDiscovery < DynamicElement

      class << self

        def create_api
          api = API.new(:AutoDiscovery)
          title = Binding.new(:title)
          title.default = 'RSS'
          href = Binding.new(:href)
          api << title
          api << href
          api << Binding.new(:rss_action)
          api << Binding.new(:rss_class)
          api
        end

      end

      def append_to_response( response, context )
        take_value(:title)
        take_value(:href)
        take_value(:rss_action, false)
        take_value(:rss_class)

        unless url = @values[:href] then
          context.rss_action_url(@values[:rss_class], @values[:rss_action])
        end
        str = "<link rel=\"alternate\" type=\"application/rss+xml\" "
        str << "title=\"#{@values[:title]}\" "
        str << "href=\"#{url}\">"
        response.content << str
      end

    end

  end

end
