module CGIKit::Project

  class ModRubyScriptTemplate < ScriptTemplate

    def template_ja
      <<EOF
#!#{@project.ruby_path}

$LOAD_PATH.unshift('lib')
require 'cgikit'
require 'cgikit/lang/ja'
require 'cgikit/rss'
require 'cgikit/ajax'
require 'application'
require 'session'
require 'directaction'
require 'rssaction'
require 'ajaxaction'

app = #{@project.application.class_name}.new
app.adapter_class = CGIKit::Adapter::ModRuby
app.session_store_class = CGIKit::FileSessionStore
app.template_store_class = CGIKit::FileTemplateStore
app.resource_store_class = CGIKit::FileResourceStore
app.load_all_components('#{ComponentTemplate::COMPONENT_LIB}')
app.load_configuration('#{ConfigurationTemplate::CONF_FILE}')
app.run
EOF
    end

  end

end

