module CGIKit::Project

  class ConfigurationTemplate < Template

    def template_ja
      <<EOF
module #{@project.name}

  class Application < CGIKit::Application

    def configure
      configure_package
      configure_component
      configure_session
      configure_paths
      configure_localization
      configure_request_handlers
      configure_classes
    end


    # ѥå
    def configure_package

      # ѥåΥ:
      # ɤѥåꤷޤ
      # ( packages/ ʲΥѥåϼưŪ˥ɤޤ)
      # @required_packages = []

      # ᥤѥåΥץ:
      # ᥤѥå (Υץꥱ) Υɤ˴ؤǤ
      # ckprojectȤä硢ꤹɬפϤޤ
      #
      # :component_load_type
      #   ݡͥȤΥɡ'autoload'  'require' ꤹ롣
      #   ǥեȤ 'require' 
      # :package_class_name
      #   ݡͥȥ饹 'autoload' ݤ˻Ȥ⥸塼̾
      #
      # @main_package_options = {}

    end


    # ݡͥȤ
    def configure_component

      # ᥤڡ:
      # ǽ˥ץꥱ˥줿ʥåID
      # ƥIDꤵƤʤˤȤɽ륳ݡͥȤǤ
      @main = #{@project.name}::MainPage

      # 顼ڡ:
      # 㳰­Ȥɽ륳ݡͥȤǤ
      @error_page = CGIKit::ErrorPage

      # ƥץ졼ȤΥå:
      # ƥץ졼Ȥ򥭥å夷ơϤ٤ڸޤ
      @cache_template = true

      # Ȥ°θ:
      # Ȥ°ŬڤꤵƤ뤫ڤޤ
      # true ˤȡȤ°̾Ȥ߹碌ְäƤХ顼ˤʤޤ
      @validate_api = true

    end


    # å
    def configure_session

      # ڡå奵:
      # å˥å夵ڡʥݡͥȥ֥ȡˤοǤ
      # 줿ڡϼưŪ˥å夵ޤ
      # ڡꤷĶȡŤڡޤ
      @page_cache_size = 30

      # ³ڡå奵:
      # å˥å夵ڡʥݡͥȥ֥ȡˤοǤ
      # ̾μưŪʥåȤϰۤʤꡢ
      # ݴɤƤڡǤդǥå夷ޤ
      # ڡꤷĶȡŤڡޤ
      @permanent_page_cache_size = 30

      # ॢ:
      # å󤬥ॢȤޤǤÿǤ
      @timeout = 60 * 60 * 24 * 7

      # åͭ:
      # åIDݻ˻Ȥåͭ¤Ǥ
      # nil ꤹȥ֥饦νλƱ̵ˤʤޤ
      @session_cookie_expires = 60 * 60 * 24 * 7

      # URLȤåIDݴ:
      # åIDURL˴ޤ뤫ɤꤷޤ
      @store_in_url = true

      # åȤåIDݴ:
      # åID򥯥å˴ޤ뤫ɤꤷޤ
      @store_in_cookie = false

      # ֥饦ˤ륻åǧ:
      # true ꤹȡåȰۤʤ֥饦
      # Ȥ㳰ȯޤ
      @auth_by_user_agent = false

      # IPɥ쥹ˤ륻åǧ:
      # true ꤹȡåȰۤʤIPɥ쥹
      # Ȥ㳰ȯޤ
      @auth_by_remote_addr = false

      # å󥭡:
      # åIDФ륭ǤåǻȤޤ
      @session_key = '_session_id'

      # 쥯ȥΥå󥭡:
      # åIDФ륭Ǥ
      # 쥯ȥURLȥեαåեɤΥ˻Ȥޤ
      @direct_action_session_key = '_sid'

      # åѥѥ:
      # åڡΥѥɤǤ
      # nilˤȡåڡ̵ˤʤޤ
      # åڡ "#{CGIKit::DirectAction::SWEEP_ACTION_NAME}" 쥯ȥǤ
      @sweep_password = nil

    end


    # Ƽѥ
    def configure_paths

      # ݡͥȤΥѥ:
      # ݡͥȤ֤ѥǤݡͥȤϤΥѥ鸡ޤ
      @component_path = 'components'

      # ɥȥ롼ȥǥ쥯ȥ:
      # WebФΥɥȥ롼ȥǥ쥯ȥǤ
      # @document_root = '/var/www/htdocs'

      # ꥽ǥ쥯ȥ:
      # ץꥱǻȤΥե֤ǥ쥯ȥǤ
      @resource_path = 'resources'

      # WebХ꥽ǥ쥯ȥ:
      # ֥饦ɽ뤿Υե֤ǥ쥯ȥǤ
      # ImageȤʤɤǻȤޤ
      @web_server_resource_path = 'www'

      # Ūʥǥ쥯ȥ:
      # ե졼ȤŪʥǥ쥯ȥǤ
      # åƥץ졼ȤΥå¸Τ˻Ȥޤ
      @tmpdir = './tmp' || ENV['TMP'] || ENV['TEMP']

    end


    # ݲ
    def configure_localization

      # 󥳡ǥ:
      # եǡΥ󥳡ǥ󥰻Ǥ
      # Kconv::JIS, Kconv::SJIS, Kconv::EUC Τɤ줫ꤷޤ
      # @encoding = Kconv::EUC

    end


    # פʥ饹
    def configure_classes

      # 쥯ȥ󥯥饹:
      @direct_action_class = #{@project.direct_action.class_name}

      # å󥯥饹:
      @session_class = #{@project.session.class_name}

      # ƥȥ饹:
      # @context_class = CGIKit::Context

      # HTMLѡ饹:
      # @htmlparser_class = CGIKit::HTMLParser::HTMLParser

    end


    # ꥯȥϥɥ
    def configure_request_handlers

      # ݡͥȥꥯȥϥɥ饭:
      @component_request_handler_key = 'c'

      # 쥯ȥꥯȥϥɥ饭:
      @direct_action_request_handler_key = 'd'

      # ꥽ꥯȥϥɥ饭:
      @resource_request_handler_key = 'r'

      # ݡͥȥꥯȥϥɥ:
      # @component_request_handler = CGIKit::ComponentRequestHandler.new(self)

      # 쥯ȥꥯȥϥɥ:
      # @direct_action_request_handler = CGIKit::DirectActionRequestHandler.new(self)

      # ꥽ꥯȥϥɥ:
      # @resource_request_handler = ResourceRequestHandler.new(self)

      # ǥեȥꥯȥϥɥ:
      # ꥯȥϥɥ饭ꤵƤʤȤ˻ȤϥɥǤ
      # 쥯ȥꥯȥϥɥꤹȡ
      # ץꥱ˺ǽ˥Ȥ
      # ǥեȤΥ쥯ȥ¹Ԥ뤳ȤǤޤ
      # ǥեȤϥݡͥȥꥯȥϥɥǤ
      # @default_request_handler = @component_request_handler

    end

  end

end
EOF
    end

  end

end

